/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WeatherVelocityProfiler
extends GenericObjectListener
implements Java2D_PaintableInterface {
    protected Color m_dotColor = new Color(0, 0, 255, 100);
    protected Color m_lineColor = new Color(0, 0, 255, 100);
    protected ArrayList<Location> m_list = new ArrayList();
    protected Location m_currentLocation;
    protected String m_fileName;
    protected Table_Abstract m_currentTable = null;
    public double m_defaultVelocity = 3000.0;
    public double m_smoothRadius = 100.0;

    public Location currentLocation() {
        return this.m_currentLocation;
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileName = fileName;
            this.read();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public Table_Abstract currentTable() {
        return this.m_currentTable;
    }

    public static String getComputedThickness(int layer) {
        return String.format("COMPUTED_THICKNESS_%d", layer);
    }

    public static String getComputedElevation(int branch) {
        return String.format("COMPUTED_ELEVATION_%d", branch);
    }

    public static String getComputedGravity() {
        return "COMPUTED_GRAVITY";
    }

    public WeatherVelocityProfiler() {
        try {
            if (!RefractionStaticsProject.singleton().units_feet()) {
                this.m_defaultVelocity = 1000.0;
                this.m_smoothRadius = 30.0;
            } else {
                this.m_defaultVelocity = 3000.0;
                this.m_smoothRadius = 100.0;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int size() {
        return this.m_list.size();
    }

    public void prepCurrentTable() {
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.m_currentTable = null;
            if (this.m_currentLocation == null) {
                return;
            }
            this.m_currentTable = new Table_Memory();
            this.m_currentTable.setName("Interpolated");
            int numPoints = 200;
            double x1 = this.m_currentLocation.CenterX - this.m_currentLocation.DeltaX;
            double y1 = this.m_currentLocation.CenterY - this.m_currentLocation.DeltaY;
            double dx = 2.0 * this.m_currentLocation.DeltaX / (double)(numPoints - 1);
            double dy = 2.0 * this.m_currentLocation.DeltaY / (double)(numPoints - 1);
            int indexX = this.m_currentTable.column_append("Easting", DataType.Double);
            int indexY = this.m_currentTable.column_append("Northing", DataType.Double);
            for (int n = 0; n < numPoints; ++n) {
                int row = this.m_currentTable.row_increment();
                this.m_currentTable.putDouble(row, indexX, x1 + dx * (double)n);
                this.m_currentTable.putDouble(row, indexY, y1 + dy * (double)n);
            }
            Tools_RefractionStaticsProject.computeInterpolatedTable(this.m_currentTable, this.m_smoothRadius, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addLocation(double x, double y, double dx, double dy) {
        try {
            this.m_currentLocation = new Location();
            this.m_currentLocation.CenterX = x;
            this.m_currentLocation.CenterY = y;
            this.m_currentLocation.DeltaX = dx;
            this.m_currentLocation.DeltaY = dy;
            this.m_currentLocation.V0 = this.getInterpolatedVelocity(x, y);
            this.m_list.add(this.m_currentLocation);
            this.prepCurrentTable();
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void deleteLocation(int px, int py) {
        try {
            if (this.m_list.size() < 1) {
                return;
            }
            Location nearest = null;
            int minDist = 100000000;
            for (Location loc : this.m_list) {
                int dist = Math.abs(px - loc.PixelX) + Math.abs(py - loc.PixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = loc;
            }
            this.m_list.remove(nearest);
            this.save();
            if (nearest == this.m_currentLocation) {
                this.m_currentLocation = null;
                this.prepCurrentTable();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void selectLocation(int px, int py) {
        try {
            this.m_currentLocation = null;
            this.m_currentTable = null;
            if (this.m_list.size() < 1) {
                return;
            }
            int minDist = 100000000;
            for (Location loc : this.m_list) {
                int dist = Math.abs(px - loc.PixelX) + Math.abs(py - loc.PixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                this.m_currentLocation = loc;
            }
            this.prepCurrentTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void export() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.export(p.shotTable(), Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), Pecos.getColNameVel(0));
            this.export(p.receiverTable(), Pecos.getColNameVel(0));
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), Pecos.getColNameVel(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void export(Table_Abstract table, String colName) {
        try {
            int index = table.column_append(colName, DataType.Double);
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            for (int row = 0; row < table.row_count(); ++row) {
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                double v = this.getInterpolatedVelocity(x, y);
                table.putDouble(row, index, v);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double getInterpolatedVelocity(double x, double y) {
        try {
            if (this.m_list.size() < 1) {
                return this.m_defaultVelocity;
            }
            double sum1 = 0.0;
            double sum2 = 1.0E-40;
            for (Location loc : this.m_list) {
                double dx = x - loc.CenterX;
                double dy = y - loc.CenterY;
                double w = 10.0 / (10.0 + dx * dx + dy * dy);
                w *= w;
                sum1 += w * loc.V0;
                sum2 += w;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return this.m_defaultVelocity;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    protected void mapPaint(Java2D_PaintParameter paintParameter, Object supplementalData) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(Color.green);
            int size = 15;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            g2d.setColor(this.m_dotColor);
            for (Location loc : this.m_list) {
                transform.drawLine(g2d, loc.CenterX - loc.DeltaX, loc.CenterY - loc.DeltaY, loc.CenterX + loc.DeltaX, loc.CenterY + loc.DeltaY);
                loc.PixelX = (int)(scaleX * loc.CenterX + shiftX);
                loc.PixelY = (int)(scaleY * loc.CenterY + shiftY);
                g2d.fillOval(loc.PixelX - h, loc.PixelY - h, size, size);
            }
            if (this.m_currentLocation != null) {
                g2d.setColor(Color.red);
                Location loc = this.m_currentLocation;
                transform.drawLine(g2d, loc.CenterX - loc.DeltaX, loc.CenterY - loc.DeltaY, loc.CenterX + loc.DeltaX, loc.CenterY + loc.DeltaY);
                g2d.fillOval(loc.PixelX - h, loc.PixelY - h, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.mapPaint(paintParameter, supplementalData);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    public void save() throws Exception {
        try {
            if (this.m_fileName == null) {
                return;
            }
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("ProfileLocations");
            document.appendChild(root);
            this.writeToNode(root);
            Tools_XML.writeDocumentToFile(document, this.m_fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void read() {
        try {
            if (this.m_fileName == null) {
                return;
            }
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(this.m_fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNode(root);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readFromNode(Element node) throws Exception {
        try {
            this.m_list.clear();
            ArrayList<Element> locationNodes = Tools_XML.getChildListWithTagName(node, "Location");
            for (Element locationElement : locationNodes) {
                Location location = new Location();
                this.m_list.add(location);
                location.CenterX = Tools_XML.getDouble(locationElement, "X", -9999.0);
                location.CenterY = Tools_XML.getDouble(locationElement, "Y", -9999.0);
                location.DeltaX = Tools_XML.getDouble(locationElement, "DeltaX", 0.0);
                location.DeltaY = Tools_XML.getDouble(locationElement, "DeltaY", 0.0);
                location.V0 = Tools_XML.getDouble(locationElement, "V0", 2000.0);
            }
            if (this.m_list.size() >= 1) {
                this.m_currentLocation = this.m_list.get(0);
                this.prepCurrentTable();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            for (Location location : this.m_list) {
                Element locationNode = node.getOwnerDocument().createElement("Location");
                locationNode.setAttribute("X", Tools_Strings.getString(location.CenterX, 1));
                locationNode.setAttribute("Y", Tools_Strings.getString(location.CenterY, 1));
                locationNode.setAttribute("DeltaX", Tools_Strings.getString(location.DeltaX, 1));
                locationNode.setAttribute("DeltaY", Tools_Strings.getString(location.DeltaY, 1));
                locationNode.setAttribute("V0", Tools_Strings.getString(location.V0, 1));
                node.appendChild(locationNode);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public class Location {
        public double CenterX;
        public double CenterY;
        public double DeltaX;
        public double DeltaY;
        public double V0;
        public int PixelX;
        public int PixelY;
    }
}

