/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import javax.swing.JOptionPane;

public class Tools_DelayTime {
    protected static Tools_DelayTime m_singleton = null;
    protected double[] m_sumError = new double[10];
    protected double[] m_sumDelayTime = new double[10];
    protected double[] m_sumWeight = new double[10];

    protected Tools_DelayTime() {
    }

    public static Tools_DelayTime singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Tools_DelayTime();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void copyBranchData(int fromBranch, int toBranch) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            BranchAssignment branchAss = dtd.branchAssignment();
            int maxBranch = branchAss.maxBranch();
            if (toBranch < 1 || toBranch > maxBranch) {
                return;
            }
            if (fromBranch < 1 || fromBranch > maxBranch) {
                return;
            }
            if (toBranch == fromBranch) {
                return;
            }
            Object s = String.format("Do you want to overwrite refractor %d data with refractor %d data?", toBranch, fromBranch);
            int res = JOptionPane.showConfirmDialog(null, s = (String)s + "\nTHIS ACTION CANNOT BE UNDONE!!!!", "THIS ACTION CANNOT BE UNDONE!!!!", 0);
            if (res != 0) {
                return;
            }
            boolean delete = fromBranch == maxBranch;
            branchAss.copy(fromBranch, toBranch);
            dtd.saveBranchAssignment();
            this.copyColumn(Pecos.getColNameDT(fromBranch), Pecos.getColNameDT(toBranch));
            this.copyColumn(Pecos.getColNameDtAnisAz(fromBranch), Pecos.getColNameDtAnisAz(toBranch));
            this.copyColumn(Pecos.getColNameDtAnisMag(fromBranch), Pecos.getColNameDtAnisMag(toBranch));
            this.copyColumn(Pecos.getColNameElev(fromBranch), Pecos.getColNameElev(toBranch));
            this.copyColumn(Pecos.getColNameError(fromBranch), Pecos.getColNameError(toBranch));
            this.copyColumn(Pecos.getColNameVel(fromBranch), Pecos.getColNameVel(toBranch));
            if (delete) {
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDT(fromBranch));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDtAnisAz(fromBranch));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameDtAnisMag(fromBranch));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameElev(fromBranch));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameError(fromBranch));
                p.geometryDatabase().dropColumn("Receiver", Pecos.getColNameVel(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDT(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDtAnisAz(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameDtAnisMag(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameElev(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameError(fromBranch));
                p.geometryDatabase().dropColumn("Shot", Pecos.getColNameVel(fromBranch));
            }
            p.reloadAllData();
            Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void copyColumn(String colFrom, String colTo) {
        try {
            System.out.println("copyColumn " + colFrom + " to " + colTo);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (p.receiverTable().column_exists(colFrom)) {
                p.receiverTable().column_copy_double(colFrom, colTo);
                p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), colTo);
            }
            if (p.shotTable().column_exists(colFrom)) {
                p.shotTable().column_copy_double(colFrom, colTo);
                p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), colTo);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeCurrentPickErrors(Ensemble ensemble) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            boolean numOkay = false;
            if (ensemble == null) {
                return;
            }
            if (dtd.branchAssignment().maxBranch() < 1) {
                return;
            }
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            int indexBranch = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            ensemble.prepDelayTimeAnalysisIndices();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                EnsembleTrace.DelayTimePickError pickErrorData = ensemble.trace(n).delayTimePickErrorData();
                pickErrorData.Branch = header.getInt(indexBranch);
                pickErrorData.PickError = -9999.0f;
                float pick = header.getFloat(indexPick);
                if (pickErrorData.Branch < 1 || !(pick > 0.1f) || ensemble.trace((int)n).TraceKilled) continue;
                double sx = header.getDouble(indexShotX);
                double sy = header.getDouble(indexShotY);
                double rx = header.getDouble(indexRecX);
                double ry = header.getDouble(indexRecY);
                double dx = rx - sx;
                double dy = ry - sy;
                float offset = (float)Math.sqrt(dx * dx + dy * dy + 1.0E-40);
                float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[pickErrorData.Branch]);
                float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[pickErrorData.Branch]);
                float vel = 0.5f * (recVel + shotVel);
                float travelTime = 1000.0f * offset / vel;
                float shotDT = (float)header.getDouble(ensemble.HeaderIndex_ShotDT[pickErrorData.Branch]);
                float recDT = (float)header.getDouble(ensemble.HeaderIndex_RecDT[pickErrorData.Branch]);
                float upholeCorrection = header.getFloat(indexUpholeCorr);
                float wbCorrection = header.getFloat(indexWbCorr);
                pick = pick + upholeCorrection + wbCorrection;
                float error = pick - (travelTime + shotDT + recDT);
                pickErrorData.PickError = Math.abs(error);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean updateDelayTime_Rec(Ensemble ensemble, boolean writeToDatabase) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            boolean numOkay = false;
            if (ensemble == null) {
                return false;
            }
            if (dtd.branchAssignment().maxBranch() < 1) {
                return false;
            }
            int recID = Tools_Ensemble.isReceiverEnsemble(ensemble);
            if (recID < 1) {
                return false;
            }
            for (int b = 0; b < this.m_sumDelayTime.length; ++b) {
                this.m_sumError[b] = 0.0;
                this.m_sumDelayTime[b] = 0.0;
                this.m_sumWeight[b] = 1.0E-40;
            }
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            int indexBranch = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            ensemble.prepDelayTimeAnalysisIndices();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int branch = header.getInt(indexBranch);
                float pick = header.getFloat(indexPick);
                if (branch < 1 || !(pick > 0.1f) || ensemble.trace((int)n).TraceKilled) continue;
                double sx = header.getDouble(indexShotX);
                double sy = header.getDouble(indexShotY);
                double rx = header.getDouble(indexRecX);
                double ry = header.getDouble(indexRecY);
                double dx = rx - sx;
                double dy = ry - sy;
                float offset = (float)Math.sqrt(dx * dx + dy * dy + 1.0E-40);
                float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[branch]);
                float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[branch]);
                float vel = 0.5f * (recVel + shotVel);
                float travelTime = 1000.0f * offset / vel;
                float shotDT = (float)header.getDouble(ensemble.HeaderIndex_ShotDT[branch]);
                float recDT = (float)header.getDouble(ensemble.HeaderIndex_RecDT[branch]);
                float upholeCorrection = header.getFloat(indexUpholeCorr);
                float wbCorrection = header.getFloat(indexWbCorr);
                pick = pick + upholeCorrection + wbCorrection;
                float error = pick - (travelTime + shotDT + recDT);
                float ratio = Math.abs(error) / 20.0f;
                double weight = 1.0 / (1.0 + (double)(ratio * ratio));
                float predictedDelayTime = pick - travelTime - shotDT;
                predictedDelayTime = Math.max(predictedDelayTime, 0.0f);
                this.m_sumError[branch] = this.m_sumError[branch] + (double)Math.abs(error) * weight;
                this.m_sumDelayTime[branch] = this.m_sumDelayTime[branch] + (double)predictedDelayTime * weight;
                this.m_sumWeight[branch] = this.m_sumWeight[branch] + weight;
            }
            boolean modified = false;
            for (int b = 0; b < this.m_sumDelayTime.length; ++b) {
                if (!(this.m_sumWeight[b] > 0.5)) continue;
                modified = true;
                double dt = this.m_sumDelayTime[b] / this.m_sumWeight[b];
                double err = this.m_sumError[b] / this.m_sumWeight[b];
                int errIndex = ensemble.dictionary().getEntryIndex("Receiver", Pecos.getColNameError(b));
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    header.putDouble(ensemble.HeaderIndex_RecDT[b], dt);
                    header.putDouble(errIndex, err);
                }
                if (!writeToDatabase) continue;
                String colName = Pecos.getColNameDT(b);
                int recRow = p.receiverMap().get(recID);
                int col = p.receiverTable().column_indexOfColumn(colName);
                p.receiverTable().putDouble(recRow, col, dt);
                String sql = String.format("UPDATE RECEIVER SET %s = %f WHERE RECEIVERID = %d", colName, dt, recID);
                p.geometryDatabase().executeUpdateStatement(sql);
                colName = Pecos.getColNameError(b);
                col = p.receiverTable().column_indexOfColumn(colName);
                p.receiverTable().putDouble(recRow, col, err);
                sql = String.format("UPDATE RECEIVER SET %s = %f WHERE RECEIVERID = %d", colName, err, recID);
                p.geometryDatabase().executeUpdateStatement(sql);
            }
            return modified;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean updateDelayTime_Shot(Ensemble ensemble, boolean writeToDatabase) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            boolean numOkay = false;
            if (ensemble == null) {
                return false;
            }
            if (dtd.branchAssignment().maxBranch() < 1) {
                return false;
            }
            int shotID = Tools_Ensemble.isShotEnsemble(ensemble);
            if (shotID < 1) {
                return false;
            }
            for (int b = 0; b < this.m_sumDelayTime.length; ++b) {
                this.m_sumError[b] = 0.0;
                this.m_sumDelayTime[b] = 0.0;
                this.m_sumWeight[b] = 1.0E-40;
            }
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            int indexBranch = ensemble.dictionary().getEntryIndex("Trace", "Branch_DelayTime");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            ensemble.prepDelayTimeAnalysisIndices();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int branch = header.getInt(indexBranch);
                float pick = header.getFloat(indexPick);
                if (branch < 1 || !(pick > 0.1f) || ensemble.trace((int)n).TraceKilled) continue;
                double sx = header.getDouble(indexShotX);
                double sy = header.getDouble(indexShotY);
                double rx = header.getDouble(indexRecX);
                double ry = header.getDouble(indexRecY);
                double dx = rx - sx;
                double dy = ry - sy;
                float offset = (float)Math.sqrt(dx * dx + dy * dy + 1.0E-40);
                float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[branch]);
                float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[branch]);
                float vel = 0.5f * (recVel + shotVel);
                float travelTime = 1000.0f * offset / vel;
                float shotDT = (float)header.getDouble(ensemble.HeaderIndex_ShotDT[branch]);
                float recDT = (float)header.getDouble(ensemble.HeaderIndex_RecDT[branch]);
                float upholeCorrection = header.getFloat(indexUpholeCorr);
                float wbCorrection = header.getFloat(indexWbCorr);
                pick = pick + upholeCorrection + wbCorrection;
                float error = pick - (travelTime + shotDT + recDT);
                float ratio = Math.abs(error) / 60.0f;
                double weight = 1.0 / (1.0 + (double)(ratio * ratio));
                float predictedDelayTime = pick - travelTime - recDT;
                predictedDelayTime = Math.max(predictedDelayTime, 0.0f);
                this.m_sumError[branch] = this.m_sumError[branch] + (double)Math.abs(error) * weight;
                this.m_sumDelayTime[branch] = this.m_sumDelayTime[branch] + (double)predictedDelayTime * weight;
                this.m_sumWeight[branch] = this.m_sumWeight[branch] + weight;
            }
            boolean modified = false;
            for (int b = 0; b < this.m_sumDelayTime.length; ++b) {
                if (!(this.m_sumWeight[b] > 0.5)) continue;
                modified = true;
                double dt = this.m_sumDelayTime[b] / this.m_sumWeight[b];
                double err = this.m_sumError[b] / this.m_sumWeight[b];
                int errIndex = ensemble.dictionary().getEntryIndex("Shot", Pecos.getColNameError(b));
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    Column_Abstract header = ensemble.trace(n).header();
                    header.putDouble(ensemble.HeaderIndex_ShotDT[b], dt);
                    header.putDouble(errIndex, err);
                }
                if (!writeToDatabase) continue;
                String colName = Pecos.getColNameDT(b);
                int shotRow = p.shotMap().get(shotID);
                int col = p.shotTable().column_indexOfColumn(colName);
                p.shotTable().putDouble(shotRow, col, dt);
                String sql = String.format("UPDATE SHOT SET %s = %f WHERE SHOTID = %d", colName, dt, shotID);
                p.geometryDatabase().executeUpdateStatement(sql);
                colName = Pecos.getColNameError(b);
                col = p.shotTable().column_indexOfColumn(colName);
                p.shotTable().putDouble(shotRow, col, err);
                sql = String.format("UPDATE SHOT SET %s = %f WHERE SHOTID = %d", colName, err, shotID);
                p.geometryDatabase().executeUpdateStatement(sql);
            }
            return modified;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }
}

