/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;

public class DelayTimeModel_ModInfo {
    public int MaxBranch = 1;
    public Java2D_Polygon Polygon;
    public FollowupOptions Follow = FollowupOptions.Nothing;
    public String FollowDescription = "";
    public int Refractor = 0;
    public boolean ModifyVelocity = false;
    public boolean ModifyElevation = false;
    public boolean ModifyDelayTime = false;
    public String Description = "";
    public String ModificationMethod = "";
    public String Mod_None = "Do not modify";
    public String Mod_Constant = "Set to a constant";
    public String Mod_GridSmooth = "Grid-based smoothing";
    public String Mod_Clip = "Clip to range";
    public String Mod_PolygonEdit = "Edit using polygon";
    public String Mod_ImportColumn = "Import database column";
    public String Mod_UpholeCompute = "Compute with uphole info";
    public String Mod_Percent = "Set to a percent";
    public String ImportColumn = "";
    public boolean CutInside = true;
    public double UpholeMin = 0.0;
    public double UpholeMax = 0.0;
    public double ClipMin = 0.0;
    public double ClipMax = 0.0;
    public PolygonUsage ClipPolygon = PolygonUsage.NotUsed;
    public double Percent = 60.0;
    public double ConstantValue = 0.0;
    public PolygonUsage ConstantPolygon = PolygonUsage.NotUsed;
    public double SmoothRadius = 0.0;
    public PolygonUsage SmoothPolygon = PolygonUsage.NotUsed;
    public boolean SmoothUseWeight = false;
    public String SmoothColumn;

    public DelayTimeModel_ModInfo() {
        try {
            this.reloadInitialData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadInitialData() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.MaxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.Polygon = p.polygon();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getModDesc() {
        try {
            Object s = this.ModificationMethod;
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_ImportColumn)) {
                s = String.format("Import column %s", this.ImportColumn);
            }
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_UpholeCompute)) {
                s = (String)s + ", compute using uphole information";
            }
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_PolygonEdit)) {
                s = this.CutInside ? (String)s + ", cut inside polygon and interpolate" : (String)s + ", cut outside polygon and extrapolate";
            }
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_Clip)) {
                s = (String)s + ", " + Double.toString(this.ClipMin) + " to " + Double.toString(this.ClipMax);
                if (this.ClipPolygon == PolygonUsage.Inside) {
                    s = (String)s + ", inside polygon";
                }
                if (this.ClipPolygon == PolygonUsage.Outside) {
                    s = (String)s + ", outside polygon";
                }
            }
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_GridSmooth)) {
                s = (String)s + ", radius = " + Double.toString(this.SmoothRadius);
                if (this.SmoothPolygon == PolygonUsage.Inside) {
                    s = (String)s + ", inside polygon";
                }
                if (this.SmoothPolygon == PolygonUsage.Outside) {
                    s = (String)s + ", outside polygon";
                }
            }
            if (this.ModificationMethod.equalsIgnoreCase(this.Mod_Constant)) {
                s = (String)s + ", value = " + Double.toString(this.ConstantValue);
                if (this.ConstantPolygon == PolygonUsage.Inside) {
                    s = (String)s + ", inside polygon";
                }
                if (this.ConstantPolygon == PolygonUsage.Outside) {
                    s = (String)s + ", outside polygon";
                }
            }
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR";
        }
    }

    public static enum FollowupOptions {
        Nothing,
        ModifyWeathering,
        ModifyElevations;

    }
}

