/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_DelayTimeAnisotropy_Grid;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_DelayTimeUpdate;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_GeometryError;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_GridVelocity;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_PointVelocity;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_SimpleVelocityAnalysis;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_VelocityGradient;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.AdvancedDelayTimeOptionsDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.GriddedDelayTimeOptionsDialog;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class DelayTimeModel {
    protected int[] m_indexZ = new int[20];
    protected int[] m_indexMaxOff = new int[20];
    protected int[] m_indexDT = new int[20];
    protected int[] m_indexV = new int[20];
    protected int m_indexX;
    protected int m_indexY;
    protected int m_indexWaterDepth;
    protected DelayTimeMath m_math = new DelayTimeMath();
    protected static DelayTimeModel m_singleton = null;
    protected AdvancedDelayTimeOptionsDialog m_advancedDlg;
    protected GriddedDelayTimeOptionsDialog m_gridDlg = null;

    protected DelayTimeModel() {
    }

    public static DelayTimeModel singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new DelayTimeModel();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void launchStandardSequence() {
        try {
            Action_DelayTime_DelayTimeUpdate actionDelayTime;
            boolean updateSomething;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            boolean anis = false;
            double maxAnis = 0.0;
            double anisGrid = 1000.0;
            boolean ensureNoBias = true;
            boolean interpolateUsingInverseSquare = false;
            boolean forceSame = false;
            double sameDist = 100.0;
            double velSmoothRadius = 1000.0;
            boolean useUserErrorCorner = false;
            double userErrorCorner = 200.0;
            boolean performGeometryAnalysis = true;
            boolean updateShot = true;
            boolean updateRec = true;
            boolean updateVel = true;
            Hashtable<Object, Object> hash_vel_apply = new Hashtable<Integer, Boolean>();
            Hashtable<Object, Object> hash_vel_min = new Hashtable<Integer, Double>();
            Hashtable<Object, Object> hash_vel_max = new Hashtable<Integer, Double>();
            for (int b = 1; b < 10; ++b) {
                hash_vel_apply.put(b, false);
                hash_vel_min.put(b, 11.0);
                hash_vel_max.put(b, 111111.0);
            }
            boolean applyRangeCompression = false;
            double rangeCompression = 2.0;
            anisGrid = project.units_feet() ? 1000.0 : 400.0;
            float maxPercentVariation = 30.0f;
            if (SharedApplicationData.ExpertMode) {
                if (this.m_advancedDlg == null) {
                    this.m_advancedDlg = new AdvancedDelayTimeOptionsDialog(true, true, true);
                }
                this.m_advancedDlg.showDialog();
                if (!this.m_advancedDlg.OK) {
                    return;
                }
                performGeometryAnalysis = this.m_advancedDlg.performGeometryAnalysis();
                hash_vel_apply = this.m_advancedDlg.hash_vel_lim_apply();
                hash_vel_min = this.m_advancedDlg.hash_vel_lim_min();
                hash_vel_max = this.m_advancedDlg.hash_vel_lim_max();
                applyRangeCompression = this.m_advancedDlg.applyRangeCompression();
                rangeCompression = this.m_advancedDlg.rangeCompression();
                updateShot = this.m_advancedDlg.allowUpdateShot();
                updateRec = this.m_advancedDlg.allowUpdateRec();
                updateVel = this.m_advancedDlg.allowUpdateVel();
                useUserErrorCorner = this.m_advancedDlg.userSelectedErrorCorner();
                userErrorCorner = this.m_advancedDlg.userErrorCorner();
                velSmoothRadius = this.m_advancedDlg.velSmoothRadius();
                anis = this.m_advancedDlg.computeAnisotropy();
                maxAnis = this.m_advancedDlg.anisMaxAmp();
                anisGrid = this.m_advancedDlg.anisGridSize();
                ensureNoBias = this.m_advancedDlg.ensureNoBias();
                interpolateUsingInverseSquare = this.m_advancedDlg.interpolateUsingInverseSquare();
                forceSame = this.m_advancedDlg.forceTheSame();
                sameDist = this.m_advancedDlg.nearbyDistance();
                maxPercentVariation = (float)this.m_advancedDlg.velMaxPercentVariation();
            }
            boolean bl = updateSomething = updateShot || updateRec || updateVel;
            if (!updateSomething) {
                JOptionPane.showMessageDialog(null, "Must update either velocity or delay times", "Cannot perform analysis", 0);
                return;
            }
            ensureNoBias = ensureNoBias && updateShot && updateRec;
            project.delayTimeData().clearDelayTimeAnisotropy();
            boolean computeSmoothRadius = !SharedApplicationData.ExpertMode;
            int smoothRadius = 2;
            if (SharedApplicationData.ExpertMode) {
                computeSmoothRadius = false;
            }
            if (maxbranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot perform analysis", 0);
                return;
            }
            Action_Sequence sequence = project.actionSequence();
            sequence.clear();
            for (int b = 1; updateVel && b <= maxbranch; ++b) {
                Action_DelayTime_SimpleVelocityAnalysis sva = new Action_DelayTime_SimpleVelocityAnalysis();
                sva.ApplyVelocityLimits = (Boolean)hash_vel_apply.get(b);
                sva.VelocityMin = (Double)hash_vel_min.get(b);
                sva.VelocityMax = (Double)hash_vel_max.get(b);
                sva.ComputeSmoothRadius = true;
                sva.SmoothRadius = smoothRadius;
                sva.ApplyRangeCompression = applyRangeCompression;
                sva.RangeCompression = rangeCompression;
                sva.Hasher.int_put("Branch", b);
                sva.Hasher.string_put("PickVersion", "FBP_User");
                sequence.addAction(sva);
            }
            int numLoops = 2;
            if (!updateVel) {
                numLoops = 1;
            }
            for (int n = 1; n <= numLoops; ++n) {
                actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
                actionDelayTime.UseErrorCornerFromUser = useUserErrorCorner;
                actionDelayTime.UserErrorCorner = userErrorCorner;
                actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
                actionDelayTime.Hasher.int_put("IterationCount", 12);
                actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
                actionDelayTime.Hasher.bool_put("UseAnisotropy", false);
                actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
                actionDelayTime.ForceNearbyToBeTheSame = forceSame;
                actionDelayTime.NearbyDistance = sameDist;
                actionDelayTime.UpdateRec = updateRec;
                actionDelayTime.UpdateShot = updateShot;
                if (n == 0) {
                    actionDelayTime.Hasher.bool_put("ResetDelayTimes", true);
                } else {
                    actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
                }
                sequence.addAction(actionDelayTime);
                if (updateVel && n <= 2) {
                    Action_DelayTime_PointVelocity actionVelPoint = new Action_DelayTime_PointVelocity();
                    actionVelPoint.hash_vel_apply = hash_vel_apply;
                    actionVelPoint.hash_vel_min = hash_vel_min;
                    actionVelPoint.hash_vel_max = hash_vel_max;
                    actionVelPoint.UseErrorCornerFromUser = useUserErrorCorner;
                    actionVelPoint.UserErrorCorner = userErrorCorner;
                    actionVelPoint.ComputeSmoothRadius = computeSmoothRadius;
                    actionVelPoint.SmoothRadiusWorld = velSmoothRadius;
                    actionVelPoint.MaxPercentVariation = maxPercentVariation;
                    actionVelPoint.ApplyRangeCompression = applyRangeCompression;
                    actionVelPoint.RangeCompression = rangeCompression;
                    actionVelPoint.Hasher.string_put("PickVersion", "FBP_User");
                    sequence.addAction(actionVelPoint);
                }
                if (!updateVel) continue;
                Action_DelayTime_VelocityGradient actionVelSlope = new Action_DelayTime_VelocityGradient();
                actionVelSlope.hash_vel_apply = hash_vel_apply;
                actionVelSlope.hash_vel_min = hash_vel_min;
                actionVelSlope.hash_vel_max = hash_vel_max;
                actionVelSlope.UseErrorCornerFromUser = useUserErrorCorner;
                actionVelSlope.UserErrorCorner = userErrorCorner;
                actionVelSlope.ComputeSmoothRadius = computeSmoothRadius;
                actionVelSlope.SmoothRadiusWorld = velSmoothRadius;
                actionVelSlope.MaxPercentVariation = maxPercentVariation;
                actionVelSlope.Hasher.string_put("PickVersion", "FBP_User");
                actionVelSlope.Hasher.bool_put("AllowFlipFlop", false);
                actionVelSlope.Hasher.int_put("IterationCount", 1);
                sequence.addAction(actionVelSlope);
            }
            actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
            actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
            actionDelayTime.Hasher.int_put("IterationCount", 12);
            actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
            actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
            actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
            actionDelayTime.ForceNearbyToBeTheSame = forceSame;
            actionDelayTime.NearbyDistance = sameDist;
            actionDelayTime.UpdateRec = updateRec;
            actionDelayTime.UpdateShot = updateShot;
            sequence.addAction(actionDelayTime);
            if (anis) {
                for (int b = 1; b <= maxbranch; ++b) {
                    Action_DelayTime_DelayTimeAnisotropy_Grid action = new Action_DelayTime_DelayTimeAnisotropy_Grid();
                    action.Hasher.double_put("AnisGrid", anisGrid);
                    action.Hasher.double_put("MaxAnis", maxAnis);
                    action.Hasher.int_put("Branch", b);
                    action.Hasher.string_put("PickVersion", "FBP_User");
                    action.Hasher.int_put("IterationCount", 12);
                    action.Hasher.bool_put("ResetDelayTimes", false);
                    sequence.addAction(action);
                }
                actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
                actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
                actionDelayTime.Hasher.int_put("IterationCount", 12);
                actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
                actionDelayTime.Hasher.bool_put("UseAnisotropy", true);
                actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
                actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
                actionDelayTime.ForceNearbyToBeTheSame = forceSame;
                actionDelayTime.NearbyDistance = sameDist;
                actionDelayTime.UpdateRec = updateRec;
                actionDelayTime.UpdateShot = updateShot;
                sequence.addAction(actionDelayTime);
                if (updateVel && SharedApplicationData.ExpertMode) {
                    Action_DelayTime_PointVelocity actionVelPoint = new Action_DelayTime_PointVelocity();
                    actionVelPoint.hash_vel_apply = hash_vel_apply;
                    actionVelPoint.hash_vel_min = hash_vel_min;
                    actionVelPoint.hash_vel_max = hash_vel_max;
                    actionVelPoint.ComputeSmoothRadius = false;
                    actionVelPoint.SmoothRadiusWorld = velSmoothRadius;
                    actionVelPoint.MaxPercentVariation = maxPercentVariation;
                    actionVelPoint.Hasher.string_put("PickVersion", "FBP_User");
                    sequence.addAction(actionVelPoint);
                    actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
                    actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
                    actionDelayTime.Hasher.int_put("IterationCount", 12);
                    actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
                    actionDelayTime.Hasher.bool_put("UseAnisotropy", true);
                    actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
                    actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
                    actionDelayTime.ForceNearbyToBeTheSame = forceSame;
                    actionDelayTime.NearbyDistance = sameDist;
                    actionDelayTime.UpdateRec = updateRec;
                    actionDelayTime.UpdateShot = updateShot;
                    sequence.addAction(actionDelayTime);
                }
            }
            if (performGeometryAnalysis) {
                sequence.addAction(new Action_DelayTime_GeometryError());
            }
            project.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void launchGriddedSequence() {
        try {
            Action_DelayTime_DelayTimeUpdate actionDelayTime;
            boolean updateSomething;
            if (this.m_gridDlg == null) {
                this.m_gridDlg = new GriddedDelayTimeOptionsDialog();
            }
            this.m_gridDlg.showDialog();
            if (!this.m_gridDlg.OK) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            boolean ensureNoBias = true;
            boolean interpolateUsingInverseSquare = false;
            boolean forceSame = false;
            double sameDist = 100.0;
            double velSmoothRadius = 1000.0;
            boolean useUserErrorCorner = false;
            double userErrorCorner = 200.0;
            boolean updateShot = true;
            boolean updateRec = true;
            boolean updateVel = true;
            Hashtable<Integer, Boolean> hash_vel_apply = new Hashtable<Integer, Boolean>();
            Hashtable<Integer, Double> hash_vel_min = new Hashtable<Integer, Double>();
            Hashtable<Integer, Double> hash_vel_max = new Hashtable<Integer, Double>();
            for (int b = 1; b < 10; ++b) {
                hash_vel_apply.put(b, false);
                hash_vel_min.put(b, 11.0);
                hash_vel_max.put(b, 111111.0);
            }
            boolean applyRangeCompression = this.m_gridDlg.applyRangeCompression();
            double rangeCompression = this.m_gridDlg.rangeCompression();
            float maxPercentVariation = 30.0f;
            boolean bl = updateSomething = updateShot || updateRec || updateVel;
            if (!updateSomething) {
                JOptionPane.showMessageDialog(null, "Must update either velocity or delay times", "Cannot perform analysis", 0);
                return;
            }
            ensureNoBias = ensureNoBias && updateShot && updateRec;
            project.delayTimeData().clearDelayTimeAnisotropy();
            boolean computeSmoothRadius = !SharedApplicationData.ExpertMode;
            int smoothRadius = 2;
            if (SharedApplicationData.ExpertMode) {
                computeSmoothRadius = false;
            }
            if (maxbranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot perform analysis", 0);
                return;
            }
            Action_Sequence sequence = project.actionSequence();
            sequence.clear();
            for (int b = 1; updateVel && b <= maxbranch; ++b) {
                Action_DelayTime_SimpleVelocityAnalysis sva = new Action_DelayTime_SimpleVelocityAnalysis();
                sva.ApplyVelocityLimits = (Boolean)hash_vel_apply.get(b);
                sva.VelocityMin = (Double)hash_vel_min.get(b);
                sva.VelocityMax = (Double)hash_vel_max.get(b);
                sva.ComputeSmoothRadius = true;
                sva.SmoothRadius = smoothRadius;
                sva.ApplyRangeCompression = this.m_gridDlg.applyRangeCompression();
                sva.RangeCompression = this.m_gridDlg.rangeCompression();
                sva.Hasher.int_put("Branch", b);
                sva.Hasher.string_put("PickVersion", "FBP_User");
                sequence.addAction(sva);
            }
            int numLoops = 3;
            if (!updateVel) {
                numLoops = 1;
            }
            for (int n = 1; n <= numLoops; ++n) {
                actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
                actionDelayTime.UseErrorCornerFromUser = useUserErrorCorner;
                actionDelayTime.UserErrorCorner = userErrorCorner;
                actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
                actionDelayTime.Hasher.int_put("IterationCount", 12);
                actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
                actionDelayTime.Hasher.bool_put("UseAnisotropy", false);
                actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
                actionDelayTime.ForceNearbyToBeTheSame = forceSame;
                actionDelayTime.NearbyDistance = sameDist;
                actionDelayTime.UpdateRec = updateRec;
                actionDelayTime.UpdateShot = updateShot;
                actionDelayTime.UseGriddedVelocity = true;
                actionDelayTime.UseAnisotropicGriddedVelocity = false;
                if (n == 0) {
                    actionDelayTime.Hasher.bool_put("ResetDelayTimes", true);
                } else {
                    actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
                }
                sequence.addAction(actionDelayTime);
                Action_DelayTime_GridVelocity gv = new Action_DelayTime_GridVelocity();
                gv.ApplyRangeCompression = this.m_gridDlg.applyRangeCompression();
                gv.RangeCompression = this.m_gridDlg.rangeCompression();
                gv.Hasher.int_put("IterationCount", 2);
                if (n == numLoops) {
                    gv.RangeCompression = 1.05;
                }
                sequence.addAction(gv);
            }
            actionDelayTime = new Action_DelayTime_DelayTimeUpdate();
            actionDelayTime.Hasher.string_put("PickVersion", "FBP_User");
            actionDelayTime.Hasher.int_put("IterationCount", 12);
            actionDelayTime.Hasher.bool_put("ResetDelayTimes", false);
            actionDelayTime.Hasher.bool_put("EnsureNoDCBias", ensureNoBias);
            actionDelayTime.InterpolateUsingInverseSquare = interpolateUsingInverseSquare;
            actionDelayTime.ForceNearbyToBeTheSame = forceSame;
            actionDelayTime.NearbyDistance = sameDist;
            actionDelayTime.UpdateRec = updateRec;
            actionDelayTime.UpdateShot = updateShot;
            actionDelayTime.UseGriddedVelocity = true;
            actionDelayTime.UseAnisotropicGriddedVelocity = false;
            sequence.addAction(actionDelayTime);
            Action_DelayTime_GeometryError ge = new Action_DelayTime_GeometryError();
            ge.UseGriddedVelocity = true;
            ge.UseAnisotropicGriddedVelocity = false;
            sequence.addAction(ge);
            project.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void modifyColumn(DelayTimeModel_ModInfo modInfo, String columnName) throws Exception {
        try {
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_UpholeCompute)) {
                if (columnName.equalsIgnoreCase(Pecos.getColNameVel(0))) {
                    Tools_RefractionStaticsProject.computeV0UsingUpholeModel(modInfo.UpholeMin, modInfo.UpholeMax);
                } else {
                    System.out.println("How did I get here?");
                }
                return;
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_PolygonEdit)) {
                if (modInfo.CutInside) {
                    Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(columnName, PolygonUsage.Inside);
                } else {
                    Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(columnName, PolygonUsage.Outside);
                }
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_GridSmooth)) {
                if (!modInfo.SmoothUseWeight) {
                    Tools_RefractionStaticsProject.smoothColumn(columnName, -999999.0, modInfo.SmoothRadius, modInfo.SmoothPolygon);
                } else {
                    Tools_RefractionStaticsProject.smoothColumn(columnName, -999999.0, modInfo.SmoothRadius, modInfo.SmoothPolygon, modInfo.SmoothColumn);
                }
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_Clip)) {
                Tools_RefractionStaticsProject.clipColumn(columnName, modInfo.ClipMin, modInfo.ClipMax, modInfo.ClipPolygon);
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_Constant)) {
                Tools_RefractionStaticsProject.setColumnToConstant(columnName, modInfo.ConstantValue, modInfo.ConstantPolygon);
            }
            if (modInfo.ModificationMethod.equalsIgnoreCase(modInfo.Mod_ImportColumn)) {
                Tools_RefractionStaticsProject.copyColumn(modInfo.ImportColumn, columnName, true, true);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void performRequestedMods(DelayTimeModel_ModInfo modInfo) {
        try {
            modInfo.FollowDescription = "No follow up mods performed";
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (modInfo.ModifyVelocity && modInfo.Refractor == 0) {
                if (modInfo.ModificationMethod == modInfo.Mod_Percent) {
                    this.setPercent(p.receiverTable(), modInfo.Percent, Pecos.getColNameVel(0), Pecos.getColNameVel(1));
                    this.setPercent(p.shotTable(), modInfo.Percent, Pecos.getColNameVel(0), Pecos.getColNameVel(1));
                    p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), Pecos.getColNameVel(0));
                    p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), Pecos.getColNameVel(0));
                } else {
                    this.modifyColumn(modInfo, Pecos.getColNameVel(0));
                }
                this.ensureVelocitiesIncrease(p.receiverTable());
                this.ensureVelocitiesIncrease(p.shotTable());
                if (modInfo.Follow == DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations) {
                    modInfo.FollowDescription = "Follow up: compute refractor elevation(s)";
                    this.computeRefractorElevations(p.receiverTable());
                    this.computeRefractorElevations(p.shotTable());
                }
                this.computeMaxOffsets();
                return;
            }
            if (modInfo.ModifyElevation) {
                this.modifyColumn(modInfo, Pecos.getColNameElev(modInfo.Refractor));
                this.ensureNonZeroThicknesses(p.receiverTable());
                this.ensureNonZeroThicknesses(p.shotTable());
                if (modInfo.Follow == DelayTimeModel_ModInfo.FollowupOptions.ModifyWeathering) {
                    modInfo.FollowDescription = "Follow up: compute weathering velocity";
                    this.computeWeatheringVelocity(p.receiverTable(), modInfo.Refractor);
                    this.computeWeatheringVelocity(p.shotTable(), modInfo.Refractor);
                    this.computeRefractorElevations(p.receiverTable());
                    this.computeRefractorElevations(p.shotTable());
                }
                this.computeMaxOffsets();
                return;
            }
            if (modInfo.ModifyDelayTime) {
                this.modifyColumn(modInfo, Pecos.getColNameDT(modInfo.Refractor));
                this.ensureDelayTimesIncrease(p.receiverTable());
                this.ensureDelayTimesIncrease(p.shotTable());
                if (modInfo.Follow == DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations) {
                    modInfo.FollowDescription = "Follow up: compute refractor elevation(s)";
                    this.computeRefractorElevations(p.receiverTable());
                    this.computeRefractorElevations(p.shotTable());
                }
                this.computeMaxOffsets();
                return;
            }
            if (modInfo.ModifyVelocity && modInfo.Refractor >= 1) {
                this.modifyColumn(modInfo, Pecos.getColNameVel(modInfo.Refractor));
                this.ensureVelocitiesIncrease(p.receiverTable());
                this.ensureVelocitiesIncrease(p.shotTable());
                if (modInfo.Follow == DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations) {
                    modInfo.FollowDescription = "Follow up: compute refractor elevation(s)";
                    this.computeRefractorElevations(p.receiverTable());
                    this.computeRefractorElevations(p.shotTable());
                }
                this.computeMaxOffsets();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepIndices(Table_Abstract tbl) {
        try {
            int b;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            int maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.m_indexWaterDepth = -9999;
            if (tbl.column_exists("WaterDepth")) {
                this.m_indexWaterDepth = tbl.column_indexOfColumn("WaterDepth");
            }
            this.m_indexDT[0] = -9999;
            this.m_indexZ[0] = tbl.column_indexOfColumn("Elevation");
            this.m_indexV[0] = tbl.column_indexOfColumn(Pecos.getColNameVel(0));
            for (b = 1; b <= maxBranch; ++b) {
                this.m_indexDT[b] = tbl.column_indexOfColumn(Pecos.getColNameDT(b));
                this.m_indexV[b] = tbl.column_indexOfColumn(Pecos.getColNameVel(b));
                this.m_indexZ[b] = tbl.column_append(Pecos.getColNameElev(b), DataType.Double);
            }
            for (b = 0; b < maxBranch; ++b) {
                this.m_indexMaxOff[b] = tbl.column_append(Pecos.getColNameMaxOff(b), DataType.Double);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            this.m_indexX = tbl.column_indexOfColumn("Easting");
            this.m_indexY = tbl.column_indexOfColumn("Northing");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setBranchInterpolatedV0(Table_Abstract tbl) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            BranchAssignment ba = p.delayTimeData().branchAssignment();
            int maxBranch = ba.maxBranch();
            if (maxBranch < 1) {
                return;
            }
            this.prepIndices(tbl);
            for (int n = 0; n < tbl.row_count(); ++n) {
                double x = tbl.getDouble(n, this.m_indexX);
                double y = tbl.getDouble(n, this.m_indexY);
                ba.interpolateBranchAtLocation(1, x, y);
                tbl.putDouble(n, this.m_indexV[0], ba.InterpolatedV0);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameVel(0));
            this.ensureVelocitiesIncrease(tbl);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPercent(Table_Abstract tbl, double percent, String col1, String col2) {
        try {
            int index1 = tbl.column_append(col1, DataType.Double);
            int index2 = tbl.column_indexOfColumn(col2);
            for (int row = 0; row < tbl.row_count(); ++row) {
                double v2 = tbl.getDouble(row, index2);
                tbl.putDouble(row, index1, 0.01 * percent * v2);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensureVelocitiesIncrease(Table_Abstract tbl) {
        try {
            int maxBranch;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int b = 1; b <= maxBranch; ++b) {
                boolean changesMade = false;
                for (int row = 0; row < tbl.row_count(); ++row) {
                    double t1 = tbl.getDouble(row, this.m_indexV[b - 1]);
                    double mint = t1 + 30.0;
                    double t2 = tbl.getDouble(row, this.m_indexV[b]);
                    if (!(t2 < mint)) continue;
                    changesMade = true;
                    if (b == 1) {
                        double minw = t2 - 30.0;
                        tbl.putDouble(row, this.m_indexV[0], minw);
                        continue;
                    }
                    tbl.putDouble(row, this.m_indexV[b], mint);
                }
                if (!changesMade) continue;
                p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameVel(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensureDelayTimesIncrease(Table_Abstract tbl) {
        try {
            int maxBranch;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int b = 2; b <= maxBranch; ++b) {
                boolean changesMade = false;
                for (int row = 0; row < tbl.row_count(); ++row) {
                    double t1 = tbl.getDouble(row, this.m_indexDT[b - 1]);
                    double mint = t1 + 2.0;
                    double t2 = tbl.getDouble(row, this.m_indexDT[b]);
                    if (!(t2 < mint)) continue;
                    changesMade = true;
                    tbl.putDouble(row, this.m_indexDT[b], mint);
                }
                if (!changesMade) continue;
                p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameDT(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensureNonZeroThicknesses(Table_Abstract tbl) {
        try {
            int maxBranch;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int b = 1; b <= maxBranch; ++b) {
                boolean changesMade = false;
                for (int row = 0; row < tbl.row_count(); ++row) {
                    double z1 = tbl.getDouble(row, this.m_indexZ[b - 1]);
                    double maxZ = z1 - 0.5;
                    double z2 = tbl.getDouble(row, this.m_indexZ[b]);
                    if (!(z2 >= maxZ)) continue;
                    changesMade = true;
                    tbl.putDouble(row, this.m_indexZ[b], maxZ);
                }
                if (!changesMade) continue;
                p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameElev(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeMaxOffsets() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.computeMaxOffsets(p.shotTable());
            this.computeMaxOffsets(p.receiverTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeMaxOffsets(Table_Abstract tbl) {
        try {
            int maxBranch;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int row = 0; row < tbl.row_count(); ++row) {
                int b;
                this.m_math.Elevation[0] = tbl.getDouble(row, this.m_indexZ[0]);
                for (b = 0; b <= maxBranch; ++b) {
                    this.m_math.Velocity[b] = tbl.getDouble(row, this.m_indexV[b]);
                    if (b < 1) continue;
                    this.m_math.DelayTime[b] = tbl.getDouble(row, this.m_indexDT[b]);
                }
                this.m_math.computeElevations();
                for (b = 0; b < maxBranch; ++b) {
                    tbl.putDouble(row, this.m_indexMaxOff[b], this.m_math.MaxOffset[b]);
                }
            }
            for (int b = 0; b < maxBranch; ++b) {
                p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameMaxOff(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeRefractorElevations(Table_Abstract tbl) {
        try {
            int maxBranch;
            this.ensureDelayTimesIncrease(tbl);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int row = 0; row < tbl.row_count(); ++row) {
                int b;
                double waterDepth;
                this.m_math.Elevation[0] = tbl.getDouble(row, this.m_indexZ[0]);
                if (this.m_indexWaterDepth >= 0 && (waterDepth = tbl.getDouble(row, this.m_indexWaterDepth)) > 0.0) {
                    this.m_math.Elevation[0] = this.m_math.Elevation[0] - waterDepth;
                }
                for (b = 0; b <= maxBranch; ++b) {
                    this.m_math.Velocity[b] = tbl.getDouble(row, this.m_indexV[b]);
                    if (b < 1) continue;
                    this.m_math.DelayTime[b] = tbl.getDouble(row, this.m_indexDT[b]);
                }
                this.m_math.computeElevations();
                for (b = 1; b <= maxBranch; ++b) {
                    tbl.putDouble(row, this.m_indexZ[b], this.m_math.Elevation[b]);
                }
            }
            for (int b = 1; b <= maxBranch; ++b) {
                p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameElev(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeWeatheringVelocity(Table_Abstract tbl, int lockedRefractor) {
        try {
            int maxBranch;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_math.MaxBranch = maxBranch = p.delayTimeData().branchAssignment().maxBranch();
            this.prepIndices(tbl);
            for (int row = 0; row < tbl.row_count(); ++row) {
                double waterDepth;
                this.m_math.Elevation[0] = tbl.getDouble(row, this.m_indexZ[0]);
                if (this.m_indexWaterDepth >= 0 && (waterDepth = tbl.getDouble(row, this.m_indexWaterDepth)) > 0.0) {
                    this.m_math.Elevation[0] = this.m_math.Elevation[0] - waterDepth;
                }
                for (int b = 0; b <= maxBranch; ++b) {
                    if (b >= 1) {
                        this.m_math.Elevation[b] = tbl.getDouble(row, this.m_indexZ[b]);
                    }
                    this.m_math.Velocity[b] = tbl.getDouble(row, this.m_indexV[b]);
                    if (b < 1) continue;
                    this.m_math.DelayTime[b] = tbl.getDouble(row, this.m_indexDT[b]);
                }
                this.m_math.computeWeather(lockedRefractor);
                tbl.putDouble(row, this.m_indexV[0], this.m_math.Velocity[0]);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(tbl, Pecos.getColNameVel(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

