/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;

public class DelayTimeMath {
    public int MaxBranch = 0;
    public double Uphole = 0.0;
    public double Depth = 0.0;
    public double[] DelayTime = new double[10];
    public double[] Velocity = new double[10];
    public double[] Elevation = new double[10];
    public double[] Thickness = new double[10];
    public double[] MaxOffset = new double[10];
    public double OneLayerAngle;
    public double OneLayerDelayTime;
    public double OneLayerV0;
    public double OneLayerV1;
    public double OneLayerThickness;
    public double OneLayerHorizontal;

    public void setSingleLayerDT(double dt, double v0, double v1) {
        try {
            this.OneLayerDelayTime = Math.max(dt, 0.1);
            this.OneLayerV0 = Math.max(v0, 10.0);
            this.OneLayerV1 = Math.max(v1, this.OneLayerV0 + 10.0);
            this.OneLayerAngle = Math.asin(this.OneLayerV0 / this.OneLayerV1);
            this.OneLayerThickness = 0.001 * this.OneLayerDelayTime * (this.OneLayerV0 * this.OneLayerV1) / Math.sqrt(this.OneLayerV1 * this.OneLayerV1 - this.OneLayerV0 * this.OneLayerV0);
            this.OneLayerHorizontal = this.OneLayerThickness * Math.tan(this.OneLayerAngle);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double computeDelayTime(int layer) throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length || layer < 1 || layer > this.MaxBranch) {
                throw new Exception("Funky layer, MaxBranch");
            }
            double sum = 0.0;
            for (int n = 0; n < layer; ++n) {
                sum += this.Thickness[n] * this.velocityTerm(n, layer);
            }
            return 1000.0 * sum;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double velocityTerm(int layer1, int layer2) throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length || layer1 < 0 || layer1 >= layer2 || layer2 > this.MaxBranch) {
                throw new Exception("Funky layer, MaxBranch");
            }
            double vb = this.Velocity[layer2];
            double va = this.Velocity[layer1];
            if (vb <= va) {
                throw new Exception("Velocity[layer1] >= Velocity[layer2]");
            }
            double term = Math.sqrt(vb * vb - va * va) / (vb * va);
            return term;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double computeLayerThickness(int layer) throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length || layer >= this.MaxBranch || layer < 0) {
                throw new Exception("Funky layer, MaxBranch");
            }
            if (layer == 0) {
                this.Thickness[0] = 0.001 * this.DelayTime[1] / this.velocityTerm(0, 1);
                return this.Thickness[0];
            }
            double sumShallowLayers = 0.0;
            for (int shallow = 0; shallow < layer; ++shallow) {
                double velTerm = this.velocityTerm(shallow, layer + 1);
                double term = 1000.0 * this.Thickness[shallow] * velTerm;
                sumShallowLayers += term;
            }
            double velTerm = this.velocityTerm(layer, layer + 1);
            double left = this.DelayTime[layer + 1] - sumShallowLayers;
            this.Thickness[layer] = 0.001 * left / velTerm;
            this.Thickness[layer] = Math.max(this.Thickness[layer], 0.1);
            return this.Thickness[layer];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeThicknesses() throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length) {
                throw new Exception("MaxBranch < 1");
            }
            for (int layer = 0; layer < this.MaxBranch; ++layer) {
                this.Thickness[layer] = this.computeLayerThickness(layer);
            }
            this.computeMaxOffsets();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeMaxOffsets() throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length) {
                throw new Exception("MaxBranch < 1");
            }
            double maxOffsetSum = 0.0;
            this.MaxOffset[0] = 0.002 * this.DelayTime[1] / (1.0 / this.Velocity[0] - 1.0 / this.Velocity[1]);
            for (int layer = 1; layer < this.MaxBranch; ++layer) {
                this.MaxOffset[layer] = 0.002 * (this.DelayTime[layer + 1] - this.DelayTime[layer]) / (1.0 / this.Velocity[layer] - 1.0 / this.Velocity[layer + 1]);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeElevations() throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length) {
                throw new Exception("MaxBranch < 1");
            }
            this.computeThicknesses();
            for (int branch = 1; branch <= this.MaxBranch; ++branch) {
                this.Elevation[branch] = this.Elevation[branch - 1] - this.Thickness[branch - 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void computeWeather(int refractor) throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length) {
                throw new Exception("MaxBranch < 1");
            }
            if (refractor < 1 || refractor > this.MaxBranch) {
                throw new Exception("((refractor < 1) || (refractor > MaxBranch))");
            }
            double desired = this.Elevation[refractor];
            double minV0 = 10.0;
            double maxV0 = 0.99 * this.Velocity[1];
            double range = maxV0 - minV0;
            int num = 20;
            double delta = range / (double)num;
            for (int iter = 0; iter < 5; ++iter) {
                double minError = 1.0E100;
                double bestV0 = 1.0;
                for (int n = 0; n <= num; ++n) {
                    this.Velocity[0] = minV0 + (double)n * delta;
                    this.computeElevations();
                    double error = Math.abs(desired - this.Elevation[refractor]);
                    if (!(error < minError)) continue;
                    bestV0 = this.Velocity[0];
                    minError = error;
                }
                this.Velocity[0] = bestV0;
                minV0 = bestV0 - 2.0 * delta;
                minV0 = Math.max(10.0, minV0);
                maxV0 = bestV0 + 2.0 * delta;
                maxV0 = Math.min(0.99 * this.Velocity[1], maxV0);
                range = maxV0 - minV0;
                delta = range / (double)num;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void junk() throws Exception {
        try {
            if (this.MaxBranch < 1 || this.MaxBranch >= this.DelayTime.length) {
                throw new Exception("MaxBranch < 1");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

