/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashKey_TwoInt;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;
import java.util.HashMap;

public class SpatialInterpolator {
    protected double m_decayRadius_Level1;
    protected double m_decayScalar_Level1;
    protected double m_binSize_Level1;
    protected HashKey_TwoInt m_key_Level1 = new HashKey_TwoInt(0, 0);
    protected HashMap<HashKey_TwoInt, EntryList> m_map_Level1 = new HashMap();
    protected double m_decayRadius_Level2;
    protected double m_decayScalar_Level2;
    protected double m_binSize_Level2;
    protected HashKey_TwoInt m_key_Level2 = new HashKey_TwoInt(0, 0);
    protected HashMap<HashKey_TwoInt, EntryList> m_map_Level2 = new HashMap();
    protected double m_decayRadius_Level3;
    protected double m_decayScalar_Level3;
    protected double m_binSize_Level3;
    protected HashKey_TwoInt m_key_Level3 = new HashKey_TwoInt(0, 0);
    protected HashMap<HashKey_TwoInt, EntryList> m_map_Level3 = new HashMap();
    protected double m_interpolatedValue;
    protected double m_interpolatedCount;
    public double Closest = 0.0;

    public void prep(double exponentialDecayRadius, double binSize) {
        try {
            this.m_decayRadius_Level1 = Math.max(1.0E-5, exponentialDecayRadius);
            this.m_decayScalar_Level1 = -1.0 / (this.m_decayRadius_Level1 * this.m_decayRadius_Level1);
            this.m_binSize_Level1 = binSize;
            this.m_binSize_Level1 = Math.max(this.m_binSize_Level1, 3.0 * this.m_decayRadius_Level1);
            this.m_decayRadius_Level2 = 5.0 * this.m_decayRadius_Level1;
            this.m_decayScalar_Level2 = -1.0 / (this.m_decayRadius_Level2 * this.m_decayRadius_Level2);
            this.m_binSize_Level2 = 5.0 * this.m_binSize_Level1;
            this.m_decayRadius_Level3 = 50.0 * this.m_decayRadius_Level1;
            this.m_decayScalar_Level3 = -1.0 / (this.m_decayRadius_Level3 * this.m_decayRadius_Level3);
            this.m_binSize_Level3 = 50.0 * this.m_binSize_Level1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean interpolate(HashMap<HashKey_TwoInt, EntryList> map, double binSize, double decayRadius, double x, double y) {
        try {
            int indexX = (int)(0.5 + x / binSize);
            int indexY = (int)(0.5 + y / binSize);
            double sum1 = 0.0;
            double sum2 = 1.0E-90;
            int count = 0;
            int rad = 8;
            this.Closest = 1.0E100;
            decayRadius = Math.max(decayRadius, 1.0E-10);
            double decaysq = decayRadius * decayRadius;
            for (int ix = indexX - rad; ix <= indexX + rad; ++ix) {
                for (int iy = indexY - rad; iy <= indexY + rad; ++iy) {
                    HashKey_TwoInt key = new HashKey_TwoInt(ix, iy);
                    if (!map.containsKey(key)) continue;
                    EntryList list = map.get(key);
                    count += list.List.size();
                    for (Entry entry : list.List) {
                        double dx = x - entry.X;
                        double dy = y - entry.Y;
                        double rsq = dx * dx + dy * dy;
                        double ratio = rsq / decaysq;
                        double w = 1.0 / (1.0 + ratio * ratio);
                        this.Closest = Math.min(this.Closest, rsq);
                        sum1 += (w *= entry.W) * entry.V;
                        sum2 += w;
                    }
                }
            }
            this.Closest = Math.sqrt(this.Closest);
            if (count >= 10) {
                this.m_interpolatedValue = sum1 / sum2;
                this.m_interpolatedCount = count;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public double interpolate(double x, double y) {
        try {
            if (this.interpolate(this.m_map_Level1, this.m_binSize_Level1, this.m_decayRadius_Level1, x, y)) {
                return this.m_interpolatedValue;
            }
            if (this.interpolate(this.m_map_Level2, this.m_binSize_Level2, this.m_decayRadius_Level2, x, y)) {
                return this.m_interpolatedValue;
            }
            if (this.interpolate(this.m_map_Level3, this.m_binSize_Level3, this.m_decayRadius_Level3, x, y)) {
                return this.m_interpolatedValue;
            }
            double sum1 = 0.0;
            double sum2 = 1.0E-40;
            for (EntryList list : this.m_map_Level1.values()) {
                double dx = x - list.X;
                double dy = y - list.Y;
                double w = list.SumW / (1.0 + dx * dx + dy * dy);
                sum1 += w * list.Average;
                sum2 += w;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public void interpolate(Table_Abstract table, String columnName) {
        try {
            int ix = table.column_indexOfColumn("Easting");
            int iy = table.column_indexOfColumn("Northing");
            int iv = table.column_indexOfColumn(columnName);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, ix);
                double y = table.getDouble(r, iy);
                double v = this.interpolate(x, y);
                table.putDouble(r, iv, v);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void add(HashMap<HashKey_TwoInt, EntryList> map, double binSize, double x, double y, double v, double w) {
        try {
            int ix = (int)(0.5 + x / binSize);
            int iy = (int)(0.5 + y / binSize);
            HashKey_TwoInt key = new HashKey_TwoInt(ix, iy);
            if (!map.containsKey(key)) {
                map.put(key, new EntryList(x, y));
            }
            map.get(key).add(x, y, v, w);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(Table_Abstract table, String column) {
        try {
            int ix = table.column_indexOfColumn("Easting");
            int iy = table.column_indexOfColumn("Northing");
            int iv = table.column_indexOfColumn(column);
            for (int r = 0; r < table.row_count(); ++r) {
                double x = table.getDouble(r, ix);
                double y = table.getDouble(r, iy);
                double v = table.getDouble(r, iv);
                this.add(x, y, v, 1.0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(double x, double y, double v, double w) {
        try {
            this.add(this.m_map_Level1, this.m_binSize_Level1, x, y, v, w);
            this.add(this.m_map_Level2, this.m_binSize_Level2, x, y, v, w);
            this.add(this.m_map_Level3, this.m_binSize_Level3, x, y, v, w);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class EntryList {
        public ArrayList<Entry> List = new ArrayList();
        public double X;
        public double Y;
        public double Average = 0.0;
        public double SumV = 0.0;
        public double SumW = 1.0E-50;

        public EntryList(double x, double y) {
            this.X = x;
            this.Y = y;
        }

        void add(double x, double y, double v, double w) {
            this.List.add(new Entry(x, y, v, w));
            this.SumV += v * w;
            this.SumW += w;
            this.Average = this.SumV / this.SumW;
        }
    }

    protected class Entry {
        public double X;
        public double Y;
        public double V;
        public double W;

        public Entry(double x, double y, double v, double w) {
            this.X = x;
            this.Y = y;
            this.V = v;
            this.W = w;
        }
    }
}

