/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Location;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Graphics2D;

public class Interpolator_EmptyGrid
implements Java2D_PaintableInterface {
    public double BinSize = 100.0;
    public int NumX;
    public int NumY;
    public int MaxIndexX = Integer.MIN_VALUE;
    public int MinIndexX = Integer.MAX_VALUE;
    public int MaxIndexY = Integer.MIN_VALUE;
    public int MinIndexY = Integer.MAX_VALUE;
    public boolean[][] valid1;
    public boolean[][] valid2;
    public boolean[][] coverage;
    public double[][] sum1;
    public double[][] sum2;
    public double[][] value;

    public Interpolator_EmptyGrid(int nx, int ny, double bin_size) {
        try {
            this.BinSize = bin_size;
            this.MaxIndexX = nx - 1;
            this.MinIndexX = 0;
            this.MaxIndexY = ny - 1;
            this.MinIndexY = 0;
            this.NumX = nx;
            this.NumY = ny;
            this.allocate();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void allocate() {
        try {
            this.valid1 = new boolean[this.NumX][this.NumY];
            this.valid2 = new boolean[this.NumX][this.NumY];
            this.coverage = new boolean[this.NumX][this.NumY];
            this.sum1 = new double[this.NumX][this.NumY];
            this.sum2 = new double[this.NumX][this.NumY];
            this.value = new double[this.NumX][this.NumY];
            this.clear();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void clear() {
        try {
            for (int ix = 0; ix < this.NumX; ++ix) {
                for (int iy = 0; iy < this.NumY; ++iy) {
                    this.valid1[ix][iy] = false;
                    this.sum1[ix][iy] = 0.0;
                    this.sum2[ix][iy] = 0.0;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public Interpolator_EmptyGrid(UpholeSimple uphole, double bin_size, boolean time_grid, double depth) {
        try {
            this.BinSize = bin_size;
            Range_Double rx = new Range_Double();
            Range_Double ry = new Range_Double();
            for (UpholeSimple_Location loc : uphole.List) {
                int ix = (int)(loc.Easting / this.BinSize);
                int iy = (int)(loc.Northing / this.BinSize);
                this.MaxIndexX = Math.max(this.MaxIndexX, ix);
                this.MinIndexX = Math.min(this.MinIndexX, ix);
                this.MaxIndexY = Math.max(this.MaxIndexY, iy);
                this.MinIndexY = Math.min(this.MinIndexY, iy);
                rx.expandRange(loc.Easting);
                ry.expandRange(loc.Northing);
            }
            double area_embiggened = (bin_size + rx.range()) * (bin_size + ry.range());
            double side_length = Math.sqrt(area_embiggened);
            double points_on_side = Math.sqrt(10.0 + (double)uphole.List.size());
            double nominal_spacing = side_length / points_on_side;
            this.NumX = this.MaxIndexX - this.MinIndexX + 1;
            this.NumY = this.MaxIndexY - this.MinIndexY + 1;
            this.allocate();
            for (int index_x = 0; index_x < this.NumX; ++index_x) {
                for (int index_y = 0; index_y < this.NumY; ++index_y) {
                    int ix = index_x + this.MinIndexX;
                    int iy = index_y + this.MinIndexY;
                    double x = (double)ix * this.BinSize;
                    double y = (double)iy * this.BinSize;
                    uphole.interpolate_tv_using_arrays(x, y, depth, true, 0.4 * nominal_spacing);
                    if (time_grid) {
                        this.add(index_x, index_y, uphole.Interpolated_Time, 1.0);
                        continue;
                    }
                    this.add(index_x, index_y, uphole.Interpolated_Velocity, 1.0);
                }
            }
            this.finish(20);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public Interpolator_EmptyGrid(Table_Abstract t1, Table_Abstract t2, String column, double bin_size) {
        try {
            int iy;
            int ix;
            double v;
            double y;
            double x;
            int n;
            int indexKilled;
            int indexV;
            int indexY;
            int indexX;
            Table_Abstract table;
            int iter;
            this.BinSize = bin_size;
            for (iter = 0; iter <= 1; ++iter) {
                table = t1;
                if (iter == 1) {
                    table = t2;
                }
                indexX = table.column_indexOfColumn("Easting");
                indexY = table.column_indexOfColumn("Northing");
                indexV = table.column_indexOfColumn(column);
                indexKilled = table.column_indexOfColumn("Killed");
                for (n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexKilled)) continue;
                    x = table.getDouble(n, indexX);
                    y = table.getDouble(n, indexY);
                    v = table.getDouble(n, indexV);
                    ix = (int)(x / this.BinSize);
                    iy = (int)(y / this.BinSize);
                    this.MaxIndexX = Math.max(this.MaxIndexX, ix);
                    this.MinIndexX = Math.min(this.MinIndexX, ix);
                    this.MaxIndexY = Math.max(this.MaxIndexY, iy);
                    this.MinIndexY = Math.min(this.MinIndexY, iy);
                }
            }
            this.NumX = this.MaxIndexX - this.MinIndexX + 1;
            this.NumY = this.MaxIndexY - this.MinIndexY + 1;
            this.allocate();
            for (iter = 0; iter <= 1; ++iter) {
                table = t1;
                if (iter == 1) {
                    table = t2;
                }
                indexX = table.column_indexOfColumn("Easting");
                indexY = table.column_indexOfColumn("Northing");
                indexV = table.column_indexOfColumn(column);
                indexKilled = table.column_indexOfColumn("Killed");
                for (n = 0; n < table.row_count(); ++n) {
                    if (table.getBool(n, indexKilled)) continue;
                    x = table.getDouble(n, indexX);
                    y = table.getDouble(n, indexY);
                    v = table.getDouble(n, indexV);
                    ix = (int)(x / this.BinSize);
                    iy = (int)(y / this.BinSize);
                    this.add(ix - this.MinIndexX, iy - this.MinIndexY, v, 1.0);
                }
            }
            this.finish(20);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public double get_world(double x, double y) {
        try {
            int ix = (int)(x / this.BinSize) - this.MinIndexX;
            int iy = (int)(y / this.BinSize) - this.MinIndexY;
            ix = Math.max(ix, 0);
            ix = Math.min(ix, this.NumX - 1);
            iy = Math.max(iy, 0);
            iy = Math.min(iy, this.NumY - 1);
            return this.value[ix][iy];
        }
        catch (Exception error) {
            error.printStackTrace();
            return 0.0;
        }
    }

    public void add(int ix, int iy, double v, double w) {
        try {
            w = Math.max(0.01, w);
            double[] dArray = this.sum1[ix];
            int n = iy;
            dArray[n] = dArray[n] + v * w;
            double[] dArray2 = this.sum2[ix];
            int n2 = iy;
            dArray2[n2] = dArray2[n2] + w;
            this.valid1[ix][iy] = true;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void finish(int max_radius) {
        try {
            int numok = 0;
            for (int x = 0; x < this.NumX; ++x) {
                for (int y = 0; y < this.NumY; ++y) {
                    if (!this.valid1[x][y]) continue;
                    this.value[x][y] = this.sum1[x][y] / this.sum2[x][y];
                    ++numok;
                }
            }
            if (numok < 1) {
                return;
            }
            int maxn = Math.max(this.NumX, this.NumY);
            int rad = max_radius;
            boolean notDone = true;
            int loopcount = 0;
            while (notDone) {
                int y;
                int x;
                if (loopcount > maxn) {
                    throw new Exception("Bad loop count");
                }
                notDone = false;
                ++rad;
                rad = Math.min(rad, max_radius);
                numok = 0;
                for (int x2 = 0; x2 < this.NumX; ++x2) {
                    for (int y2 = 0; y2 < this.NumY; ++y2) {
                        this.valid2[x2][y2] = this.valid1[x2][y2];
                        if (!this.valid1[x2][y2]) continue;
                        ++numok;
                    }
                }
                int numfixed = 0;
                for (x = 0; x < this.NumX; ++x) {
                    for (y = 0; y < this.NumY; ++y) {
                        if (this.valid1[x][y]) continue;
                        notDone = true;
                        int startx = Math.max(x - 1, 0);
                        int endx = Math.min(x + 1, this.NumX - 1);
                        int starty = Math.max(y - 1, 0);
                        int endy = Math.min(y + 1, this.NumY - 1);
                        int nn = 0;
                        for (int ix = startx; ix <= endx; ++ix) {
                            for (int iy = starty; iy <= endy; ++iy) {
                                if (!this.valid1[ix][iy]) continue;
                                ++nn;
                            }
                        }
                        if (nn < true) continue;
                        startx = Math.max(x - rad, 0);
                        endx = Math.min(x + rad, this.NumX - 1);
                        starty = Math.max(y - rad, 0);
                        endy = Math.min(y + rad, this.NumY - 1);
                        float s1 = 0.0f;
                        float s2 = 0.0f;
                        for (int ix = startx; ix <= endx; ++ix) {
                            for (int iy = starty; iy <= endy; ++iy) {
                                if (!this.valid1[ix][iy]) continue;
                                int dx = Math.abs(x - ix);
                                int dy = Math.abs(y - iy);
                                float wx = (float)rad / (float)(1 + dx);
                                float wy = (float)rad / (float)(1 + dy);
                                float w = wx * wy;
                                s1 = (float)((double)s1 + this.value[ix][iy] * (double)(w *= (float)this.sum2[ix][iy]));
                                s2 += w;
                            }
                        }
                        this.valid2[x][y] = true;
                        this.value[x][y] = s1 / s2;
                        this.sum2[x][y] = 0.5;
                        ++numfixed;
                    }
                }
                for (x = 0; x < this.NumX; ++x) {
                    for (y = 0; y < this.NumY; ++y) {
                        this.valid1[x][y] = this.valid2[x][y];
                    }
                }
                ++loopcount;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return true;
        }
        catch (Exception error) {
            error.printStackTrace();
            return true;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        try {
            return 1;
        }
        catch (Exception error) {
            error.printStackTrace();
            return 1;
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int w = 1 + (int)(this.BinSize * scaleX);
            int h = w / 2;
            h = Math.max(h, 1);
            w = 1 + 2 * h;
            for (int x1 = 0; x1 < this.NumX; ++x1) {
                for (int y1 = 0; y1 < this.NumY; ++y1) {
                    double v = this.value[x1][y1];
                    double x = (double)(x1 + this.MinIndexX) * this.BinSize;
                    double y = (double)(y1 + this.MinIndexY) * this.BinSize;
                    int ix1 = (int)(scaleX * x + shiftX);
                    int iy1 = (int)(scaleY * y + shiftY);
                    if (!colorWrapper.valueOK(v)) continue;
                    g2d.setColor(colorWrapper.colorUsingValue(v));
                    g2d.fillRect(ix1 - h, iy1 - h, w, w);
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            rangeX.expandRange((double)this.MinIndexX * this.BinSize);
            rangeX.expandRange((double)this.MaxIndexX * this.BinSize);
            rangeY.expandRange((double)this.MinIndexY * this.BinSize);
            rangeY.expandRange((double)this.MaxIndexY * this.BinSize);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            for (int ix = 0; ix < this.NumX; ++ix) {
                for (int iy = 0; iy < this.NumY; ++iy) {
                    rangeC.expandRange(this.value[ix][iy]);
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

