/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Filter;

import com.PecosLibrary.Math.Filter.FilterResponse_Abstract;

public class FilterResponse_Notch
extends FilterResponse_Abstract {
    protected float m_center = 60.0f;
    protected float m_width = 4.0f;
    protected float m_min = 59.5f;
    protected float m_max = 60.5f;

    public FilterResponse_Notch() {
        this.setCenter(60.0f);
        this.setWidth(3.0f);
    }

    public void setCenter(float c) {
        float diff = Math.abs(c - this.m_center);
        if (diff < 0.01f) {
            return;
        }
        this.m_center = c;
        this.m_center = Math.max(0.5f, this.m_center);
        this.m_min = this.m_center - 0.5f;
        this.m_max = this.m_center + 0.5f;
        this.m_modified = true;
    }

    public void setWidth(float w) {
        float diff = Math.abs(w - this.m_width);
        if (diff < 0.01f) {
            return;
        }
        this.m_width = w;
        this.m_width = Math.max(0.5f, this.m_width);
        this.m_modified = true;
    }

    @Override
    public float response(float frequency) {
        float temp1;
        float temp2 = 0.0f;
        if (frequency >= this.m_max) {
            temp1 = 2.0f * Math.abs(frequency - this.m_max) / this.m_width;
            temp2 = temp1 * temp1 / (1.0f + temp1 * temp1);
        }
        if (frequency <= this.m_min) {
            temp1 = 2.0f * Math.abs(this.m_min - frequency) / this.m_width;
            temp2 = temp1 * temp1 / (1.0f + temp1 * temp1);
        }
        return temp2;
    }
}

