/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Delauney;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Delauney.DelaunayEdge;
import com.PecosLibrary.Math.Delauney.DelaunayPoint;
import java.util.ArrayList;

public class Delaunay {
    protected double m_nominalDistance = 10.0;
    protected ArrayList<DelaunayPoint> m_inputPointList = new ArrayList();
    protected ArrayList<DelaunayPoint> m_pointList = new ArrayList();

    public int inputPointCount() {
        return this.m_inputPointList.size();
    }

    public DelaunayPoint getInputDelaunayPoint(int index) {
        return this.m_inputPointList.get(index);
    }

    public void clearInputPointList() {
        try {
            this.m_inputPointList.clear();
            this.clearCurrentTriangulation();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int pointCount() {
        return this.m_pointList.size();
    }

    public DelaunayPoint getDelaunayPoint(int index) {
        return this.m_pointList.get(index);
    }

    public void clearPointList() {
        try {
            this.m_pointList.clear();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void insertPoint(double x, double y, double v) throws Exception {
        try {
            this.clearCurrentTriangulation();
            for (DelaunayPoint point : this.m_inputPointList) {
                if (!point.isWithinRadius(x, y, this.m_nominalDistance)) continue;
                point.mergePoint(x, y, v);
                return;
            }
            this.m_inputPointList.add(new DelaunayPoint(x, y, v));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clearCurrentTriangulation() throws Exception {
        try {
            this.clearPointList();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void triangulate(double minX, double maxX, double minY, double maxY) throws Exception {
        try {
            this.clearCurrentTriangulation();
            if (this.m_inputPointList.size() < 1) {
                throw new Exception("m_inputPointList.size() < 1");
            }
            double sumV = 0.0;
            double sumCount = 0.0;
            for (DelaunayPoint point : this.m_inputPointList) {
                sumCount += point.Count;
                sumV += point.Count * point.V;
                minX = Math.min(minX, point.X - 2.0 * this.m_nominalDistance);
                maxX = Math.max(maxX, point.X + 2.0 * this.m_nominalDistance);
                minY = Math.min(minY, point.Y - 2.0 * this.m_nominalDistance);
                maxY = Math.max(maxY, point.Y + 2.0 * this.m_nominalDistance);
            }
            double averageV = sumV / sumCount;
            this.m_pointList.add(new DelaunayPoint(minX, minY, averageV));
            this.m_pointList.add(new DelaunayPoint(maxX, minY, averageV));
            this.m_pointList.add(new DelaunayPoint(maxX, maxY, averageV));
            this.m_pointList.add(new DelaunayPoint(minX, maxY, averageV));
            for (DelaunayPoint point : this.m_inputPointList) {
                this.m_pointList.add(point.clone());
            }
            DelaunayEdge edge01 = new DelaunayEdge(this.m_pointList.get(0), this.m_pointList.get(1), this.m_nominalDistance);
            DelaunayEdge edge12 = new DelaunayEdge(this.m_pointList.get(1), this.m_pointList.get(2), this.m_nominalDistance);
            DelaunayEdge edge23 = new DelaunayEdge(this.m_pointList.get(2), this.m_pointList.get(3), this.m_nominalDistance);
            DelaunayEdge edge30 = new DelaunayEdge(this.m_pointList.get(3), this.m_pointList.get(0), this.m_nominalDistance);
            DelaunayEdge edge31 = new DelaunayEdge(this.m_pointList.get(3), this.m_pointList.get(1), this.m_nominalDistance);
            int n = 4;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double getInterpolatedValue(double x, double y) throws Exception {
        try {
            for (DelaunayPoint point : this.m_pointList) {
                if (!point.isWithinRadius(x, y, 1.0)) continue;
                return point.V;
            }
            return 0.0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

