/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Matrix_Simple;
import com.PecosLibrary.Math.Matrix_Simple_Float;

public class ConjugateGradient {
    public static Matrix_Simple compute(Matrix_Simple A, Matrix_Simple y) {
        try {
            int lenX = A.ColumnCount;
            int lenY = y.RowCount;
            Matrix_Simple z = new Matrix_Simple(lenX, 1);
            Matrix_Simple z_next = new Matrix_Simple(lenX, 1);
            Matrix_Simple r = new Matrix_Simple(lenX, 1);
            Matrix_Simple r_next = new Matrix_Simple(lenX, 1);
            Matrix_Simple p = new Matrix_Simple(lenX, 1);
            Matrix_Simple p_next = new Matrix_Simple(lenX, 1);
            Matrix_Simple p_transpose = new Matrix_Simple(1, lenX);
            Matrix_Simple t = new Matrix_Simple(lenY, 1);
            Matrix_Simple t_next = new Matrix_Simple(lenY, 1);
            Matrix_Simple u = new Matrix_Simple(lenX, 1);
            for (int n = 0; n < lenX; ++n) {
                z.Data[n][0] = 0.0;
            }
            r = Matrix_Simple.copy(y);
            p = Matrix_Simple.copy(r);
            t = A.times(p);
            double alpha = 0.0;
            double beta = 0.0;
            for (int k = 0; k < 4; ++k) {
                p_transpose = p.transpose();
                u = p_transpose.times(t);
                alpha = r.magnitude() / u.Data[0][0];
                z_next = z.plus(p, alpha);
                double z_average = ConjugateGradient.average(z_next.transpose().Data[0]);
                r_next = r.minus(t, alpha);
                double r_average = ConjugateGradient.average(r_next.transpose().Data[0]);
                beta = r_next.magnitude() / r.magnitude();
                p_next = r_next.plus(p, beta);
                t_next = A.times(p_next);
                z = Matrix_Simple.copy(z_next);
                r = Matrix_Simple.copy(r_next);
                p = Matrix_Simple.copy(p_next);
                t = Matrix_Simple.copy(t_next);
            }
            return z_next;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Matrix_Simple_Float compute(Matrix_Simple_Float A, Matrix_Simple_Float y) {
        try {
            int lenX = A.ColumnCount;
            int lenY = y.RowCount;
            Matrix_Simple_Float z = new Matrix_Simple_Float(lenX, 1);
            Matrix_Simple_Float z_next = new Matrix_Simple_Float(lenX, 1);
            Matrix_Simple_Float r = Matrix_Simple_Float.copy(y);
            Matrix_Simple_Float p = Matrix_Simple_Float.copy(r);
            Matrix_Simple_Float t = A.times(p);
            float alpha = 0.0f;
            float beta = 0.0f;
            for (int k = 0; k < 4; ++k) {
                Matrix_Simple_Float p_transpose = p.transpose();
                Matrix_Simple_Float u = p_transpose.times(t);
                alpha = r.magnitude() / u.Data[0][0];
                z_next = z.plus(p, alpha);
                float z_average = ConjugateGradient.average(z_next.transpose().Data[0]);
                Matrix_Simple_Float r_next = r.minus(t, alpha);
                double r_average = ConjugateGradient.average(r_next.transpose().Data[0]);
                System.out.println("Iteration " + k + ":");
                System.out.println("z: " + z_average + "  r: " + r_average + "  ratio: " + r_average / (double)z_average);
                beta = r_next.magnitude() / r.magnitude();
                Matrix_Simple_Float p_next = r_next.plus(p, beta);
                Matrix_Simple_Float t_next = A.times(p_next);
                z = Matrix_Simple_Float.copy(z_next);
                r = Matrix_Simple_Float.copy(r_next);
                p = Matrix_Simple_Float.copy(p_next);
                t = Matrix_Simple_Float.copy(t_next);
            }
            return z_next;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static double average(double[] array) {
        try {
            int length = array.length;
            double sum = 0.0;
            for (int n = 0; n < length; ++n) {
                sum += array[n];
            }
            double total = sum / (double)length;
            return total;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -1.0;
        }
    }

    public static float average(float[] array) {
        try {
            int length = array.length;
            float sum = 0.0f;
            for (int n = 0; n < length; ++n) {
                sum += array[n];
            }
            float total = sum / (float)length;
            return total;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -1.0f;
        }
    }
}

