/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Math.PlanarFit;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;

public class AxisGrid_Interpolator
implements Java2D_PaintableInterface {
    protected double[] m_inputX;
    protected double[] m_inputY;
    protected double[] m_inputZ;
    public boolean GridValid = false;
    public double OriginX;
    public double OriginY;
    public double GridSize;
    public int NumX;
    public int NumY;
    public int[][] Count;
    public float[][] Weight;
    public float[][] Sum;
    public float[][] Value;
    public Range_Double Range = new Range_Double();
    public float[][] Temp;
    public boolean[][] Valid;
    public float[][] DistanceWeight = new float[50][50];
    public float MinAddedWeight = Float.MAX_VALUE;
    public float MinSumWeight = Float.MAX_VALUE;
    public int NumAddedToTemp = 0;
    public int NumX_Coarse;
    public int NumY_Coarse;
    public int[][] Count_Coarse;
    public float[][] Weight_Coarse;
    public float[][] Sum_Coarse;
    public float[][] Value_Coarse;
    public float[][] Temp_Coarse;
    public boolean[][] Valid_Coarse;
    public int IndexX;
    public int IndexY;
    public int IndexX_Coarse;
    public int IndexY_Coarse;
    protected PlanarFit m_planarFit = new PlanarFit();
    public boolean ApplyPlane = false;
    protected boolean ImageDirty = true;

    public AxisGrid_Interpolator() throws Exception {
        try {
            this.prep(0.0, 0.0, 100.0, 20, 20);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public AxisGrid_Interpolator(double ox, double oy, double gridSize, int nx, int ny) throws Exception {
        try {
            this.prep(ox, oy, gridSize, nx, ny);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createGrid(double buffer, double gridSize) {
        try {
            this.createGrid(buffer, gridSize, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createGrid(double buffer, double gridSize, boolean setWeightToOne) {
        try {
            this.GridValid = false;
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (int n = 0; n < this.m_inputX.length; ++n) {
                minX = Math.min(minX, this.m_inputX[n] - buffer);
                maxX = Math.max(maxX, this.m_inputX[n] + buffer);
                minY = Math.min(minY, this.m_inputY[n] - buffer);
                maxY = Math.max(maxY, this.m_inputY[n] + buffer);
            }
            this.createGrid(minX, minY, maxX, maxY, gridSize, setWeightToOne);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createGrid(double minX, double minY, double maxX, double maxY, double gridSize, boolean setWeightToOne) {
        try {
            this.ImageDirty = true;
            this.GridValid = false;
            if (this.m_inputX == null) {
                return;
            }
            if (this.m_inputX.length < 2) {
                return;
            }
            int nx = 1 + (int)((maxX - minX) / gridSize);
            int ny = 1 + (int)((maxY - minY) / gridSize);
            this.prep(minX, minY, gridSize, nx, ny);
            if (!this.ApplyPlane) {
                for (int n = 0; n < this.m_inputX.length; ++n) {
                    this.add(this.m_inputX[n], this.m_inputY[n], (float)this.m_inputZ[n], 1.0f);
                }
                this.finish(setWeightToOne);
            } else {
                int n;
                this.m_planarFit.clear();
                for (n = 0; n < this.m_inputX.length; ++n) {
                    this.m_planarFit.add(this.m_inputX[n], this.m_inputY[n], this.m_inputZ[n]);
                }
                this.m_planarFit.leastSquaredFit();
                for (n = 0; n < this.m_inputX.length; ++n) {
                    double zp = this.m_planarFit.A * this.m_inputX[n] + this.m_planarFit.B * this.m_inputY[n] + this.m_planarFit.C;
                    float z = (float)(this.m_inputZ[n] - zp);
                    this.add(this.m_inputX[n], this.m_inputY[n], z, 1.0f);
                }
                this.finish(setWeightToOne);
                this.Range.clearRange();
                for (int ix = 0; ix < this.NumX; ++ix) {
                    for (int iy = 0; iy < this.NumY; ++iy) {
                        float z;
                        double x = this.OriginX + (double)ix * this.GridSize;
                        double y = this.OriginY + (double)iy * this.GridSize;
                        double zp = this.m_planarFit.A * x + this.m_planarFit.B * y + this.m_planarFit.C;
                        this.Value[ix][iy] = z = this.Value[ix][iy] + (float)zp;
                        this.Range.expandRange(this.Value[ix][iy]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createGrid(double minX, double minY, double maxX, double maxY, double gridSize) {
        try {
            this.createGrid(minX, minY, maxX, maxY, gridSize, false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setInputData(double[] x, double[] y, double[] z) {
        try {
            this.ImageDirty = true;
            if (x == null) {
                this.m_inputX = null;
                this.m_inputY = null;
                this.m_inputZ = null;
                return;
            }
            this.m_inputX = new double[x.length];
            this.m_inputY = new double[x.length];
            this.m_inputZ = new double[x.length];
            System.arraycopy(x, 0, this.m_inputX, 0, x.length);
            System.arraycopy(y, 0, this.m_inputY, 0, x.length);
            System.arraycopy(z, 0, this.m_inputZ, 0, x.length);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepIndices(double x, double y) {
        try {
            this.IndexX = (int)((x - this.OriginX) / this.GridSize);
            this.IndexX = Math.max(this.IndexX, 0);
            this.IndexX = Math.min(this.IndexX, this.NumX - 1);
            this.IndexX_Coarse = this.IndexX / 10;
            this.IndexY = (int)((y - this.OriginY) / this.GridSize);
            this.IndexY = Math.max(this.IndexY, 0);
            this.IndexY = Math.min(this.IndexY, this.NumY - 1);
            this.IndexY_Coarse = this.IndexY / 10;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float getValue(double x, double y) {
        try {
            this.prepIndices(x, y);
            return this.Value[this.IndexX][this.IndexY];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected void add(double x, double y, float v, float w) {
        try {
            this.GridValid = false;
            this.MinAddedWeight = Math.min(this.MinAddedWeight, w);
            this.prepIndices(x, y);
            this.Count[this.IndexX][this.IndexY] = this.Count[this.IndexX][this.IndexY] + 1;
            this.Weight[this.IndexX][this.IndexY] = this.Weight[this.IndexX][this.IndexY] + w;
            this.Sum[this.IndexX][this.IndexY] = this.Sum[this.IndexX][this.IndexY] + w * v;
            this.Count_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] = this.Count_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] + 1;
            this.Weight_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] = this.Weight_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] + w;
            this.Sum_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] = this.Sum_Coarse[this.IndexX_Coarse][this.IndexY_Coarse] + w * v;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finish() {
        try {
            this.finish(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finish(boolean setAllWeightsToOne) {
        try {
            int x;
            float sum2;
            float sum1;
            int y;
            this.GridValid = false;
            boolean done = false;
            for (int x2 = 0; x2 < this.NumX_Coarse; ++x2) {
                for (int y2 = 0; y2 < this.NumY_Coarse; ++y2) {
                    this.Valid_Coarse[x2][y2] = false;
                    if (this.Count_Coarse[x2][y2] < 1) continue;
                    this.Valid_Coarse[x2][y2] = true;
                    float wc = this.Weight_Coarse[x2][y2];
                    this.Value_Coarse[x2][y2] = this.Sum_Coarse[x2][y2] / (wc + 1.0E-20f);
                    if (!setAllWeightsToOne) continue;
                    this.Weight_Coarse[x2][y2] = 1000.0f;
                }
            }
            float weight = 0.1f * this.MinAddedWeight;
            weight = Math.max(weight, 1.0E-4f);
            if (setAllWeightsToOne) {
                weight = 1.0f;
            }
            int iter = 0;
            done = false;
            while (!done) {
                if (++iter > this.NumX + this.NumY) {
                    return;
                }
                done = true;
                for (int x3 = 0; x3 < this.NumX_Coarse; ++x3) {
                    for (y = 0; y < this.NumY_Coarse; ++y) {
                        if (this.Valid_Coarse[x3][y]) continue;
                        done = false;
                        sum1 = 0.0f;
                        sum2 = 1.0E-20f;
                        int count = 0;
                        int minX = Math.max(0, x3 - 5);
                        int maxX = Math.min(this.NumX_Coarse - 1, x3 + 5);
                        int minY = Math.max(0, y - 5);
                        int maxY = Math.min(this.NumY_Coarse - 1, y + 5);
                        for (int ix = minX; ix <= maxX; ++ix) {
                            for (int iy = minY; iy <= maxY; ++iy) {
                                if (!this.Valid_Coarse[ix][iy]) continue;
                                float w2 = this.DistanceWeight[Math.abs(x3 - ix)][Math.abs(y - iy)];
                                float w = w2 * this.Weight_Coarse[ix][iy];
                                sum1 += w * this.Value_Coarse[ix][iy];
                                sum2 += w;
                                ++count;
                            }
                        }
                        if (count < true) continue;
                        this.Weight_Coarse[x3][y] = weight;
                        this.Value_Coarse[x3][y] = sum1 / sum2;
                        this.Valid_Coarse[x3][y] = true;
                    }
                }
            }
            for (x = 0; x < this.NumX_Coarse; ++x) {
                for (y = 0; y < this.NumY_Coarse; ++y) {
                    this.Temp_Coarse[x][y] = this.Value_Coarse[x][y];
                }
            }
            for (x = 0; x < this.NumX_Coarse; ++x) {
                for (y = 0; y < this.NumY_Coarse; ++y) {
                    sum1 = 0.0f;
                    sum2 = 1.0E-20f;
                    int minX = Math.max(0, x - 5);
                    int maxX = Math.min(this.NumX_Coarse - 1, x + 5);
                    int minY = Math.max(0, y - 5);
                    int maxY = Math.min(this.NumY_Coarse - 1, y + 5);
                    for (int ix = minX; ix <= maxX; ++ix) {
                        for (int iy = minY; iy <= maxY; ++iy) {
                            float w2 = this.DistanceWeight[Math.abs(x - ix)][Math.abs(y - iy)];
                            float w = w2 * this.Weight_Coarse[ix][iy];
                            sum1 += w * this.Temp_Coarse[ix][iy];
                            sum2 += w;
                        }
                    }
                    this.Value_Coarse[x][y] = sum1 / sum2;
                }
            }
            float fineWeight = 0.01f * this.MinAddedWeight;
            fineWeight = Math.max(fineWeight, 1.0E-4f);
            if (setAllWeightsToOne) {
                fineWeight = 0.1f;
            }
            for (int x4 = 0; x4 < this.NumX; ++x4) {
                for (int y3 = 0; y3 < this.NumY; ++y3) {
                    if (this.Count[x4][y3] >= 1) {
                        this.Value[x4][y3] = this.Sum[x4][y3] / this.Weight[x4][y3];
                        if (!setAllWeightsToOne) continue;
                        this.Weight[x4][y3] = 1.0f;
                        continue;
                    }
                    this.Value[x4][y3] = this.Value_Coarse[x4 / 10][y3 / 10];
                    this.Weight[x4][y3] = fineWeight;
                }
            }
            for (int loop = 0; loop < 3; ++loop) {
                int y4;
                int x5;
                int rad = 8;
                if (loop == 0) {
                    fineWeight = 0.001f;
                    rad = 20;
                } else if (loop == 1) {
                    fineWeight = 0.01f;
                    rad = 6;
                } else {
                    fineWeight = 0.1f;
                    rad = 4;
                }
                for (x5 = 0; x5 < this.NumX; ++x5) {
                    for (y4 = 0; y4 < this.NumY; ++y4) {
                        if (this.Count[x5][y4] >= 1) continue;
                        this.Weight[x5][y4] = fineWeight;
                    }
                }
                this.Range.clearRange();
                for (x5 = 0; x5 < this.NumX; ++x5) {
                    for (y4 = 0; y4 < this.NumY; ++y4) {
                        this.Temp[x5][y4] = this.Value[x5][y4];
                        this.Range.expandRange(this.Value[x5][y4]);
                    }
                }
                this.Range.clearRange();
                for (x5 = 0; x5 < this.NumX; ++x5) {
                    for (y4 = 0; y4 < this.NumY; ++y4) {
                        if (this.Count[x5][y4] < 1) {
                            float sum12 = 0.0f;
                            float sum22 = 1.0E-20f;
                            int minX = Math.max(0, x5 - rad);
                            int maxX = Math.min(this.NumX - 1, x5 + rad);
                            int minY = Math.max(0, y4 - rad);
                            int maxY = Math.min(this.NumY - 1, y4 + rad);
                            for (int ix = minX; ix <= maxX; ++ix) {
                                for (int iy = minY; iy <= maxY; ++iy) {
                                    float w2 = this.DistanceWeight[Math.abs(x5 - ix)][Math.abs(y4 - iy)];
                                    float w = w2 * this.Weight[ix][iy];
                                    sum12 += w * this.Temp[ix][iy];
                                    sum22 += w;
                                }
                            }
                            this.Value[x5][y4] = sum12 / sum22;
                        }
                        this.Range.expandRange(this.Value[x5][y4]);
                    }
                }
            }
            this.GridValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prep(double ox, double oy, double gridSize, int nx, int ny) throws Exception {
        try {
            int y;
            int x;
            this.MinAddedWeight = Float.MAX_VALUE;
            this.OriginX = ox;
            this.OriginY = oy;
            this.GridSize = gridSize;
            nx = Math.max(nx, 10);
            ny = Math.max(ny, 10);
            this.NumX_Coarse = nx / 10;
            if (nx % 10 != 0) {
                ++this.NumX_Coarse;
            }
            this.NumY_Coarse = ny / 10;
            if (ny % 10 != 0) {
                ++this.NumY_Coarse;
            }
            this.NumX = this.NumX_Coarse * 10;
            this.NumY = this.NumY_Coarse * 10;
            long total = (long)this.NumX * (long)this.NumY;
            if (total < 1L) {
                throw new Exception("(total < 1)");
            }
            if (total >= 50000000L) {
                throw new Exception("total >= 50000000");
            }
            for (x = 0; x < this.DistanceWeight.length; ++x) {
                for (y = 0; y < this.DistanceWeight.length; ++y) {
                    this.DistanceWeight[x][y] = 0.2f / (0.2f + (float)(x * x) + (float)(y * y));
                }
            }
            this.Count_Coarse = new int[this.NumX_Coarse][this.NumY_Coarse];
            this.Temp_Coarse = new float[this.NumX_Coarse][this.NumY_Coarse];
            this.Weight_Coarse = new float[this.NumX_Coarse][this.NumY_Coarse];
            this.Sum_Coarse = new float[this.NumX_Coarse][this.NumY_Coarse];
            this.Value_Coarse = new float[this.NumX_Coarse][this.NumY_Coarse];
            this.Valid_Coarse = new boolean[this.NumX_Coarse][this.NumY_Coarse];
            for (x = 0; x < this.NumX_Coarse; ++x) {
                for (y = 0; y < this.NumY_Coarse; ++y) {
                    this.Valid_Coarse[x][y] = false;
                    this.Count_Coarse[x][y] = 0;
                    this.Weight_Coarse[x][y] = 1.0E-40f;
                    this.Sum_Coarse[x][y] = 0.0f;
                    this.Value_Coarse[x][y] = 0.0f;
                }
            }
            this.Count = new int[this.NumX][this.NumY];
            this.Temp = new float[this.NumX][this.NumY];
            this.Weight = new float[this.NumX][this.NumY];
            this.Sum = new float[this.NumX][this.NumY];
            this.Value = new float[this.NumX][this.NumY];
            this.Valid = new boolean[this.NumX][this.NumY];
            for (x = 0; x < this.NumX; ++x) {
                for (y = 0; y < this.NumY; ++y) {
                    this.Valid[x][y] = false;
                    this.Count[x][y] = 0;
                    this.Weight[x][y] = 1.0E-40f;
                    this.Sum[x][y] = 0.0f;
                    this.Value[x][y] = 0.0f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.ImageDirty;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            this.ImageDirty = true;
            if (!this.GridValid) {
                return;
            }
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixPerGrid = 1 + (int)(this.GridSize * scaleX);
            int half = pixPerGrid / 2;
            for (int i = 0; i < this.NumX; ++i) {
                for (int j = 0; j < this.NumY; ++j) {
                    double x = this.OriginX + (double)i * this.GridSize;
                    double y = this.OriginY + (double)j * this.GridSize;
                    int ix = (int)(scaleX * x + shiftX);
                    int iy = (int)(scaleY * y + shiftY);
                    g2d.setColor(colorWrapper.colorUsingValue(this.Value[i][j]));
                    g2d.fillRect(ix, iy, pixPerGrid, pixPerGrid);
                }
            }
            g2d.setColor(Color.black);
            if (this.m_inputX != null) {
                for (int n = 0; n < this.m_inputX.length; ++n) {
                    int ix = (int)(scaleX * this.m_inputX[n] + shiftX);
                    int iy = (int)(scaleY * this.m_inputY[n] + shiftY);
                    g2d.drawOval(ix - 7, iy - 7, 14, 14);
                }
            }
            this.ImageDirty = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.GridValid) {
                return;
            }
            rangeX.expandRange(this.OriginX);
            rangeX.expandRange(this.OriginX + (double)this.NumX * this.GridSize);
            rangeY.expandRange(this.OriginY);
            rangeY.expandRange(this.OriginY + (double)this.NumY * this.GridSize);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (this.GridValid) {
                rangeC.expandRange(this.Range);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

