/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Tools.Tools_Strings;
import javax.swing.DefaultListModel;

public abstract class Worker_Base {
    protected long m_startTime = System.currentTimeMillis();
    protected boolean m_bIsHalted = false;
    protected ParameterTree m_parameterTree = new ParameterTree();
    protected String m_scratchPath = null;
    protected double m_percentDone = 0.0;
    protected DefaultListModel<String> m_listModel = new DefaultListModel();
    protected Object m_dataObject;
    protected String[] m_message = new String[5];

    public void resetStartTime() {
        this.m_startTime = System.currentTimeMillis();
    }

    public long runTime() {
        return (System.currentTimeMillis() - this.m_startTime) / 1000L;
    }

    public abstract String getDescription();

    public synchronized double percentDone() {
        return this.m_percentDone;
    }

    public DefaultListModel<String> listModel() {
        return this.m_listModel;
    }

    public void addToMessageList(String s) {
        try {
            if (s == null) {
                return;
            }
            if (s.length() < 1) {
                return;
            }
            int seconds = (int)this.runTime();
            String t = Tools_Strings.runTimeMessage(seconds);
            this.m_listModel.add(0, t + " - " + s);
            while (this.m_listModel.size() > 500) {
                this.m_listModel.remove(this.m_listModel.size() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String getMessage(int level) {
        try {
            if (level < 0 || level >= this.m_message.length) {
                return " ";
            }
            String s = this.m_message[level];
            if (s == null) {
                return " ";
            }
            return s;
        }
        catch (Exception ex) {
            return " ";
        }
    }

    public abstract void work() throws Exception;

    public abstract void cleanupAfterFinishedFailure();

    public void setScratchPath(String scratchPath) {
        this.m_scratchPath = scratchPath;
    }

    public String scratchPath() {
        return this.m_scratchPath;
    }

    public boolean getIsHalted() {
        return this.m_bIsHalted;
    }

    public void setIsHalted(boolean bIsHalted) {
        this.m_bIsHalted = bIsHalted;
    }

    public ParameterTree getParameterTree() {
        return this.m_parameterTree;
    }

    public void setParameterTree(ParameterTree params) {
        this.m_parameterTree = params;
    }

    public Object getDataObject() {
        return this.m_dataObject;
    }

    public void setDataObject(Object obj) {
        this.m_dataObject = obj;
    }
}

