/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobStatus;
import com.PecosLibrary.Job.KillJobDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class KillButtonEditor
extends DefaultCellEditor {
    protected JButton button = new JButton();
    private String label;
    private boolean isPushed;
    private Object _cellObject;

    public KillButtonEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KillButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        this._cellObject = value;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed && this._cellObject instanceof JobState) {
            JobState js = (JobState)this._cellObject;
            if (js.getJobStatus() == JobStatus.Working) {
                KillJobDialog dlg = new KillJobDialog(js.getWorkerDescription(), js.getCreationTime(), js.getJobID());
                dlg.showDialog();
                if (dlg.getDialogResult()) {
                    JobManager.singleton().removeJob(js.getJobID());
                }
            } else {
                String sMessage = "Unable to kill " + js.getJobStatus().toString() + " jobs";
                JOptionPane.showMessageDialog(null, sMessage + "\nTo remove an entry\nselect table rows and press delete", "", 1);
            }
        }
        this.isPushed = false;
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

