/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public class DatabaseConnection_Base
implements IDatabaseConnection {
    protected String m_databaseName;
    protected String m_urlPrefix;
    protected String m_connectionURL;
    protected Connection m_conn;
    protected boolean m_bIsMySQL = false;
    protected StringBuilder m_builder = new StringBuilder();
    protected boolean m_bConnectionValid = false;
    protected String m_connFailureReason = "";
    protected int[] m_colIndexConnections = new int[300];

    @Override
    public Connection connection() {
        return this.m_conn;
    }

    @Override
    public void closeConnection() {
        try {
            if (!this.m_conn.getAutoCommit()) {
                this.m_conn.commit();
            }
            this.m_conn.close();
            System.out.println("closeConnection m_connectionURL = " + this.m_connectionURL);
            System.out.println("closeConnection m_conn.isClosed() = " + this.m_conn.isClosed());
            this.m_bConnectionValid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean connectionOK() {
        return this.m_bConnectionValid;
    }

    @Override
    public String databaseName() {
        return this.m_databaseName;
    }

    @Override
    public void createIndex_OneColumn(String table, String column) {
        try {
            String sql = "CREATE INDEX INDEX_" + column + " ON " + table + " (" + column + ")";
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void createIndex_TwoColumn(String table, String indexName, String column1, String column2) {
        try {
            String sql = "CREATE INDEX " + indexName + " ON " + table + " (" + column1 + ", " + column2 + ")";
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void addColumnNotNull(String tableName, String colName, DataType type) {
        try {
            String sql = "ALTER TABLE " + tableName + " ADD " + Tools_JDBC.getColumnDefinitionString(colName, type) + " NOT NULL";
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public double selectColumnMax(String tableName, String colName) {
        try {
            String sql = "SELECT MAX(" + colName + ") FROM " + tableName;
            Table_Abstract table = this.extractTableDataUsingQuery("Junk", sql, 100);
            if (table.row_count() < 1 || table.column_count() < 1) {
                return -999999.0;
            }
            return table.getDouble(0, 0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -999999.0;
        }
    }

    @Override
    public Table_Abstract getColumnMetaData() throws Exception {
        try {
            DatabaseMetaData meta = this.m_conn.getMetaData();
            ResultSet rs = meta.getColumns(null, null, null, null);
            Table_Abstract matrix = this.extractTableDataUsingResultSet("Tables", rs);
            rs.close();
            Table_Abstract table_Abstract = matrix;
            return table_Abstract;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public Table_Abstract getTableMetaData() throws Exception {
        try {
            DatabaseMetaData meta = this.m_conn.getMetaData();
            ResultSet rs = meta.getTables(null, null, null, null);
            Table_Abstract matrix = this.extractTableDataUsingResultSet("Tables", rs);
            rs.close();
            Table_Abstract table_Abstract = matrix;
            return table_Abstract;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public ParameterTree extractParameterTree(String tableName) {
        try {
            Table_Abstract table = this.extractTableDataUsingQuery(tableName, "SELECT * FROM " + tableName, 1000);
            ParameterTree pt = new ParameterTree();
            int indexName = table.column_indexOfColumn("Name");
            int indexValue = table.column_indexOfColumn("Value");
            for (int n = 0; n < table.row_count(); ++n) {
                String name = table.getString(n, indexName);
                String val = table.getString(n, indexValue);
                pt.string_put(name, val);
            }
            return pt;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ParameterTree();
        }
    }

    @Override
    public void addParameterTree(String tableName, ParameterTree pt) {
        try {
            this.dropTable(tableName);
            ArrayList<String> keys = pt.string_keyList();
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName(tableName);
            int indexName = ((Table_Abstract)table).column_append("Name", DataType.Text);
            int indexvalue = ((Table_Abstract)table).column_append("Value", DataType.Text);
            for (String key : keys) {
                int row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putString(row, indexName, key);
                ((Table_Abstract)table).putString(row, indexvalue, pt.string_get(key));
            }
            this.createDatabaseTable(table);
            this.appendTable(table, indexName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void appendTable(Table_Abstract table, int firstRow) throws Exception {
        try {
            long start = System.currentTimeMillis();
            Table_Abstract currentTable = this.extractTableDataUsingQuery(table.name(), "SELECT * FROM " + table.name(), 1);
            int numValidColumns = 0;
            if (this.m_colIndexConnections.length <= table.column_count()) {
                this.m_colIndexConnections = new int[10 + table.column_count()];
            }
            for (int col = 0; col < table.column_count(); ++col) {
                String colName = table.column_name(col);
                if (!currentTable.column_exists(colName) || colName.startsWith("Temp")) continue;
                this.m_colIndexConnections[numValidColumns] = col;
                ++numValidColumns;
            }
            if (numValidColumns < 1) {
                return;
            }
            int startRow = firstRow;
            while (startRow < table.row_count()) {
                int endRow = startRow + 2000;
                if (endRow >= table.row_count()) {
                    endRow = table.row_count() - 1;
                }
                StringBuilder builder = new StringBuilder();
                builder.append("INSERT INTO ");
                builder.append(table.name());
                builder.append(" ( ");
                boolean colCount = false;
                for (int c = 0; c < numValidColumns; ++c) {
                    int col = this.m_colIndexConnections[c];
                    if (c >= 1) {
                        builder.append(", ");
                    }
                    builder.append(table.column_name(col));
                }
                builder.append(" ) ");
                builder.append(" VALUES ");
                for (int row = startRow; row <= endRow; ++row) {
                    if (row >= startRow + 1) {
                        builder.append(", ");
                    }
                    builder.append(" ( ");
                    for (int c = 0; c < numValidColumns; ++c) {
                        String valueString;
                        int col = this.m_colIndexConnections[c];
                        if (c >= 1) {
                            builder.append(", ");
                        }
                        if (table.column_type(col) == DataType.Text) {
                            builder.append("'");
                        }
                        if ((valueString = table.getString(row, col, 6)) != null) {
                            valueString = valueString.replace(",", ".");
                        }
                        builder.append(valueString);
                        if (table.column_type(col) != DataType.Text) continue;
                        builder.append("'");
                    }
                    builder.append(" ) ");
                }
                this.executeUpdateStatement(builder.toString());
                builder = null;
                System.gc();
                startRow = endRow + 1;
            }
            long end = System.currentTimeMillis();
            System.out.println("appendTable = " + Long.toString(end - start));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void addColumn(String tableName, String columnName, DataType dt) {
        try {
            ArrayList<String> cols = this.listOfColumnNames(tableName);
            for (String s : cols) {
                if (!s.equalsIgnoreCase(columnName)) continue;
                return;
            }
            int sqlType = Tools_JDBC.getJdbcTypeFromDataType(dt);
            String sql = "ALTER TABLE " + tableName + " ADD COLUMN " + columnName + Tools_JDBC.getColumnDefinitionString(sqlType);
            this.executeUpdateStatement(sql);
            Messenger.broadcast(Messenger.Message.ColumnsModified, null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void createDatabaseTable(Table_Abstract table) throws Exception {
        try {
            long start = System.currentTimeMillis();
            String name = table.name();
            if (name.length() < 1) {
                return;
            }
            if (this.tableExists(name)) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ");
            builder.append(name);
            builder.append(" (");
            int colCount = 0;
            String colNameID = name + "ID";
            if (table.column_exists(colNameID)) {
                builder.append(colNameID + " INT PRIMARY KEY");
                ++colCount;
            }
            for (int n = 0; n < table.column_count(); ++n) {
                String colName = table.column_name(n);
                DataType type = table.column_type(n);
                if (colName.equalsIgnoreCase(colNameID) || colName.startsWith("Temp")) continue;
                if (colCount >= 1) {
                    builder.append(", ");
                }
                int sqlType = Tools_JDBC.getJdbcTypeFromDataType(type);
                builder.append(colName);
                builder.append(Tools_JDBC.getColumnDefinitionString(sqlType));
                ++colCount;
            }
            builder.append(")");
            this.executeUpdateStatement(builder.toString());
            long end = System.currentTimeMillis();
            System.out.println("createDatabaseTable = " + Long.toString(end - start));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void dropTable(String tableName) throws Exception {
        try {
            this.executeUpdateStatement("DROP TABLE IF EXISTS " + tableName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void confirmColumn_Int(String tableName, String columnName, int value) throws Exception {
        try {
            if (this.columnExists(tableName, columnName)) {
                return;
            }
            this.addColumn(tableName, columnName, DataType.Int);
            String sql = String.format("UPDATE %s Set %s = %d", tableName, columnName, value);
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void confirmColumn_Double(String tableName, String columnName, double value) throws Exception {
        try {
            if (this.columnExists(tableName, columnName)) {
                return;
            }
            this.addColumn(tableName, columnName, DataType.Double);
            String valueString = Double.toString(value);
            valueString = valueString.replace(",", ".");
            String sql = String.format("UPDATE %s Set %s = %s", tableName, columnName, valueString);
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void confirmColumn_Bool(String tableName, String columnName, boolean value) throws Exception {
        try {
            if (this.columnExists(tableName, columnName)) {
                return;
            }
            this.addColumn(tableName, columnName, DataType.Bool);
            String sql = "";
            sql = value ? String.format("UPDATE %s Set %s = TRUE", tableName, columnName) : String.format("UPDATE %s Set %s = FALSE", tableName, columnName);
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void confirmColumn(String tableName, String columnName, DataType dt) throws Exception {
        try {
            if (this.columnExists(tableName, columnName)) {
                return;
            }
            this.addColumn(tableName, columnName, dt);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean columnExists(String tableName, String columnName) throws Exception {
        try {
            ArrayList<String> cols = this.listOfColumnNames(tableName);
            for (String s : cols) {
                if (!s.equalsIgnoreCase(columnName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws Exception {
        try {
            if (!this.columnExists(tableName, columnName)) {
                return;
            }
            String s = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, columnName);
            System.out.println(s);
            this.executeUpdateStatement(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public boolean tableExists(String tableName) throws Exception {
        try {
            ArrayList<String> names = this.getTableNames();
            for (String name : names) {
                if (!name.equalsIgnoreCase(tableName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public ArrayList<String> getTableNames() throws Exception {
        try {
            ArrayList<String> list = new ArrayList<String>();
            DatabaseMetaData meta = this.m_conn.getMetaData();
            ResultSet rs = meta.getTables(null, null, null, new String[]{"TABLE"});
            Table_Abstract matrix = this.extractTableDataUsingResultSet("Tables", rs);
            int index = matrix.column_indexOfColumn("TABLE_NAME");
            for (int row = 0; row < matrix.row_count(); ++row) {
                String tbl = matrix.getString(row, index);
                list.add(tbl);
            }
            rs.close();
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public ArrayList<String> listOfColumnNames(String tableName1, String tableName2) throws Exception {
        try {
            ArrayList<String> list1 = this.listOfColumnNames(tableName1);
            ArrayList<String> list2 = this.listOfColumnNames(tableName2);
            ArrayList<String> list = new ArrayList<String>();
            for (String s1 : list1) {
                boolean found = false;
                for (String s2 : list2) {
                    found = found || s1.equalsIgnoreCase(s2);
                }
                if (!found) continue;
                list.add(s1);
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public ArrayList<String> listOfColumnNames(String tableName) throws Exception {
        try {
            Statement st = this.m_conn.createStatement();
            st.setMaxRows(10);
            String sql = "SELECT * FROM " + tableName;
            ResultSet rs = st.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            ArrayList<String> list = new ArrayList<String>();
            for (int n = 1; n <= metaData.getColumnCount(); ++n) {
                String colName = metaData.getColumnName(n);
                list.add(colName);
            }
            rs.close();
            Collections.sort(list);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public Table_Abstract extractTableDataUsingQuery(String tableName, String sql, int maxRows) throws Exception {
        try {
            Statement st = this.m_conn.createStatement();
            if (maxRows > 0) {
                st.setMaxRows(maxRows);
            }
            ResultSet rs = st.executeQuery(sql);
            Table_Abstract matrix = this.extractTableDataUsingResultSet(tableName, rs);
            rs.close();
            Table_Abstract table_Abstract = matrix;
            return table_Abstract;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public Table_Abstract extractTableDataUsingResultSet(String tableName, ResultSet rs) throws Exception {
        try {
            Table_Memory table = new Table_Memory();
            this.populateTableUsingResultSet(table, tableName, rs);
            return table;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void writeColumnContentsToDatabase(Table_Abstract table, String columnName) throws Exception {
        try {
            String tableName = table.name();
            String colNameID = tableName + "ID";
            int indexCol = table.column_indexOfColumn(columnName);
            int indexID = table.column_indexOfColumn(colNameID);
            DataType type = table.column_type(indexCol);
            if (!this.columnExists(table.name(), columnName)) {
                this.addColumn(table.name(), columnName, type);
            }
            boolean isBool = type == DataType.Bool;
            boolean isInt = type == DataType.Int || type == DataType.Short;
            boolean isFloat = type == DataType.Float || type == DataType.Double;
            String firstChunk = String.format("UPDATE %s SET %s = ", tableName, columnName);
            String sqlTrue = firstChunk + "TRUE WHERE %s = %d;";
            String sqlFalse = firstChunk + "FALSE WHERE %s = %d;";
            String sqlInt = firstChunk + "%d WHERE %s = %d;";
            String sqlFloat = firstChunk + "%f WHERE %s = %d;";
            String sqlString = firstChunk + "%s WHERE %s = %d;";
            int numBad = 0;
            this.m_conn.setAutoCommit(false);
            Statement st = this.m_conn.createStatement();
            for (int row = 0; row < table.row_count(); ++row) {
                int id;
                int v;
                String sql = null;
                if (isBool) {
                    v = table.getBool(row, indexCol);
                    id = table.getInt(row, indexID);
                    sql = v != 0 ? String.format(sqlTrue, colNameID, id) : String.format(sqlFalse, colNameID, id);
                }
                if (isInt) {
                    v = table.getInt(row, indexCol);
                    id = table.getInt(row, indexID);
                    sql = String.format(sqlInt, v, colNameID, id);
                }
                if (isFloat) {
                    boolean bad;
                    double v2 = table.getDouble(row, indexCol);
                    boolean bl = bad = Double.isInfinite(v2) || Double.isNaN(v2);
                    if (!bad) {
                        if (Math.abs(v2) < 1.0E12) {
                            int id2 = table.getInt(row, indexID);
                            String valueString = Double.toString(v2);
                            valueString = valueString.replace(",", ".");
                            sql = String.format(sqlString, valueString, colNameID, id2);
                        }
                    } else {
                        ++numBad;
                    }
                }
                try {
                    if (sql == null) continue;
                    st.executeUpdate(sql);
                    continue;
                }
                catch (Exception sqlex) {
                    ++numBad;
                    sqlex.printStackTrace();
                }
            }
            this.m_conn.commit();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void populateTableUsingResultSet(Table_Abstract table, String tableName, ResultSet rs) {
        try {
            DataType type;
            table.setName(tableName);
            table.row_clear(false);
            ResultSetMetaData metaData = rs.getMetaData();
            table.moveColumnsToUnusedStorage();
            for (int n = 1; n <= metaData.getColumnCount(); ++n) {
                int col;
                String colName = metaData.getColumnName(n);
                int sqlType = metaData.getColumnType(n);
                type = Tools_JDBC.getDataTypeFromJdbcType(sqlType);
                this.m_colIndexConnections[n] = col = table.column_append(colName, type);
            }
            table.deleteColumnsInUnusedStorage();
            while (rs.next()) {
                int row = table.row_increment();
                for (int n = 1; n <= metaData.getColumnCount(); ++n) {
                    int col = this.m_colIndexConnections[n];
                    type = table.column_type(col);
                    if (type == DataType.Double) {
                        table.putDouble(row, col, rs.getDouble(n));
                        continue;
                    }
                    if (type == DataType.Int) {
                        table.putInt(row, col, rs.getInt(n));
                        continue;
                    }
                    if (type == DataType.Float) {
                        table.putFloat(row, col, rs.getFloat(n));
                        continue;
                    }
                    if (type == DataType.Bool) {
                        table.putBool(row, col, rs.getBoolean(n));
                        continue;
                    }
                    if (type == DataType.Text) {
                        table.putString(row, col, rs.getString(n));
                        continue;
                    }
                    if (type == DataType.Long) {
                        table.putLong(row, col, rs.getLong(n));
                        continue;
                    }
                    table.putInt(row, col, rs.getInt(n));
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void updateSingleRow_Double(String table, String col, int id, double v) throws Exception {
        try {
            if (Double.isInfinite(v) || Double.isNaN(v)) {
                System.out.println("ERROR updateSingleRow_Double isNAN or isInfinite");
                return;
            }
            String valueString = Double.toString(v);
            valueString = valueString.replace(",", ".");
            String sql = String.format("UPDATE %s SET %s = %s WHERE %sID = %d", table, col, valueString, table, id);
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void updateSingleRow_Int(String table, String col, int id, int v) throws Exception {
        try {
            String sql = String.format("UPDATE %s SET %s = %d WHERE %sID = %d", table, col, v, table, id);
            this.executeUpdateStatement(sql);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public int executeUpdateStatement(String sql) throws Exception {
        try {
            Statement st = this.m_conn.createStatement();
            boolean autoCommit = this.m_bIsMySQL;
            this.m_conn.setAutoCommit(autoCommit);
            int result = st.executeUpdate(sql);
            if (!autoCommit) {
                this.m_conn.commit();
            }
            st.close();
            int n = result;
            return n;
        }
        catch (Exception error) {
            System.out.println("SQL = " + sql);
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

