/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class GeometryShotTableWrapper {
    protected boolean m_valid = false;
    protected String m_failureReason = "";
    protected Table_Abstract m_table;
    protected Table_Abstract m_relationTable;
    protected Table_Abstract m_duplicateTable;
    protected int m_index_Line = -9999;
    protected int m_index_Point = -9999;
    protected int m_index_Index = -9999;
    protected int m_index_Line_Rel = -9999;
    protected int m_index_Point_Rel = -9999;
    protected int m_index_Index_Rel = -9999;
    protected HashMap_Integers<Integer> m_hashLPI = new HashMap_Integers();
    protected HashMap_Integers<FFIDENTRY> m_ffidHash = new HashMap_Integers();
    protected HashMap_Integers<String> m_fileHash;

    public boolean valid() {
        return this.m_valid;
    }

    public String failureReason() {
        return this.m_failureReason;
    }

    public Table_Abstract duplicateTable() {
        return this.m_duplicateTable;
    }

    public HashMap_Integers<FFIDENTRY> ffidHash() {
        return this.m_ffidHash;
    }

    public GeometryShotTableWrapper(Table_Abstract table, Table_Abstract relationTable, HashMap_Integers<String> fileHash) {
        try {
            this.m_fileHash = fileHash;
            this.m_table = table;
            this.m_relationTable = relationTable;
            this.m_duplicateTable = new Table_Memory();
            this.m_duplicateTable.setName("Duplicates");
            int indexLine = this.m_duplicateTable.column_append("LineNumber", DataType.Int);
            int indexPoint = this.m_duplicateTable.column_append("PointNumber", DataType.Int);
            int indexIndex = this.m_duplicateTable.column_append("PointIndex", DataType.Int);
            int indexFile1 = this.m_duplicateTable.column_append("File 1", DataType.Text);
            int indexLine1 = this.m_duplicateTable.column_append("Line 1", DataType.Int);
            int indexFile2 = this.m_duplicateTable.column_append("File 2", DataType.Text);
            int indexLine2 = this.m_duplicateTable.column_append("Line 2", DataType.Int);
            if (!this.m_table.column_exists("PointNumber")) {
                this.m_failureReason = "Shot must have PointNumber field";
                return;
            }
            if (!this.m_relationTable.column_exists("ShotPointNumber")) {
                this.m_failureReason = "Relation must have ShotPointNumber";
                return;
            }
            this.m_index_Point = this.m_table.column_indexOfColumn("PointNumber");
            this.m_index_Point_Rel = this.m_relationTable.column_indexOfColumn("ShotPointNumber");
            this.m_index_Index = -9999;
            this.m_index_Index_Rel = -9999;
            if (this.m_table.column_exists("PointIndex")) {
                if (!this.m_relationTable.column_exists("ShotPointIndex")) {
                    this.m_failureReason = "Shot has PointIndex, therefore Relation must have ShotPointIndex";
                    return;
                }
                this.m_index_Index = this.m_table.column_indexOfColumn("PointIndex");
                this.m_index_Index_Rel = this.m_relationTable.column_indexOfColumn("ShotPointIndex");
            }
            this.m_index_Line = -9999;
            this.m_index_Line_Rel = -9999;
            if (this.m_table.column_exists("LineNumber")) {
                if (!this.m_relationTable.column_exists("ShotLineNumber")) {
                    this.m_failureReason = "Shot has LineNumber, therefore Relation must have ShotLineNumber";
                }
                this.m_index_Line = this.m_table.column_indexOfColumn("LineNumber");
                this.m_index_Line_Rel = this.m_relationTable.column_indexOfColumn("ShotLineNumber");
            }
            int colLineNumber = this.m_table.column_indexOfColumn("LineNumberInFile");
            int colFileID = this.m_table.column_indexOfColumn("FileID");
            for (int row = 0; row < this.m_table.row_count(); ++row) {
                int line = 0;
                int point = this.m_table.getInt(row, this.m_index_Point);
                int index = 0;
                if (this.m_index_Index >= 0) {
                    index = this.m_table.getInt(row, this.m_index_Index);
                }
                if (this.m_index_Line >= 0) {
                    line = this.m_table.getInt(row, this.m_index_Line);
                }
                if (this.m_hashLPI.containsKey(line, point, index)) {
                    int otherRow = this.m_hashLPI.get(line, point, index);
                    int otherFileID = this.m_table.getInt(otherRow, colFileID);
                    int otherLineNumber = this.m_table.getInt(otherRow, colLineNumber);
                    String otherFile = this.m_fileHash.get(otherFileID);
                    int fileID = this.m_table.getInt(row, colFileID);
                    int lineNumber = this.m_table.getInt(row, colLineNumber);
                    String file = this.m_fileHash.get(fileID);
                    int dr = this.m_duplicateTable.row_increment();
                    this.m_duplicateTable.putInt(dr, indexLine, line);
                    this.m_duplicateTable.putInt(dr, indexPoint, point);
                    this.m_duplicateTable.putInt(dr, indexIndex, index);
                    this.m_duplicateTable.putString(dr, indexFile1, file);
                    this.m_duplicateTable.putInt(dr, indexLine1, lineNumber);
                    this.m_duplicateTable.putString(dr, indexFile2, otherFile);
                    this.m_duplicateTable.putInt(dr, indexLine2, otherLineNumber);
                    continue;
                }
                this.m_hashLPI.put(new Integer(row), line, point, index);
            }
            int numShotsNotFound = 0;
            int indexFFID = this.m_relationTable.column_indexOfColumn("FFID");
            for (int row = 0; row < this.m_relationTable.row_count(); ++row) {
                int ffid = this.m_relationTable.getInt(row, indexFFID);
                if (!this.m_ffidHash.containsKey(ffid)) {
                    FFIDENTRY entry = new FFIDENTRY(ffid);
                    this.m_ffidHash.put(entry, ffid);
                }
                int line = 0;
                int point = this.m_relationTable.getInt(row, this.m_index_Point_Rel);
                int index = 0;
                if (this.m_index_Index_Rel >= 0) {
                    index = this.m_relationTable.getInt(row, this.m_index_Index_Rel);
                }
                if (this.m_index_Line_Rel >= 0) {
                    line = this.m_relationTable.getInt(row, this.m_index_Line_Rel);
                }
                if (this.m_hashLPI.containsKey(line, point, index)) {
                    FFIDENTRY entry = this.m_ffidHash.get(ffid);
                    entry.RelationRow.add(row);
                    entry.ShotRow = this.m_hashLPI.get(line, point, index);
                    continue;
                }
                ++numShotsNotFound;
            }
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class FFIDENTRY {
        public int FFID;
        public ArrayList<Integer> RelationRow = new ArrayList();
        public int ShotRow = 0;

        public FFIDENTRY(int ffid) {
            this.FFID = ffid;
        }
    }
}

