/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.AppType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.SyntheticLayerGenerator;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_SyntheticResidualStatics
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget = null;
    protected RadioPanel m_radEventType;
    protected JTextField m_txtSouthTime;
    protected JTextField m_txtNorthTime;
    protected JTextField m_txtEastTime;
    protected JTextField m_txtWestTime;
    protected JTextField m_txtTransitionPercent;
    protected JTextField m_txtTotalTime;
    protected JTextField m_txtTime;
    protected ComboStringListWrapper m_combo;
    protected ComboStringListWrapper m_comboNoise;
    protected JTextField m_txtRnmoOffset;
    protected JTextField m_txtRnmoTime;
    protected Range_Double m_rangeY = null;
    protected Range_Double m_rangeX = null;
    protected SyntheticLayerGenerator m_gen = new SyntheticLayerGenerator();

    public EnsembleWorker_SyntheticResidualStatics() {
        try {
            this.Abbreviation = "SynResStat";
            this.ShortDescription = "Synthetic Residual Statics";
            this.WorkerType = "Synthetic";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_SyntheticResidualStatics";
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadCombo();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.getAll(true);
            String column = this.m_combo.getSelectedString();
            String columnNoise = this.m_comboNoise.getSelectedString();
            int eventType = this.m_radEventType.getSelectedIndex();
            this.m_txtSouthTime.setEnabled(eventType == 1);
            this.m_txtNorthTime.setEnabled(eventType == 1);
            this.m_txtWestTime.setEnabled(eventType == 2);
            this.m_txtEastTime.setEnabled(eventType == 2);
            this.m_txtTransitionPercent.setEnabled(eventType == 1 || eventType == 2);
            this.m_txtTime.setEnabled(eventType == 0);
            this.m_parameterTree.string_put("Column", column);
            this.m_parameterTree.string_put("NoiseColumn", columnNoise);
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadCombo() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_mainWidget == null) {
                return;
            }
            ArrayList<String> intersection = null;
            if (AppType.isRefraction()) {
                intersection = Tools_RefractionStaticsProject.getColumnList_Intersection("STATICS_");
            }
            Collections.sort(intersection);
            this.m_combo.setStringArray(intersection);
            intersection = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_comboNoise.setStringArray(intersection);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            String column = this.m_combo.getSelectedString();
            String columnNoise = this.m_comboNoise.getSelectedString();
            this.m_parameterTree.int_put("EventType", this.m_radEventType.getSelectedIndex());
            this.m_parameterTree.string_put("Column", column);
            this.m_parameterTree.string_put("NoiseColumn", columnNoise);
            this.m_parameterTree.double_put("EastTime", Tools_Widget.extractDouble(this.m_txtEastTime, 500.0, 200.0, 1000.0));
            this.m_parameterTree.double_put("WestTime", Tools_Widget.extractDouble(this.m_txtWestTime, 500.0, 200.0, 3000.0));
            this.m_parameterTree.double_put("SouthTime", Tools_Widget.extractDouble(this.m_txtSouthTime, 500.0, 200.0, 1000.0));
            this.m_parameterTree.double_put("NorthTime", Tools_Widget.extractDouble(this.m_txtNorthTime, 500.0, 200.0, 3000.0));
            this.m_parameterTree.double_put("TransitionPercent", Tools_Widget.extractDouble(this.m_txtTransitionPercent, 50.0, 5.0, 90.0));
            this.m_parameterTree.double_put("Time", Tools_Widget.extractDouble(this.m_txtTime, 500.0, 200.0, 1000.0));
            this.m_parameterTree.double_put("TotalTime", Tools_Widget.extractDouble(this.m_txtTotalTime, 1000.0, 1000.0, 3000.0));
            this.m_parameterTree.double_put("RnmoOffset", Tools_Widget.extractDouble(this.m_txtRnmoOffset, 5000.0, 1000.0, 30000.0));
            this.m_parameterTree.double_put("RnmoTime", Tools_Widget.extractDouble(this.m_txtRnmoTime, 10.0, 0.0, 100.0));
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                double totalTime = this.m_parameterTree.double_get("TotalTime", 1000.0);
                this.m_txtTotalTime = new JTextField(Double.toString(totalTime));
                this.m_txtTotalTime.addActionListener(this);
                this.m_mainWidget.addHorzPair(new JLabel("Trace length (ms)"), 0, this.m_txtTotalTime, 10);
                int eventType = this.m_parameterTree.int_get("EventType", 0);
                this.m_radEventType = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Event", "Fixed time", "North/south variation", "East/west variation");
                this.m_radEventType.setSelectedIndex(eventType);
                this.m_mainWidget.addComponent(this.m_radEventType, 0);
                this.m_radEventType.listener().addListener(this);
                eventType = this.m_radEventType.getSelectedIndex();
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(0, 0);
                int row = 0;
                double time = this.m_parameterTree.double_get("SouthTime", 500.0);
                this.m_txtSouthTime = new JTextField(Double.toString(time));
                this.m_txtSouthTime.addActionListener(this);
                this.m_txtSouthTime.setEnabled(eventType == 1);
                time = this.m_parameterTree.double_get("NorthTime", 500.0);
                this.m_txtNorthTime = new JTextField(Double.toString(time));
                this.m_txtNorthTime.addActionListener(this);
                this.m_txtNorthTime.setEnabled(eventType == 1);
                time = this.m_parameterTree.double_get("WestTime", 500.0);
                this.m_txtWestTime = new JTextField(Double.toString(time));
                this.m_txtWestTime.addActionListener(this);
                this.m_txtWestTime.setEnabled(eventType == 2);
                time = this.m_parameterTree.double_get("EastTime", 500.0);
                this.m_txtEastTime = new JTextField(Double.toString(time));
                this.m_txtEastTime.addActionListener(this);
                this.m_txtEastTime.setEnabled(eventType == 2);
                double percent = this.m_parameterTree.double_get("TransitionPercent", 50.0);
                this.m_txtTransitionPercent = new JTextField(Double.toString(percent));
                this.m_txtTransitionPercent.addActionListener(this);
                this.m_txtTransitionPercent.setEnabled(eventType == 1 || eventType == 2);
                grid.addSimple(row++, new JLabel("Southern time"), this.m_txtSouthTime);
                grid.addSimple(row++, new JLabel("Northern time"), this.m_txtNorthTime);
                grid.addSimple(row++, new JLabel("Western time"), this.m_txtWestTime);
                grid.addSimple(row++, new JLabel("Eastern time"), this.m_txtEastTime);
                grid.addSimple(row++, new JLabel("Transition zone percent"), this.m_txtTransitionPercent);
                time = this.m_parameterTree.double_get("Time", 500.0);
                this.m_txtTime = new JTextField(Double.toString(time));
                this.m_txtTime.addActionListener(this);
                this.m_txtTime.setEnabled(eventType == 0);
                grid.addSimple(row++, new JLabel("Fixed event time"), this.m_txtTime);
                String column = this.m_parameterTree.string_get("Column", "NotSet");
                String columnNoise = this.m_parameterTree.string_get("NoiseColumn", "NotSet");
                this.m_combo = new ComboStringListWrapper();
                this.m_combo.listener().addListener(this);
                this.m_combo.setPreferredSelected(column);
                this.m_comboNoise = new ComboStringListWrapper();
                this.m_comboNoise.listener().addListener(this);
                this.m_comboNoise.setPreferredSelected(columnNoise);
                grid.addSimple(row++, new JLabel("Statics column"), this.m_combo);
                grid.addSimple(row++, new JLabel("Noise column"), this.m_comboNoise);
                double RnmoOffset = this.m_parameterTree.double_get("RnmoOffset", 5000.0);
                double RnmoTime = this.m_parameterTree.double_get("RnmoTime", 0.0);
                this.m_txtRnmoOffset = new JTextField(Double.toString(RnmoOffset));
                this.m_txtRnmoTime = new JTextField(Double.toString(RnmoTime));
                this.m_txtRnmoOffset.addActionListener(this);
                this.m_txtRnmoTime.addActionListener(this);
                grid.addSimple(row++, new JLabel("RNMO offset"), this.m_txtRnmoOffset);
                grid.addSimple(row++, new JLabel("RNMO time at offset"), this.m_txtRnmoTime);
                this.reloadCombo();
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
                Messenger.singleton().addListener(this);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (ensemble.traceCount() < 1) {
                return;
            }
            this.getAll(false);
            if (this.m_rangeY == null) {
                this.m_rangeY = Tools_RefractionStaticsProject.getRange("Northing", true, true);
            }
            if (this.m_rangeX == null) {
                this.m_rangeX = Tools_RefractionStaticsProject.getRange("Easting", true, true);
            }
            int eventType = this.m_parameterTree.int_get("EventType", 0);
            double eastTime = this.m_parameterTree.double_get("EastTime", 500.0);
            double westTime = this.m_parameterTree.double_get("WestTime", 500.0);
            double southTime = this.m_parameterTree.double_get("SouthTime", 500.0);
            double northTime = this.m_parameterTree.double_get("NorthTime", 500.0);
            double percent = this.m_parameterTree.double_get("TransitionPercent", 50.0);
            double fraction = Math.max(0.1, percent * 0.01);
            fraction = Math.min(fraction, 0.9);
            double totalRange = this.m_rangeY.range();
            double transition = fraction * totalRange;
            double edge = (totalRange - transition) / 2.0;
            double southern = this.m_rangeY.rangeMin() + edge;
            double northern = this.m_rangeY.rangeMax() - edge;
            double alpha = (northTime - southTime) / (northern - southern);
            double beta = southTime - alpha * southern;
            double western = 0.0;
            double eastern = 0.0;
            if (eventType == 2) {
                totalRange = this.m_rangeX.range();
                transition = fraction * totalRange;
                edge = (totalRange - transition) / 2.0;
                western = this.m_rangeX.rangeMin() + edge;
                eastern = this.m_rangeX.rangeMax() - edge;
                alpha = (eastTime - westTime) / (eastern - western);
                beta = westTime - alpha * western;
            }
            int indexCdpX = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "MidX");
            int indexCdpY = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "MidY");
            int indexShotX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double sy = trace.header().getDouble(indexShotY);
                double ry = trace.header().getDouble(indexRecY);
                double y = 0.5 * (sy + ry);
                trace.header().putDouble(indexCdpY, y);
                double sx = trace.header().getDouble(indexShotX);
                double rx = trace.header().getDouble(indexRecX);
                double x = 0.5 * (sx + rx);
                trace.header().putDouble(indexCdpX, x);
            }
            double totalTime = this.m_parameterTree.double_get("TotalTime", 1000.0);
            double center = this.m_parameterTree.double_get("Time", 500.0);
            double digi = 4.0;
            int numSamples = (int)(0.5 + totalTime / digi);
            double RnmoOffset = this.m_parameterTree.double_get("RnmoOffset", 5000.0);
            double RnmoTime = this.m_parameterTree.double_get("RnmoTime", 0.0);
            double fac = RnmoTime / (RnmoOffset * RnmoOffset);
            String column = this.m_parameterTree.string_get("Column", "");
            String columnNoise = this.m_parameterTree.string_get("NoiseColumn", "NotSet");
            float[] data = new float[numSamples];
            int indexRec = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", column);
            int indexSht = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", column);
            int indexNoiseRec = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", columnNoise);
            int indexNoiseSht = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", columnNoise);
            int indexOff = this.m_inputEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double shiftRec = trace.header().getDouble(indexRec);
                double shiftShot = trace.header().getDouble(indexSht);
                double noiseShot = trace.header().getDouble(indexNoiseSht);
                double noiseRec = trace.header().getDouble(indexNoiseRec);
                double off = trace.header().getDouble(indexOff);
                double rnmo = fac * off * off;
                if (eventType == 2) {
                    double x = trace.header().getDouble(indexCdpX);
                    if (x <= western) {
                        center = westTime;
                    }
                    if (x >= eastern) {
                        center = eastTime;
                    }
                    if (x >= western && x <= eastern) {
                        center = alpha * x + beta;
                    }
                }
                if (eventType == 1) {
                    double y = trace.header().getDouble(indexCdpY);
                    if (y <= southern) {
                        center = southTime;
                    }
                    if (y >= northern) {
                        center = northTime;
                    }
                    if (y >= southern && y <= northern) {
                        center = alpha * y + beta;
                    }
                }
                for (int s = 0; s < numSamples; ++s) {
                    data[s] = 0.0f;
                    double mid = center + shiftRec + shiftShot + rnmo;
                    float dt = (float)Math.abs(0.001 * mid - (double)s * 0.001 * digi);
                    float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                    float noise = (float)(noiseShot + noiseRec);
                    float rand = noise * 2.0f * (0.5f - (float)Math.random());
                    data[s] = data[s] + 100.0f * (exp + rand);
                }
                trace.data().insertArray(data, numSamples);
                trace.data().setFirstSampleCoord(0.0f);
                trace.data().setSampleInterval((float)digi);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

