/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.SyntheticLayerGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnsembleWorker_SyntheticLayers
extends EnsembleWorker_Base
implements ActionListener,
DocumentListener {
    protected Ensemble m_inputEnsemble = null;
    protected boolean m_dirty = true;
    protected ArrayList<Layer> m_list = new ArrayList();
    protected LinearLayoutWidget m_mainWidget = null;
    protected ArrayList<JTextField> m_listVel;
    protected ArrayList<JTextField> m_listThick;
    protected JTextField m_txtTime;
    protected static final int Count = 10;
    protected SyntheticLayerGenerator m_gen = new SyntheticLayerGenerator();

    protected void createLayers() {
        try {
            int n;
            this.m_dirty = false;
            this.m_list.clear();
            double[] v = new double[10];
            double[] thick = new double[10];
            for (n = 0; n < 10; ++n) {
                v[n] = this.m_parameterTree.double_get("V" + Integer.toString(n), 5000 + 500 * n);
                thick[n] = this.m_parameterTree.double_get("T" + Integer.toString(n), 1000.0);
            }
            for (n = 0; n < 10; ++n) {
                this.m_list.add(new Layer(n, v, thick));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.getAll(false);
        this.m_dirty = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.getAll(false);
        this.m_dirty = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.getAll(false);
        this.m_dirty = true;
    }

    public EnsembleWorker_SyntheticLayers() {
        try {
            this.m_dirty = true;
            this.Abbreviation = "SYNLYR";
            this.ShortDescription = "Layered model";
            this.WorkerType = "Synthetic";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_SyntheticLayers";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Time", Tools_Widget.extractDouble(this.m_txtTime, 3000.0, 1000.0, 6000.0));
            double priorVel = 500.0;
            for (int n = 0; n < 10; ++n) {
                double vel = Tools_Widget.extractDouble(this.m_listVel.get(n), priorVel + 100.0, priorVel + 10.0, priorVel + 5000.0);
                double thick = Tools_Widget.extractDouble(this.m_listThick.get(n), 200.0, 100.0, 5000.0);
                this.m_parameterTree.double_put("V" + Integer.toString(n), vel);
                this.m_parameterTree.double_put("T" + Integer.toString(n), thick);
                priorVel = vel;
            }
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                double time = this.m_parameterTree.double_get("Time", 3000.0);
                this.m_txtTime = new JTextField(Double.toString(time));
                this.m_txtTime.addActionListener(this);
                this.m_mainWidget.addHorzPair(new JLabel("Trace length (ms)"), 0, this.m_txtTime, 10);
                this.m_listVel = new ArrayList();
                this.m_listThick = new ArrayList();
                for (int n = 0; n < 10; ++n) {
                    double v = this.m_parameterTree.double_get("V" + Integer.toString(n), 5000 + 500 * n);
                    double t = this.m_parameterTree.double_get("T" + Integer.toString(n), 1000.0);
                    this.m_listVel.add(new JTextField(Double.toString(v)));
                    this.m_listThick.add(new JTextField(Double.toString(t)));
                }
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(0, null, 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Interval velocity"), new JLabel("Thickness"));
                for (int n = 0; n < 10; ++n) {
                    this.m_listVel.get(n).addActionListener(this);
                    this.m_listThick.get(n).addActionListener(this);
                    this.m_listVel.get(n).getDocument().addDocumentListener(this);
                    this.m_listThick.get(n).getDocument().addDocumentListener(this);
                    grid.addSimple(row++, this.m_listVel.get(n), this.m_listThick.get(n));
                }
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.m_dirty) {
                this.createLayers();
            }
            if (ensemble.traceCount() < 1) {
                return;
            }
            this.getAll(false);
            double time = this.m_parameterTree.double_get("Time", 3000.0);
            double digi = 4.0;
            int numSamples = (int)(0.5 + time / digi);
            float[] data = new float[numSamples];
            Random rand = new Random();
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexAzimuth = ensemble.dictionary().getEntryIndex("Trace", "Azimuth");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                for (int s = 0; s < numSamples; ++s) {
                    data[s] = 0.4f * (0.5f - (float)rand.nextDouble());
                }
                EnsembleTrace trace = ensemble.trace(n);
                double offset = trace.header().getDouble(indexOffset);
                double azimuth = trace.header().getDouble(indexAzimuth);
                for (int r = 0; r < this.m_list.size(); ++r) {
                    Layer layer = this.m_list.get(r);
                    double t0 = layer.getTime(offset);
                    for (int s = 0; s < numSamples; ++s) {
                        float dt = (float)Math.abs(t0 - (double)s * 0.001 * digi);
                        float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                        data[s] = data[s] + 5.0f * exp;
                    }
                }
                trace.data().insertArray(data, numSamples);
                trace.data().setSampleInterval((float)digi);
                trace.data().setFirstSampleCoord(0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    protected class Layer {
        public double[] Offset;
        public double[] Time;
        public int MaxValidIndex;

        public Layer(int index, double[] v, double[] thick) {
            try {
                int count = 500;
                this.Offset = new double[count];
                this.Time = new double[count];
                double maxAngle = 1.4922565104551517;
                for (int n = 0; n < count; ++n) {
                    double angle = (double)n * maxAngle / (double)(count - 1);
                    double sumtime = 0.0;
                    double sumx = 0.0;
                    double fac = Math.sin(angle) / v[index];
                    for (int i = index; i >= 0; --i) {
                        double sinangle = v[i] * fac;
                        double layerangle = Math.asin(sinangle);
                        double x = thick[i] * Math.tan(layerangle);
                        double rad = Math.sqrt(x * x + thick[i] * thick[i]);
                        sumtime += 2.0 * rad / v[i];
                        sumx += 2.0 * x;
                    }
                    this.Offset[n] = sumx;
                    this.Time[n] = sumtime;
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }

        public double getTime(double offset) {
            try {
                for (int n = 1; n < this.Time.length; ++n) {
                    if (!(offset < this.Offset[n])) continue;
                    double alpha = (this.Time[n] - this.Time[n - 1]) / (this.Offset[n] - this.Offset[n - 1]);
                    double beta = this.Time[n] - alpha * this.Offset[n];
                    return alpha * offset + beta;
                }
                return this.Time[this.Time.length - 1];
            }
            catch (Exception error) {
                error.printStackTrace();
                return this.Time[0];
            }
        }
    }
}

