/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_SimpleSynthetic
extends EnsembleWorker_Base
implements ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget = null;
    protected JTextField m_txtLineLength;
    protected JTextField m_txtElevation;
    protected JTextField m_txtV0;
    protected JTextField m_txtV1;

    public EnsembleWorker_SimpleSynthetic() {
        try {
            this.Abbreviation = "SYN2D";
            this.ShortDescription = "Synthetic";
            this.WorkerType = "Synthetic";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = false;
            this.EnsembleSource = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_SimpleSynthetic";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Elevation", Tools_Widget.extractDouble(this.m_txtElevation, 50.0, -9000.0, 9000.0));
            this.m_parameterTree.double_put("V0", Tools_Widget.extractDouble(this.m_txtV0, 2500.0, 600.0, 9000.0));
            this.m_parameterTree.double_put("V1", Tools_Widget.extractDouble(this.m_txtV1, 6000.0, 1000.0, 25000.0));
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                double v0 = this.m_parameterTree.double_get("V0", 2400.0);
                double v1 = this.m_parameterTree.double_get("V1", 6000.0);
                double z = this.m_parameterTree.double_get("Elevation", 0.0);
                this.m_txtElevation = new JTextField(Double.toString(z));
                this.m_txtV0 = new JTextField(Double.toString(v0));
                this.m_txtV1 = new JTextField(Double.toString(v1));
                this.m_txtElevation.addActionListener(this);
                this.m_txtV0.addActionListener(this);
                this.m_txtV1.addActionListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, "Survey description", 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Refractor elevation"), this.m_txtElevation);
                grid.addSimple(row++, new JLabel("V0"), this.m_txtV0);
                grid.addSimple(row++, new JLabel("V1"), this.m_txtV1);
                this.m_mainWidget.addStretch(10);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (ensemble.traceCount() < 1) {
                return;
            }
            this.getAll(false);
            double v0 = this.m_parameterTree.double_get("V0", 2400.0);
            double v1 = this.m_parameterTree.double_get("V1", 6000.0);
            double z1 = this.m_parameterTree.double_get("Elevation", 0.0);
            double fac = Math.sqrt(v1 * v1 - v0 * v0) / (v1 * v0);
            int indexShotZ = ensemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexRecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            float digi = 4.0f;
            int numSamp = 400;
            float[] data = new float[numSamp];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                double zs = trace.header().getDouble(indexShotZ);
                double zr = trace.header().getDouble(indexRecZ);
                double offset = trace.header().getDouble(indexOffset);
                double hs = Math.max(1.0, zs - z1);
                double hr = Math.max(1.0, zr - z1);
                double dts = hs * fac;
                double dtr = hr * fac;
                double direct = offset / v0;
                double refracted = offset / v1 + dts + dtr;
                for (int s = 0; s < numSamp; ++s) {
                    data[s] = 0.0f;
                    float dt = (float)Math.abs(direct - (double)s * 0.001 * (double)digi);
                    float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                    float v = 3.0f * exp;
                    data[s] = data[s] + v;
                    if (!(refracted < direct)) continue;
                    dt = (float)Math.abs(refracted - (double)s * 0.001 * (double)digi);
                    exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                    v = 3.0f * exp;
                    data[s] = data[s] + v;
                }
                trace.data().insertArray(data, numSamp);
                trace.data().setFirstSampleCoord(0.0f);
                trace.data().setSampleInterval(digi);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

