/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Stacks;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Worker.QC.EnsembleWorker_FourierPeakAnalysis;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.TableColumnSelectorWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EnsembleWorker_RecLineMixer
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
ItemListener,
GenericObjectListener.Listener {
    EnsembleWorker_FourierPeakAnalysis m_frequencySpike = new EnsembleWorker_FourierPeakAnalysis();
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected ArrayList<DataInfo> m_dataList = new ArrayList();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected JTabbedPane m_mainWidget;
    protected JTextField m_corrWindowText;
    protected JTextField m_corrMaxShiftText;
    protected JCheckBox m_applyCorrShifts;
    protected JComboBox<String> m_numTracesCombo;
    protected JCheckBox m_applyNoiseWeight;
    protected JTextField m_textNoiseWindow;
    protected JTextField m_textNoiseScalar;
    protected JCheckBox m_applyFreqSpikeWeight;
    protected float m_corrDigi = 4.0f;
    protected float m_corrWindow = 200.0f;
    protected float m_corrMaxShift = 60.0f;
    protected boolean m_corrApply = false;
    protected float[] m_tempTraceArray = new float[20];

    public EnsembleWorker_RecLineMixer() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "MIXER";
            this.ShortDescription = "Trace mixer";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_RecLineMixer";
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new JTabbedPane();
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                boolean projectOK = project.valid();
                LinearLayoutWidget page = LinearLayoutWidget.vert(0, null);
                TableColumnSelectorWidget grouper = new TableColumnSelectorWidget("Grouping header", 0, this.m_parameterTree, this, "GroupTable", "GroupColumn", "Receiver", "LineNumber");
                page.addComponent(grouper, 0);
                TableColumnSelectorWidget sorter = new TableColumnSelectorWidget("Sorting header", 0, this.m_parameterTree, this, "SortTable", "SortColumn", "Receiver", "PointNumber");
                page.addComponent(sorter, 0);
                LinearLayoutWidget sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Number of traces to mix", 0);
                int numTraces = this.m_parameterTree.int_get("NumTraces", 3);
                int index = numTraces / 2 - 1;
                this.m_numTracesCombo = new JComboBox();
                for (int n = 1; n < 11; ++n) {
                    String s1 = String.format("%d total traces ( +/- %d traces)", 1 + 2 * n, n);
                    this.m_numTracesCombo.addItem(s1);
                }
                this.m_numTracesCombo.setSelectedIndex(index);
                this.m_numTracesCombo.addItemListener(this);
                sub.addComponent(this.m_numTracesCombo, 0);
                page.addStretch(10);
                this.m_mainWidget.addTab("Trace count", page);
                page = LinearLayoutWidget.vert(0, null);
                sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Noisy trace suppression", 0);
                double scalar = this.m_parameterTree.double_get("NoiseScalar", 0.03);
                scalar = Math.max(0.01, scalar);
                scalar = Math.min(1.0, scalar);
                this.m_textNoiseScalar = new JTextField(Double.toString(scalar));
                this.m_textNoiseScalar.addActionListener(this);
                int noiseWindow = this.m_parameterTree.int_get("NoiseWindow", 20);
                noiseWindow = Math.max(5, noiseWindow);
                noiseWindow = Math.min(500, noiseWindow);
                this.m_textNoiseWindow = new JTextField(Integer.toString(noiseWindow));
                this.m_textNoiseWindow.addActionListener(this);
                this.m_applyNoiseWeight = new JCheckBox("Weight traces uses noise measure");
                this.m_applyNoiseWeight.addActionListener(this);
                this.m_applyNoiseWeight.setSelected(this.m_parameterTree.bool_get("Noise", false));
                sub.addComponent(this.m_applyNoiseWeight, 0);
                sub.createGapLabel(10);
                sub.addComponent(new JLabel("Noise window (samples)"), 0);
                sub.addComponent(this.m_textNoiseWindow, 0);
                sub.createGapLabel(10);
                sub.addComponent(new JLabel("Noise scalar (0.01 < scalar <= 1.0)"), 0);
                sub.addComponent(this.m_textNoiseScalar, 0);
                sub = page.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Frequency spike suppression", 0);
                this.m_applyFreqSpikeWeight = new JCheckBox("Incorporate frequency spike suppression");
                this.m_applyFreqSpikeWeight.addActionListener(this);
                this.m_applyFreqSpikeWeight.setSelected(this.m_parameterTree.bool_get("FreqSpike", false));
                sub.addComponent(this.m_applyFreqSpikeWeight, 0);
                page.addStretch(10);
                this.m_mainWidget.addTab("Noise", page);
                double maxShift = this.m_parameterTree.double_get("MaxShift", 60.0);
                double corrWindow = this.m_parameterTree.double_get("CorrWindow", 300.0);
                this.m_corrMaxShiftText = new JTextField(Double.toString(maxShift));
                this.m_corrMaxShiftText.addActionListener(this);
                this.m_corrWindowText = new JTextField(Double.toString(corrWindow));
                this.m_corrWindowText.addActionListener(this);
                page = LinearLayoutWidget.vert(0, null);
                JLabel lbl = new JLabel("THIS OPTION REQUIRES MOVEOUT TRENDS");
                lbl.setForeground(Color.red);
                lbl.setBorder(BorderFactory.createRaisedBevelBorder());
                page.addComponent(lbl, 0);
                this.m_applyCorrShifts = new JCheckBox("Apply correlation shifts");
                this.m_applyCorrShifts.addActionListener(this);
                this.m_applyCorrShifts.setSelected(this.m_parameterTree.bool_get("ApplyCorr", false));
                page.addComponent(this.m_applyCorrShifts, 0);
                GridLayoutWidget grid = page.createGridLayoutWidget(3, 0);
                grid.addSimple(0, new JLabel("Correlation window (ms)"), this.m_corrWindowText);
                grid.addSimple(1, new JLabel("Maximum shift(ms)"), this.m_corrMaxShiftText);
                page.addStretch(10);
                this.m_mainWidget.addTab("Correlation", page);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            int numTraces = 3 + 2 * this.m_numTracesCombo.getSelectedIndex();
            this.m_parameterTree.int_put("NumTraces", numTraces);
            boolean applyNoise = this.m_applyNoiseWeight.isSelected();
            this.m_parameterTree.bool_put("Noise", applyNoise);
            double scalar = Tools_Widget.extractDouble(this.m_textNoiseScalar, 0.03, 0.01, 1.0);
            this.m_parameterTree.double_put("NoiseScalar", scalar);
            int window = Tools_Widget.extractInteger(this.m_textNoiseWindow, 20, 10, 1000);
            this.m_parameterTree.int_put("NoiseWindow", window);
            boolean applySpike = this.m_applyFreqSpikeWeight.isSelected();
            this.m_parameterTree.bool_put("FreqSpike", applySpike);
            double corrWindow = Tools_Widget.extractDouble(this.m_corrWindowText, 300.0, 50.0, 500.0);
            this.m_parameterTree.double_put("CorrWindow", corrWindow);
            double maxShift = Tools_Widget.extractDouble(this.m_corrMaxShiftText, 50.0, 20.0, 500.0);
            this.m_parameterTree.double_put("MaxShift", maxShift);
            this.m_parameterTree.bool_put("ApplyCorr", this.m_applyCorrShifts.isSelected());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName() {
        try {
            return "FBP_" + this.m_parameterTree.string_get("Name", "");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected float computeCorrelationShift(DataInfo main, DataInfo other) {
        try {
            if (!main.Interpolator.inputValid()) {
                return 0.0f;
            }
            if (!other.Interpolator.inputValid()) {
                return 0.0f;
            }
            float maxShift = 0.0f;
            float maxCorr = 0.0f;
            for (float shift = -this.m_corrMaxShift; shift <= this.m_corrMaxShift; shift += 1.0f) {
                float corr = 0.0f;
                for (float time = -this.m_corrWindow; time < this.m_corrWindow; time += 4.0f) {
                    float t1 = main.Interpolator.interpolate(time);
                    float t2 = other.Interpolator.interpolate(time + shift);
                    corr += t1 * t2;
                }
                if (!(corr > maxCorr)) continue;
                maxCorr = corr;
                maxShift = shift;
            }
            return maxShift;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected void computeCorrelationShifts(Ensemble ensemble) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                DataInfo dataInfo = this.m_dataList.get(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepDataList(Ensemble ensemble) {
        try {
            boolean applySpike = this.m_parameterTree.bool_get("FreqSpike", false);
            int indexSpike = -9999;
            if (applySpike) {
                this.m_frequencySpike.performWork(ensemble);
                indexSpike = ensemble.dictionary().getEntryIndex("Trace", "FrequencySpike");
            }
            boolean applyNoise = this.m_parameterTree.bool_get("Noise", false);
            double scalar = this.m_parameterTree.double_get("NoiseScalar", 0.03);
            scalar = Math.max(0.01, scalar);
            scalar = Math.min(1.0, scalar);
            int noiseWindow = this.m_parameterTree.int_get("NoiseWindow", 20);
            noiseWindow = Math.max(5, noiseWindow);
            noiseWindow = Math.min(500, noiseWindow);
            int corrWindow = 1 + 2 * (int)(this.m_corrWindow / this.m_corrDigi);
            while (this.m_dataList.size() < ensemble.traceCount()) {
                this.m_dataList.add(new DataInfo());
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int s;
                EnsembleTrace trace = ensemble.trace(n);
                DataInfo info = this.m_dataList.get(n);
                FloatArrayWrapper wrapper = trace.data();
                info.Valid = false;
                info.Digi = wrapper.getSampleInterval();
                info.Time0 = wrapper.getFirstSampleCoord_WithShifts();
                info.NoiseLevel = 1.0f;
                info.NoiseWeight = 1.0f;
                info.SpikeWeight = 1.0f;
                info.TotalWeight = 1.0f;
                if (info.Window == null) {
                    info.Window = new float[corrWindow];
                }
                if (info.Window.length != corrWindow) {
                    info.Window = new float[corrWindow];
                }
                if (wrapper.length() <= 10 || !trace.traceOkay()) continue;
                info.Valid = true;
                if (this.m_tempTraceArray.length <= wrapper.length()) {
                    this.m_tempTraceArray = new float[100 + wrapper.length()];
                }
                wrapper.copyToArray(this.m_tempTraceArray);
                info.NoiseLevel = 100.0f * this.m_renorm.computeNoiseLevel(this.m_tempTraceArray, noiseWindow);
                info.NoiseWeight = 100.0f / ((float)scalar + info.NoiseLevel);
                if (applySpike) {
                    float spike = trace.header().getFloat(indexSpike);
                    info.SpikeWeight = 1.0f / (1.0E-4f + spike * spike);
                    info.TotalWeight *= info.SpikeWeight;
                }
                if (applyNoise) {
                    info.TotalWeight *= info.NoiseWeight;
                }
                for (s = 0; s < this.m_tempTraceArray.length; ++s) {
                    this.m_tempTraceArray[s] = this.m_tempTraceArray[s] * info.TotalWeight;
                }
                info.Interpolator.prepareInput(this.m_tempTraceArray, info.Time0, info.Digi);
                for (s = 0; s < corrWindow; ++s) {
                    float t = -this.m_corrWindow + (float)s * this.m_corrDigi;
                    info.Window[s] = info.Interpolator.interpolate(t);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void makeStacks(Ensemble ensemble) {
        try {
            int numTraces = this.m_parameterTree.int_get("NumTraces", 3);
            int rad = numTraces / 2;
            rad = Math.max(1, rad);
            rad = Math.min(10, rad);
            float[] sum = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                DataInfo infoMain = this.m_dataList.get(n);
                FloatArrayWrapper wrapper = ensemble.trace(n).data();
                if (!infoMain.Interpolator.inputValid() || wrapper.length() <= 10) continue;
                if (sum.length != wrapper.length()) {
                    sum = new float[wrapper.length()];
                }
                for (int s = 0; s < sum.length; ++s) {
                    sum[s] = 0.0f;
                }
                float t0 = wrapper.getFirstSampleCoord_WithShifts();
                float digi = wrapper.getSampleInterval();
                int numAdded = 0;
                for (int k = n - rad; k <= n + rad; ++k) {
                    if (k < 0 || k >= ensemble.traceCount()) continue;
                    DataInfo info = this.m_dataList.get(k);
                    if (!info.Valid || !info.Interpolator.inputValid()) continue;
                    ++numAdded;
                    float corrShift = 0.0f;
                    if (this.m_corrApply) {
                        corrShift = this.computeCorrelationShift(infoMain, info);
                    }
                    float outputTime = t0;
                    for (int s = 0; s < sum.length; ++s) {
                        float inputSample = info.Interpolator.interpolate(outputTime + corrShift);
                        sum[s] = sum[s] + inputSample;
                        outputTime += digi;
                    }
                }
                if (numAdded < 2) continue;
                float inv = 1.0f / (float)numAdded;
                for (int s = 0; s < sum.length; ++s) {
                    sum[s] = sum[s] * inv;
                }
                wrapper.insertArray(sum, sum.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int numTraces = this.m_parameterTree.int_get("NumTraces", 3);
            this.m_corrApply = this.m_parameterTree.bool_get("ApplyCorr", false);
            this.m_corrWindow = (float)this.m_parameterTree.double_get("CorrWindow", 300.0);
            this.m_corrMaxShift = (float)this.m_parameterTree.double_get("MaxShift", 50.0);
            String sort_table = this.m_parameterTree.string_get("SortTable", "Receiver");
            String sort_col = this.m_parameterTree.string_get("SortColumn", "PointNumber");
            String grp_table = this.m_parameterTree.string_get("GroupTable", "Receiver");
            String grp_col = this.m_parameterTree.string_get("GroupColumn", "LineNumber");
            EnsembleGroupManager egm = new EnsembleGroupManager();
            egm.setParentEnsemble(this.m_inputEnsemble);
            egm.prepareGroupsBasedOnInteger(grp_table, grp_col);
            for (int group = 0; group < egm.GroupList.size(); ++group) {
                Ensemble subEnsemble = egm.GroupList.get((int)group).GroupEnsemble;
                subEnsemble.sortInt(0, sort_table, sort_col, "Receiver", "PointIndex");
                if (subEnsemble.traceCount() < 5) continue;
                this.prepDataList(subEnsemble);
                this.makeStacks(subEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    protected class DataInfo {
        public boolean Valid = false;
        public float Digi;
        public float Time0;
        public float NoiseLevel;
        public float NoiseWeight;
        public float SpikeWeight = 1.0f;
        public float TotalWeight = 1.0f;
        public CubicTraceInterpolator Interpolator = new CubicTraceInterpolator();
        public float[] Window;

        protected DataInfo() {
        }
    }
}

