/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Selectors;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_RangeTraceSelector
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_txtTable;
    protected JTextField m_txtColumn;
    protected JTextField m_txtMin;
    protected JTextField m_txtMax;

    public EnsembleWorker_RangeTraceSelector() {
        try {
            this.Abbreviation = "TSBHV";
            this.ShortDescription = "Trace selector: floating point range";
            this.WorkerType = "Trace selection";
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_RangeTraceSelector";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            double min = Tools_Widget.extractDouble(this.m_txtMin, 0.0, -1.0E20, 1.0E20);
            double max = Tools_Widget.extractDouble(this.m_txtMax, 0.0, -1.0E20, 1.0E20);
            this.m_parameterTree.string_put("Table", this.m_txtTable.getText());
            this.m_parameterTree.string_put("Column", this.m_txtColumn.getText());
            this.m_parameterTree.double_put("Minimum", min);
            this.m_parameterTree.double_put("Maximum", max);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String table = this.m_parameterTree.string_get("Table", "");
                String col = this.m_parameterTree.string_get("Column", "");
                double min = this.m_parameterTree.double_get("Minimum", 0.0);
                double max = this.m_parameterTree.double_get("Maximum", 1000.0);
                boolean removeValue = this.m_parameterTree.bool_get("Value", true);
                this.m_txtTable = new JTextField(table);
                this.m_txtColumn = new JTextField(col);
                this.m_txtTable.addActionListener(this);
                this.m_txtColumn.addActionListener(this);
                this.m_txtMin = new JTextField(Double.toString(min));
                this.m_txtMax = new JTextField(Double.toString(max));
                this.m_txtMin.addActionListener(this);
                this.m_txtMax.addActionListener(this);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                grid.addSimple(0, new JLabel("Table:"), this.m_txtTable);
                grid.addSimple(1, new JLabel("Column:"), this.m_txtColumn);
                grid.addSimple(2, new JLabel("Minimum value:"), this.m_txtMin);
                grid.addSimple(3, new JLabel("Maximum value:"), this.m_txtMax);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            String table = this.m_parameterTree.string_get("Table", "");
            String col = this.m_parameterTree.string_get("Column", "");
            double min = this.m_parameterTree.double_get("Minimum", 0.0);
            double max = this.m_parameterTree.double_get("Maximum", 1000.0);
            boolean removeValue = this.m_parameterTree.bool_get("Value", true);
            if (!this.m_inputEnsemble.dictionary().containsEntry(table, col)) {
                this.Success = false;
                this.Reason = "Header not present";
                return;
            }
            int index = this.m_inputEnsemble.dictionary().getEntryIndex(table, col);
            for (int n = this.m_inputEnsemble.traceCount() - 1; n >= 0; --n) {
                double v = this.m_inputEnsemble.trace(n).header().getDouble(index);
                if (!(v < min) && !(v > max)) continue;
                this.m_inputEnsemble.removeTrace(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

