/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Selectors;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;

public class EnsembleWorker_AzimuthSelector
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
IParameterWidgetListener,
ItemListener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_angleEditor;
    protected SliderWidget m_widthEditor;
    protected AzimuthSelector m_inputAzimuthSelector = new AzimuthSelector();

    public EnsembleWorker_AzimuthSelector() {
        try {
            this.Abbreviation = "Azimuth limits";
            this.ShortDescription = "Azimuth limits";
            this.WorkerType = "Trace selection";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_AzimuthSelector";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.double_put("Angle", this.m_angleEditor.getDoubleValue());
            this.m_parameterTree.double_put("Width", this.m_widthEditor.getDoubleValue());
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double angle = this.m_parameterTree.double_get("Angle", 0.0);
                double width = this.m_parameterTree.double_get("Width", 45.0);
                this.m_angleEditor = new SliderWidget(this, null, "Center azimuth, degrees", 0, angle, 0.0, 360.0);
                this.m_angleEditor.setRangeLocked(false);
                this.m_widthEditor = new SliderWidget(this, null, "Center azimuth, degrees", 0, width, 0.0, 180.0);
                this.m_widthEditor.setRangeLocked(true);
                this.m_mainWidget.addComponent(this.m_angleEditor, 0);
                this.m_mainWidget.addComponent(this.m_widthEditor, 0);
                this.m_mainWidget.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this.m_mainWidget, -2, null, true);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double angle = Math.PI * this.m_parameterTree.double_get("Angle", 0.0) / 180.0;
            double width = Math.PI * this.m_parameterTree.double_get("Width", 45.0) / 180.0;
            this.m_inputAzimuthSelector.setLimits(angle, width, true);
            this.m_inputEnsemble.filterAzimuth(this.m_inputAzimuthSelector);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

