/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.QC;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EnsembleWorker_NoiseTrace
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowEditor;
    protected JCheckBox m_killCheck;
    protected JTextField m_killLevelText;
    protected JCheckBox m_killCheckDC;
    protected JTextField m_killWindowTextDC;
    protected Tools_Ensemble m_tools = new Tools_Ensemble();

    public EnsembleWorker_NoiseTrace() {
        try {
            this.Abbreviation = "NOISE";
            this.ShortDescription = "Trace noise level measure";
            this.WorkerType = "Trace noise measurement";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_NoiseTrace";
    }

    protected void getAll(boolean broadcast) {
        try {
            this.m_parameterTree.double_put("Window", this.m_windowEditor.getDoubleValue());
            double cutoff = Tools_Widget.extractDouble(this.m_killLevelText, 10.0, 0.01, 100.0);
            this.m_parameterTree.double_put("CutOff", cutoff);
            this.m_parameterTree.bool_put("Kill", this.m_killCheck.isSelected());
            this.m_parameterTree.bool_put("KillDC", this.m_killCheckDC.isSelected());
            double windowDC = Tools_Widget.extractDouble(this.m_killWindowTextDC, 100.0, 10.0, 3000.0);
            this.m_parameterTree.double_put("WindowDC", windowDC);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double window = this.m_parameterTree.double_get("Window", 100.0);
                this.m_windowEditor = new SliderWidget(this, null, "Window length, milliseconds", 0, window, 12.0, 2000.0);
                this.m_windowEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowEditor, -1, null, true);
                this.m_mainWidget.addComponent(this.m_windowEditor, 0);
                LinearLayoutWidget sub = this.m_mainWidget.createVertical(0, "Kill traces above threshold", 0);
                boolean kill = this.m_parameterTree.bool_get("Kill", true);
                this.m_killCheck = new JCheckBox("Kill noisy traces");
                this.m_killCheck.setSelected(kill);
                this.m_killCheck.addActionListener(this);
                sub.addComponent(this.m_killCheck, 0);
                double cutoff = this.m_parameterTree.double_get("CutOff", 20.0);
                this.m_killLevelText = sub.createSubTextField("Cutoff (0 < cutoff < 100)", Double.toString(cutoff), this);
                LinearLayoutWidget subDC = this.m_mainWidget.createVertical(0, "Additional DC bias options", 0);
                boolean killDC = this.m_parameterTree.bool_get("KillDC", true);
                this.m_killCheckDC = new JCheckBox("Kill DC traces");
                this.m_killCheckDC.setSelected(killDC);
                this.m_killCheckDC.addActionListener(this);
                subDC.addComponent(this.m_killCheckDC, 0);
                double windowDC = this.m_parameterTree.double_get("WindowDC", 150.0);
                this.m_killWindowTextDC = subDC.createSubTextField("Max DC length (ms)", Double.toString(windowDC), this);
                this.m_killWindowTextDC.addActionListener(this);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setWindow(double window) {
        try {
            this.m_parameterTree.double_put("Window", window);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setCutoff(double cut) {
        try {
            this.m_parameterTree.double_put("CutOff", cut);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setKill(boolean kill) {
        try {
            this.m_parameterTree.bool_put("Kill", kill);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setKillDC(boolean kill) {
        try {
            this.m_parameterTree.bool_put("KillDC", kill);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double window = this.m_parameterTree.double_get("Window", 100.0);
            double cutoff = this.m_parameterTree.double_get("CutOff", 10.0);
            boolean killNoisy = this.m_parameterTree.bool_get("Kill", true);
            if (Math.abs(window) < 4.0) {
                this.Success = false;
                this.Reason = "Window too short";
                return;
            }
            int indexNoise = ensemble.dictionary().addEntry("Trace", "NoiseLevel", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(window / (double)data.getSampleInterval());
                float noise = 100.0f * this.m_renorm.computeNoiseLevel(this.m_tempArray, totalWindowLength);
                trace.header().putDouble(indexNoise, noise);
                trace.TooNoisy = false;
                if (!killNoisy || !((double)noise > cutoff)) continue;
                trace.TooNoisy = true;
            }
            double windowDC = this.m_parameterTree.double_get("WindowDC", 150.0);
            boolean killDC = this.m_parameterTree.bool_get("KillDC", true);
            this.m_tools.computeDCBias(ensemble, killDC, windowDC);
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                int indexKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    boolean killed = trace.header().getBool(indexKilled);
                    if (killNoisy) {
                        boolean bl = killed = killed || trace.TooNoisy;
                    }
                    if (killDC) {
                        killed = killed || trace.DC_Biased;
                    }
                    trace.header().putBool(indexKilled, killed);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

