/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Picker;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.TomoProfileV2_VNS;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_PredictTomoVNS
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JButton m_btnRun;
    protected JCheckBox m_chkResidual;
    protected int m_currentID = -9999;

    public EnsembleWorker_PredictTomoVNS() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "DT";
            this.ShortDescription = "Predict VNS tomography picks";
            this.WorkerType = "First break picking";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PredictTomoVNS";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.bool_put("Residual", this.m_chkResidual.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setResidual(boolean on) {
        try {
            if (this.m_chkResidual != null) {
                this.m_chkResidual.setSelected(on);
            }
            this.m_parameterTree.bool_put("Residual", on);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String s = "<HTML><font color=\"blue\">3D tomography models are created in a separate window! Select the top menu item Tomography, then select Eikonal 3D Tomography </font></HTML>";
                JLabel lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                this.m_btnRun = this.m_mainWidget.createButton("Apply", this, 0);
                this.m_chkResidual = new JCheckBox("Include residual error term");
                this.m_chkResidual.addActionListener(this);
                this.m_chkResidual.setSelected(this.m_parameterTree.bool_get("Residual", true));
                this.m_mainWidget.addComponent(this.m_chkResidual, 0);
                this.m_mainWidget.addStretch(10);
                Messenger.singleton().addListener(this);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble.traceCount() < 1) {
                return;
            }
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            Tomo_VNS tomo = RefractionStaticsProject.singleton().getTomo_VNS();
            boolean residual = this.m_parameterTree.bool_get("Residual", true);
            if (tomo == null) {
                this.Reason = "Tomo model not selected";
                this.Success = false;
                return;
            }
            int indexShotX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexShotZ = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexShotKilled = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexShotD = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", "PointDepth")) {
                indexShotD = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "PointDepth");
            }
            int indexShotID = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", "ShotID")) {
                indexShotID = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "ShotID");
            }
            int indexRecX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexRecZ = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Elevation");
            int indexRecKilled = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexRecD = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Receiver", "PointDepth")) {
                indexRecD = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "PointDepth");
            }
            int indexRecID = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Receiver", "ReceiverID")) {
                indexRecID = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            }
            int indexShift = this.m_inputEnsemble.dictionary().addEntry("Trace", "TomoTime", DataType.Double);
            int indexMaxDepth = this.m_inputEnsemble.dictionary().addEntry("Trace", "MaxRayDepth", DataType.Double);
            int indexPick = this.m_inputEnsemble.dictionary().addEntry("Trace", "FBP_PredTomoVNS", DataType.Double);
            int indexWaterTime = -9999;
            if (tomo.forceMarineSurvey()) {
                indexWaterTime = this.m_inputEnsemble.dictionary().addEntry("Trace", "WaterTravelTime", DataType.Double);
            }
            boolean numBad = false;
            TomoProfileV2_VNS profile = tomo.createNewProfileV2(3);
            double offsetCrossover = 2.5 * profile.SizeX;
            boolean crap = false;
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double sz = trace.header().getDouble(indexShotZ);
                double shotDepth = 0.0;
                if (indexShotD >= 0) {
                    shotDepth = trace.header().getDouble(indexShotD);
                }
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                double rz = trace.header().getDouble(indexRecZ);
                double recDepth = 0.0;
                if (indexRecD >= 0) {
                    recDepth = trace.header().getDouble(indexRecD);
                }
                double dx = rx - sx;
                double dy = ry - sy;
                double offset = Math.sqrt(1.0E-10 + dx * dx + dy * dy);
                boolean killed = trace.header().getBool(indexShotKilled) || trace.header().getBool(indexRecKilled);
                double travelTime = 0.0;
                double waterTime = 0.0;
                double maxDepth = 0.0;
                if (!killed) {
                    try {
                        if (offset < offsetCrossover) {
                            tomo.fireStraightLine(sx, sy, sz - shotDepth, rx, ry, rz - recDepth);
                            travelTime = tomo.StraightLineTotalTime;
                        } else {
                            if (offset < offsetCrossover + 200.0) {
                                crap = true;
                            }
                            tomo.populateProfileV2(profile, sx, sy, rx, ry, false);
                            profile.fireShot((float)(sz - shotDepth));
                            profile.setReceiver((float)(rz - recDepth), 0.0f);
                            travelTime = profile.ReceiverTime;
                            maxDepth = profile.MaxDepth;
                            waterTime = profile.WaterTravelTime;
                        }
                    }
                    catch (Exception exx) {
                        travelTime = 0.0;
                    }
                }
                if (residual && indexShotID >= 0 && indexRecID >= 0) {
                    Tomo_VNS.Element element;
                    int shotID = trace.header().getInt(indexShotID);
                    int recID = trace.header().getInt(indexRecID);
                    if (tomo.ReceiverHash.containsKey(recID)) {
                        element = tomo.ReceiverHash.get(recID);
                        travelTime -= (double)((float)element.Residual);
                    }
                    if (tomo.SourceHash.containsKey(shotID)) {
                        element = tomo.SourceHash.get(shotID);
                        travelTime -= (double)((float)element.Residual);
                    }
                }
                if (indexWaterTime >= 0) {
                    trace.header().putDouble(indexWaterTime, waterTime);
                }
                trace.header().putDouble(indexPick, travelTime);
                trace.header().putDouble(indexShift, travelTime);
                trace.header().putDouble(indexMaxDepth, maxDepth);
            }
            ensemble.pickPlotData().addRequiredPick("FBP_PredTomoVNS");
            ensemble.pickPlotData().add("FBP_PredTomoVNS", Color.blue, 9, Java2D_PointSymbol.X);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

