/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Output;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import javax.swing.JComponent;

public class EnsembleWorker_MergeTraceHeader
extends EnsembleWorker_Base {
    protected Ensemble m_inputEnsemble = null;

    public EnsembleWorker_MergeTraceHeader() {
        try {
            this.Abbreviation = "PFO";
            this.ShortDescription = "Write header values to trace table";
            this.WorkerType = "Output";
            this.RequiresRefractionStaticsProject = true;
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_MergeTraceHeader";
    }

    public void setColumnName(String column) {
        try {
            this.m_parameterTree.string_put("ColumnName", column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
    }

    @Override
    public boolean hasEditorWidget() {
        return false;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        return null;
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            if (ensemble == null) {
                return;
            }
            this.m_inputEnsemble = ensemble;
            String column = this.m_parameterTree.string_get("ColumnName", "");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            table.mergeHeaderValue(this.m_inputEnsemble, column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

