/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Moveout;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import javax.swing.JComponent;

public class EnsembleWorker_ApplySingleNMO
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editorVel;
    protected SliderWidget m_editorTime;

    public EnsembleWorker_ApplySingleNMO() {
        try {
            this.Abbreviation = "NMO";
            this.ShortDescription = "Single-velocity NMO";
            this.WorkerType = "Moveout";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ApplySingleNMO";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("NMO", this.m_editorVel.getDoubleValue());
            this.m_parameterTree.double_put("Time", this.m_editorTime.getDoubleValue());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double velocity = this.m_parameterTree.double_get("NMO", 2000.0);
                double time = this.m_parameterTree.double_get("Time", 2000.0);
                this.m_editorVel = new SliderWidget(this, null, "Normal moveout velocity", 0, velocity, 100.0, 30000.0);
                this.m_editorTime = new SliderWidget(this, null, "Zero-offset time (ms)", 0, time, 0.0, 10000.0);
                this.m_editorVel.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_editorVel, -1, null, true);
                Tools_FontChanger.changeSizeOfFont(this.m_editorTime, -1, null, true);
                this.m_mainWidget.addComponent(this.m_editorVel, 0);
                this.m_mainWidget.addComponent(this.m_editorTime, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double velocity = this.m_parameterTree.double_get("NMO", 0.0);
            double time = this.m_parameterTree.double_get("Time", 2000.0);
            if (Math.abs(velocity) < 0.001) {
                this.Success = false;
                this.Reason = "Velocity too small";
                return;
            }
            boolean ok = Tools_Ensemble.applyNormalMoveout(this.m_inputEnsemble, velocity, time);
            if (!ok) {
                this.Success = false;
                this.Reason = "Offset header value not valid";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

