/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.ModelTimeShifts;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.Eikonal2D.Eikonal2DModelV3;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_Eikonal2D
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected ComboStringListWrapper m_modelCombo;
    protected JButton m_btnReload;
    protected Eikonal2DModelV3 m_model;
    protected boolean m_ignoreModelCombo = true;
    protected int m_currentID = -9999;

    public EnsembleWorker_Eikonal2D() {
        try {
            this.RequiresShotOrderedData = true;
            this.Abbreviation = "DT";
            this.ShortDescription = "Apply 2D Eikonal tomography time shifts";
            this.WorkerType = "Model/analysis time shifts";
            this.InteractiveFlowsOkay = true;
            this.RequiresRefractionStaticsProject = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                String name = this.m_modelCombo.getSelectedString();
                this.m_parameterTree.string_put("Name", name);
                this.loadModel();
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_Eikonal2D";
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String path = p.getSubPath("Eikonal2D");
            ArrayList<String> models = Tools_FileSystem.subdirectories(path, false);
            this.m_modelCombo.setStringArray(models);
            String s = this.m_parameterTree.string_get("Name", "");
            if (s.length() > 1) {
                this.m_modelCombo.setPreferredSelected(s);
            }
            if (this.m_modelCombo.getItemCount() >= 1 && this.m_model == null) {
                String name = this.m_modelCombo.getSelectedString();
                this.m_parameterTree.string_put("Name", name);
                this.loadModel();
                this.broadcast(this, "Modified");
            }
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            this.m_model = null;
            this.m_currentID = -9999;
            String name = this.m_parameterTree.string_get("Name", "");
            if (name.length() < 1) {
                return;
            }
            this.m_model = new Eikonal2DModelV3(name);
            if (!this.m_model.valid()) {
                this.m_model = null;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.reloadModelCombo();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            if (this.m_modelCombo.getItemCount() < 1) {
                return;
            }
            String name = this.m_modelCombo.getSelectedString();
            this.m_parameterTree.string_put("Name", name);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                this.m_modelCombo = new ComboStringListWrapper();
                this.m_modelCombo.listener().addListener(this);
                String s = "<HTML><font color=\"red\">2D projects only! Eikonal models are created in a separate display </font></HTML>";
                JLabel lbl = new JLabel(s);
                this.m_mainWidget.addComponent(lbl, 0);
                this.m_mainWidget.createGapLabel(15);
                this.m_mainWidget.addComponent(this.m_modelCombo, 0);
                this.m_btnReload = this.m_mainWidget.createButton("Reload list of models", this, 0);
                this.m_mainWidget.addStretch(10);
                this.reloadModelCombo();
                this.loadModel();
                Messenger.singleton().addListener(this);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (this.m_inputEnsemble.traceCount() < 1) {
                return;
            }
            if (!RefractionStaticsProject.singleton().valid()) {
                return;
            }
            if (this.m_model == null) {
                this.loadModel();
            }
            if (this.m_model == null) {
                this.Reason = "Eikonal model not present";
                this.Success = false;
                return;
            }
            int id = Tools_Ensemble.isShotEnsemble(ensemble);
            if (id < 0) {
                this.Reason = "Must be a shot ensemble";
                this.Success = false;
                return;
            }
            int indexShotX = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexShotZ = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexShotD = -9999;
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", "PointDepth")) {
                indexShotD = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", "PointDepth");
            }
            int indexRecX = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexRecZ = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", "Elevation");
            double sx = this.m_inputEnsemble.trace(0).header().getDouble(indexShotX);
            double sy = this.m_inputEnsemble.trace(0).header().getDouble(indexShotY);
            double sz = this.m_inputEnsemble.trace(0).header().getDouble(indexShotZ);
            double sd = 0.0;
            if (indexShotD >= 0) {
                sd = this.m_inputEnsemble.trace(0).header().getDouble(indexShotD);
            }
            double maxOffset = Tools_Ensemble.maximumOffset(this.m_inputEnsemble);
            this.m_model.fireShot(-9999, sx, sy, sz, sd, maxOffset);
            if (id != this.m_currentID) {
                this.m_currentID = id;
            }
            for (int n = 0; n < this.m_inputEnsemble.traceCount(); ++n) {
                double rz;
                double ry;
                EnsembleTrace trace = this.m_inputEnsemble.trace(n);
                double rx = trace.header().getDouble(indexRecX);
                float time = this.m_model.addRec(-9999, rx, ry = trace.header().getDouble(indexRecY), rz = trace.header().getDouble(indexRecZ));
                if (!(time < 20000.0f)) continue;
                trace.data().addShiftToFirstSampleCoord(-time);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

