/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.FFT.FFT_1D_Wrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Ensemble.EnsembleFlagWidget;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class EnsembleWorker_PhaseRotate
extends EnsembleWorker_Base
implements IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = null;
    protected FFT_1D_Wrapper m_fft = new FFT_1D_Wrapper(512);
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_editor;
    protected EnsembleFlagWidget m_ensembleFlagWidget1;
    protected EnsembleFlagWidget m_ensembleFlagWidget2;
    protected EnsembleFlagWidget m_ensembleFlagWidget3;

    public EnsembleWorker_PhaseRotate() {
        try {
            this.Abbreviation = "PHASE";
            this.ShortDescription = "Phase rotation";
            this.WorkerType = "Filter";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_PhaseRotate";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Phase", this.m_editor.getDoubleValue());
            if (this.m_ensembleFlagWidget1 != null) {
                this.m_ensembleFlagWidget1.getParameters();
            }
            if (this.m_ensembleFlagWidget2 != null) {
                this.m_ensembleFlagWidget2.getParameters();
            }
            if (this.m_ensembleFlagWidget3 != null) {
                this.m_ensembleFlagWidget3.getParameters();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double phase = this.m_parameterTree.double_get("Phase", 0.0);
                this.m_editor = new SliderWidget(this, null, "Phase rotation, degrees", 0, phase, -360.0, 360.0);
                this.m_editor.setRangeLocked(true);
                Tools_FontChanger.changeSizeOfFont(this.m_editor, -1, null, true);
                this.m_mainWidget.addComponent(this.m_editor, 0);
                if (this.BelongsToInputSequence) {
                    this.m_mainWidget.createGapLabel(20);
                    this.m_mainWidget.addComponent(new JLabel("Rotation only applied to the following traces"), 0);
                    JTabbedPane tabs = new JTabbedPane();
                    this.m_ensembleFlagWidget1 = new EnsembleFlagWidget(0, null, this.m_parameterTree.ParameterTree_get("TraceFlagger1"));
                    tabs.addTab("Selector #1", this.m_ensembleFlagWidget1);
                    this.m_ensembleFlagWidget2 = new EnsembleFlagWidget(0, null, this.m_parameterTree.ParameterTree_get("TraceFlagger2"));
                    tabs.addTab("Selector #2", this.m_ensembleFlagWidget2);
                    this.m_ensembleFlagWidget3 = new EnsembleFlagWidget(0, null, this.m_parameterTree.ParameterTree_get("TraceFlagger3"));
                    tabs.addTab("Selector #3", this.m_ensembleFlagWidget3);
                    this.m_mainWidget.addComponent(tabs, 0);
                }
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected boolean handleFlagger(Ensemble ensemble, ParameterTree pt) {
        try {
            if (!pt.bool_get("On", false)) {
                return false;
            }
            String table = pt.string_get("Table", "Error");
            String column = pt.string_get("Column", "Error");
            double min = pt.double_get("Minimum", -1.0E20);
            double max = pt.double_get("Maximum", -1.0E20);
            Tools_Ensemble.flagTracesForInputEnsemble(ensemble, table, column, min, max);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double phase = this.m_parameterTree.double_get("Phase", 0.0);
            if (Math.abs(phase) < 0.001) {
                return;
            }
            boolean selectorOn = false;
            boolean selector1 = false;
            boolean selector2 = false;
            boolean selector3 = false;
            Tools_Ensemble.clearFlagTracesForInputEnsemble(ensemble);
            if (this.BelongsToInputSequence) {
                ParameterTree pt = this.m_parameterTree.ParameterTree_get("TraceFlagger1");
                selector1 = this.handleFlagger(ensemble, pt);
                pt = this.m_parameterTree.ParameterTree_get("TraceFlagger2");
                selector2 = this.handleFlagger(ensemble, pt);
                pt = this.m_parameterTree.ParameterTree_get("TraceFlagger3");
                selector3 = this.handleFlagger(ensemble, pt);
            }
            selectorOn = selector1 || selector2 || selector3;
            float radians = (float)(phase * Math.PI / 180.0);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                boolean okay = true;
                if (selectorOn) {
                    okay = trace.FlaggedForInputEnsemble;
                }
                if (!okay || !trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_fft.rotatePhase(radians, this.m_tempArray);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

