/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Filter;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Filter.FilterResponse_BandPass;
import com.PecosLibrary.Math.Filter.ZeroPhaseFilter_TimeDomain;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_Bandpass
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ZeroPhaseFilter_TimeDomain m_filter = new ZeroPhaseFilter_TimeDomain();
    protected FilterResponse_BandPass m_response = new FilterResponse_BandPass();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected JTextField m_corner1Text;
    protected JTextField m_corner2Text;
    protected JTextField m_corner3Text;
    protected JTextField m_corner4Text;
    protected JTextField m_lengthText;

    public EnsembleWorker_Bandpass() {
        try {
            this.Abbreviation = "BP";
            this.ShortDescription = "Bandpass filter";
            this.WorkerType = "Filter";
            this.m_filter.setResponse(this.m_response);
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_Bandpass";
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getAll(true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getAll(boolean broadcast) {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            float c1 = (float)Tools_Widget.extractDouble(this.m_corner1Text, 5.0, 0.0, 100.0);
            float c2 = (float)Tools_Widget.extractDouble(this.m_corner2Text, 10.0, (double)c1, 120.0);
            float c3 = (float)Tools_Widget.extractDouble(this.m_corner3Text, 35.0, (double)c2, 140.0);
            float c4 = (float)Tools_Widget.extractDouble(this.m_corner4Text, 45.0, (double)c3, 200.0);
            this.m_parameterTree.double_put("Corner1", c1);
            this.m_parameterTree.double_put("Corner2", c2);
            this.m_parameterTree.double_put("Corner3", c3);
            this.m_parameterTree.double_put("Corner4", c4);
            int len = Tools_Widget.extractInteger(this.m_lengthText, 21, 11, 121);
            this.m_parameterTree.int_put("Length", len);
            if (broadcast) {
                this.broadcast(this, "Modified");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.getAll(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int filterLen = this.m_parameterTree.int_get("Length", 21);
                float c1 = (float)this.m_parameterTree.double_get("Corner1", 5.0);
                float c2 = (float)this.m_parameterTree.double_get("Corner2", 10.0);
                float c3 = (float)this.m_parameterTree.double_get("Corner3", 35.0);
                float c4 = (float)this.m_parameterTree.double_get("Corner4", 45.0);
                this.m_lengthText = new JTextField(Integer.toString(filterLen));
                this.m_corner1Text = new JTextField(Float.toString(c1));
                this.m_corner2Text = new JTextField(Float.toString(c2));
                this.m_corner3Text = new JTextField(Float.toString(c3));
                this.m_corner4Text = new JTextField(Float.toString(c4));
                this.m_lengthText.addActionListener(this);
                this.m_corner1Text.addActionListener(this);
                this.m_corner2Text.addActionListener(this);
                this.m_corner3Text.addActionListener(this);
                this.m_corner4Text.addActionListener(this);
                grid.addSimple(0, new JLabel("Filter length (samples)"), this.m_lengthText);
                grid.addSimple(1, new JLabel("Corner #1 frequency"), this.m_corner1Text);
                grid.addSimple(2, new JLabel("Corner #2 frequency"), this.m_corner2Text);
                grid.addSimple(3, new JLabel("Corner #3 frequency"), this.m_corner3Text);
                grid.addSimple(4, new JLabel("Corner #4 frequency"), this.m_corner4Text);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            int filterLen = this.m_parameterTree.int_get("Length", 21);
            float c1 = (float)this.m_parameterTree.double_get("Corner1", 5.0);
            float c2 = (float)this.m_parameterTree.double_get("Corner2", 10.0);
            float c3 = (float)this.m_parameterTree.double_get("Corner3", 35.0);
            float c4 = (float)this.m_parameterTree.double_get("Corner4", 45.0);
            this.m_response.setCorners(c1, c2, c3, c4);
            this.m_filter.setFilterLength(filterLen);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                this.m_filter.setDigi(data.getSampleInterval());
                this.m_filter.apply(this.m_tempArray, this.m_tempArray.length);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

