/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Export;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EnsembleWorker_ExportSegy_ProjectRequired
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected JTabbedPane m_editor;
    protected FileWidget m_outFileWidget;
    protected JTextField m_txtSampleCount;
    protected JTextField m_txtDigi;
    protected JCheckBox m_chkTwoByteInt;
    protected TableOutputWidget ShotWidget;
    protected TableOutputWidget ReceiverWidget;
    protected TableOutputWidget TraceWidget;
    protected JCheckBox m_chkExcludeKilledShots;
    protected JCheckBox m_chkExcludeKilledReceivers;
    protected JCheckBox m_chkExcludeKilledTraces;
    protected JCheckBox m_chkExportPolarity;
    protected JTextField m_txtPolarityOffset;
    protected Segy_Exporter m_exporter = null;

    public EnsembleWorker_ExportSegy_ProjectRequired() {
        try {
            this.Abbreviation = "SEGYEXP";
            this.ShortDescription = "SEG-Y file export (project-based)";
            this.WorkerType = "Output";
            this.RequiresRefractionStaticsProject = true;
            this.InteractiveFlowsOkay = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_ExportSegy_ProjectRequired";
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_editor == null) {
                this.m_editor = new JTabbedPane();
                LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
                this.m_outFileWidget = new FileWidget(false, 3, "Select output SEG-Y file name", this);
                this.m_outFileWidget.OpenFile = false;
                main.addComponent(this.m_outFileWidget, 0);
                JTabbedPane extraTabs = new JTabbedPane();
                main.addComponent(extraTabs, 0);
                LinearLayoutWidget sub = LinearLayoutWidget.vert(3, null);
                GridLayoutWidget grid = new GridLayoutWidget(3, null);
                this.m_txtSampleCount = new JTextField();
                this.m_txtDigi = new JTextField();
                this.m_chkTwoByteInt = new JCheckBox("Use two-byte integer format");
                int row = 0;
                grid.addSimple(row++, new JLabel("Output sample count"), this.m_txtSampleCount);
                grid.addSimple(row++, new JLabel("Sample interval (ms)"), this.m_txtDigi);
                sub.addComponent(grid, 0);
                sub.addComponent(new JLabel("It is okay to have zero samples per trace"), 0);
                sub.addComponent(this.m_chkTwoByteInt, 0);
                sub.addStretch(10);
                extraTabs.addTab("Data", sub);
                sub = LinearLayoutWidget.vert(3, null);
                this.m_chkExcludeKilledShots = new JCheckBox("Exclude killed shots");
                this.m_chkExcludeKilledReceivers = new JCheckBox("Exclude killed receivers");
                this.m_chkExcludeKilledTraces = new JCheckBox("Exclude killed traces");
                this.m_chkExcludeKilledShots.setSelected(this.m_parameterTree.bool_get("ExcludeKilledShots", true));
                this.m_chkExcludeKilledReceivers.setSelected(this.m_parameterTree.bool_get("ExcludeKilledReceivers", true));
                this.m_chkExcludeKilledTraces.setSelected(this.m_parameterTree.bool_get("ExcludeKilledTraces", true));
                sub.addComponent(this.m_chkExcludeKilledShots, 0);
                sub.addComponent(this.m_chkExcludeKilledReceivers, 0);
                sub.addComponent(this.m_chkExcludeKilledTraces, 0);
                sub.addStretch(row);
                extraTabs.addTab("Exclusions", sub);
                sub = LinearLayoutWidget.vert(3, null);
                this.m_chkExportPolarity = new JCheckBox("Export trace polarity");
                this.m_chkExportPolarity.setSelected(this.m_parameterTree.bool_get("ExportPolarity", true));
                sub.addComponent(this.m_chkExportPolarity, 0);
                int off = this.m_parameterTree.int_get("PolarityOffset", 35);
                this.m_txtPolarityOffset = new JTextField(Integer.toString(off));
                sub.addHorzPair(new JLabel("Offset in header"), 0, this.m_txtPolarityOffset, 9);
                sub.addComponent(new JLabel("The polarity will be saved as a two byte integer"), 0);
                sub.addStretch(row);
                extraTabs.addTab("Polarity", sub);
                main.addStretch(10);
                String outName = this.m_parameterTree.string_get("OutFile", "");
                int numSamp = this.m_parameterTree.int_get("NumSamp", 500);
                double digi = this.m_parameterTree.double_get("Digi", 4.0);
                digi = Math.max(digi, 0.2);
                digi = Math.min(digi, 12.0);
                this.m_txtDigi.setText(Double.toString(digi));
                this.m_outFileWidget.setText(outName);
                this.m_txtSampleCount.setText(Integer.toString(numSamp));
                this.ShotWidget = new TableOutputWidget("Shot", this.m_parameterTree.ParameterTree_get("Shot"));
                this.ReceiverWidget = new TableOutputWidget("Receiver", this.m_parameterTree.ParameterTree_get("Receiver"));
                this.TraceWidget = new TableOutputWidget("Trace", this.m_parameterTree.ParameterTree_get("Trace"));
                this.m_editor.addTab("File", main);
                this.m_editor.addTab("Shot", this.ShotWidget);
                this.m_editor.addTab("Receiver", this.ReceiverWidget);
                this.m_editor.addTab("Trace", this.TraceWidget);
            }
            return this.m_editor;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_editor == null) {
                return;
            }
            this.m_parameterTree.string_put("OutFile", this.m_outFileWidget.getText());
            int numSamp = Tools_Widget.extractInteger(this.m_txtSampleCount, 100, 0, 8000);
            this.m_parameterTree.int_put("NumSamp", numSamp);
            double digi = Tools_Widget.extractDouble(this.m_txtDigi, 4.0, 0.25, 12.0);
            this.m_parameterTree.double_put("Digi", digi);
            this.ShotWidget.save();
            this.ReceiverWidget.save();
            this.TraceWidget.save();
            this.m_parameterTree.bool_put("TwoByteInt", this.m_chkTwoByteInt.isSelected());
            this.m_parameterTree.bool_put("ExcludeKilledShots", this.m_chkExcludeKilledShots.isSelected());
            this.m_parameterTree.bool_put("ExcludeKilledReceivers", this.m_chkExcludeKilledReceivers.isSelected());
            this.m_parameterTree.bool_put("ExcludeKilledTraces", this.m_chkExcludeKilledTraces.isSelected());
            this.m_parameterTree.bool_put("ExportPolarity", this.m_chkExportPolarity.isSelected());
            this.m_parameterTree.int_put("PolarityOffset", Tools_Widget.extractInteger(this.m_txtPolarityOffset, 35, 1, 237));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            if (ensemble.traceCount() < 1) {
                return;
            }
            if (this.SharedData.Type != EnsembleWorker_Sequence.SequenceType.Processing) {
                return;
            }
            if (this.m_exporter == null) {
                if (this.ShotWidget == null) {
                    JComponent jComponent = this.editorWidget();
                }
                this.getParametersFromWidget();
                this.m_exporter = new Segy_Exporter();
                this.m_exporter.ExportPolarity = this.m_parameterTree.bool_get("ExportPolarity", true);
                this.m_exporter.PolarityOffset = this.m_parameterTree.int_get("PolarityOffset", 35);
                this.m_exporter.ExcludeKilledReceivers = this.m_parameterTree.bool_get("ExcludeKilledReceivers", true);
                this.m_exporter.ExcludeKilledShots = this.m_parameterTree.bool_get("ExcludeKilledShots", true);
                this.m_exporter.ExcludeKilledTraces = this.m_parameterTree.bool_get("ExcludeKilledTraces", true);
                this.m_exporter.Dictionary = new Segy_Dictionary();
                this.ShotWidget.populateSegyDictionary(this.m_exporter.Dictionary);
                this.ReceiverWidget.populateSegyDictionary(this.m_exporter.Dictionary);
                this.TraceWidget.populateSegyDictionary(this.m_exporter.Dictionary);
                this.m_exporter.FileName = this.m_parameterTree.string_get("OutFile", "");
                this.m_exporter.OutputSampleCount = this.m_parameterTree.int_get("NumSamp", 500);
                this.m_exporter.OutputDigi = (float)this.m_parameterTree.double_get("Digi", 4.0);
                this.m_exporter.prepareFile();
            }
            this.m_exporter.appendEnsemble(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }

    public class TableOutputWidget
    extends LinearLayoutWidget
    implements ItemListener,
    GenericObjectListener.Listener {
        public String TableName;
        public ArrayList<TableWidgetRow> RowList;
        public ArrayList<String> Columns;
        protected GridLayoutWidget Grid;
        protected ParameterTree m_tree;

        public String colKey(int row) {
            return "Column" + Integer.toString(row);
        }

        public String offKey(int row) {
            return "Offset" + Integer.toString(row);
        }

        public String typeKey(int row) {
            return "Type" + Integer.toString(row);
        }

        public TableOutputWidget(String table, ParameterTree tree) {
            super(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.RowList = new ArrayList();
            this.Columns = null;
            try {
                this.m_tree = tree;
                boolean firstTime = !this.m_tree.string_exists(this.colKey(0));
                this.TableName = table;
                this.Grid = this.createGridLayoutWidget(0, 10);
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                if (this.TableName.equalsIgnoreCase("Trace")) {
                    this.Columns = project.traceTableWrapper().traceTable().columns();
                    this.Columns.add("Offset");
                    this.Columns.add("Azimuth");
                    this.Columns.add("CdpX");
                    this.Columns.add("CdpY");
                    Collections.sort(this.Columns);
                } else {
                    this.Columns = project.geometryDatabase().listOfColumnNames(this.TableName);
                }
                this.Columns.add(0, "UNUSED");
                for (int n = 0; n < 15; ++n) {
                    TableWidgetRow row = new TableWidgetRow();
                    row.ColumnList.setStringArray(this.Columns);
                    this.Grid.addComponent(row.ColumnList, n, 0, 0.0, 10.0);
                    this.Grid.addComponent(row.OffsetText, n, 1, 0.0, 6.0);
                    this.Grid.addComponent(row.TypeCombo, n, 2, 0.0, 6.0);
                    this.RowList.add(row);
                    if (!firstTime) {
                        String col = this.m_tree.string_get(this.colKey(n), "UNUSED");
                        row.ColumnList.setPreferredSelected(col);
                        int off = this.m_tree.int_get(this.offKey(n), 1);
                        row.OffsetText.setText(Integer.toString(off));
                        String dataType = this.m_tree.string_get(this.typeKey(n), DataType.Int.Description);
                        if (dataType.equalsIgnoreCase(DataType.Int.Description)) {
                            row.TypeCombo.setSelectedIndex(0);
                        } else if (dataType.equalsIgnoreCase(DataType.Short.Description)) {
                            row.TypeCombo.setSelectedIndex(1);
                        } else {
                            row.TypeCombo.setSelectedIndex(2);
                        }
                    }
                    row.ColumnList.listener().addListener(this);
                }
                if (firstTime) {
                    if (this.TableName.equalsIgnoreCase("Trace")) {
                        this.addDefaultTrace();
                    }
                    if (this.TableName.equalsIgnoreCase("Shot")) {
                        this.addDefaultShot();
                    }
                    if (this.TableName.equalsIgnoreCase("Receiver")) {
                        this.addDefaultReceiver();
                    }
                }
                this.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
                this.setStatus();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void handleGenericObjectListener(Object sender, Object data) {
            try {
                this.setStatus();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        protected void addColumn(String column) {
            try {
                for (String s : this.Columns) {
                    if (!s.equalsIgnoreCase(column)) continue;
                    return;
                }
                this.Columns.add(column);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void setStatus() {
            try {
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                Table_Abstract tbl = null;
                ITraceTable trc = null;
                if (this.TableName.equalsIgnoreCase("Shot")) {
                    tbl = project.shotTable();
                }
                if (this.TableName.equalsIgnoreCase("Receiver")) {
                    tbl = project.receiverTable();
                }
                if (this.TableName.equalsIgnoreCase("Trace")) {
                    trc = project.traceTableWrapper().traceTable();
                }
                for (int n = 0; n < this.RowList.size(); ++n) {
                    TableWidgetRow row = this.RowList.get(n);
                    String col = row.ColumnList.getSelectedString();
                    boolean okay = false;
                    if (tbl != null) {
                        okay = tbl.column_exists(col);
                    }
                    if (trc != null) {
                        okay = trc.column_exists(col);
                        okay = okay || col.equalsIgnoreCase("Offset");
                        boolean bl = okay = okay || col.equalsIgnoreCase("Azimuth");
                    }
                    if (okay) {
                        row.OffsetText.setBackground(Color.white);
                        continue;
                    }
                    row.OffsetText.setBackground(Color.yellow);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void selectInFirstUnused(String column, int offset) {
            try {
                String col;
                TableWidgetRow row;
                int n;
                for (n = 0; n < this.RowList.size(); ++n) {
                    row = this.RowList.get(n);
                    col = row.ColumnList.getSelectedString();
                    if (!col.equalsIgnoreCase(column)) continue;
                    return;
                }
                for (n = 0; n < this.RowList.size(); ++n) {
                    row = this.RowList.get(n);
                    col = row.ColumnList.getSelectedString();
                    if (!col.equalsIgnoreCase("UNUSED")) continue;
                    row.ColumnList.setPreferredSelected(column);
                    row.TypeCombo.setSelectedIndex(0);
                    row.OffsetText.setText(Integer.toString(offset));
                    return;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addDefaultSeisupColumns() {
            try {
                this.Columns.remove(0);
                if (this.TableName.equalsIgnoreCase("Shot")) {
                    this.addColumn("SSPN");
                    this.addColumn("FSPN");
                }
                if (this.TableName.equalsIgnoreCase("Trace")) {
                    this.addColumn("Channel");
                }
                Collections.sort(this.Columns);
                this.Columns.add(0, "UNUSED");
                for (int n = 0; n < this.RowList.size(); ++n) {
                    TableWidgetRow row = this.RowList.get(n);
                    row.ColumnList.setStringArray(this.Columns);
                }
                if (this.TableName.equalsIgnoreCase("Shot")) {
                    this.selectInFirstUnused("SSPN", 9);
                    this.selectInFirstUnused("FSPN", 9);
                    this.overrideSettings("PointNumber", 197, DataType.Int);
                    this.overrideSettings("PointIndex", 185, DataType.Int);
                    this.overrideSettings("LineNumber", 181, DataType.Int);
                }
                if (this.TableName.equalsIgnoreCase("Receiver")) {
                    this.overrideSettings("PointNumber", 201, DataType.Int);
                    this.overrideSettings("PointIndex", 27, DataType.Int);
                }
                if (this.TableName.equalsIgnoreCase("Trace")) {
                    this.selectInFirstUnused("Channel", 13);
                }
                this.setStatus();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void populateSegyDictionary(Segy_Dictionary dict) {
            try {
                for (int n = 0; n < this.RowList.size(); ++n) {
                    TableWidgetRow row = this.RowList.get(n);
                    String col = row.ColumnList.getSelectedString();
                    int offset = Tools_Widget.extractInteger(row.OffsetText, 1, 1, 237);
                    DataType type = DataType.Int;
                    if (row.TypeCombo.getSelectedIndex() == 1) {
                        type = DataType.Short;
                    }
                    if (row.TypeCombo.getSelectedIndex() == 2) {
                        type = DataType.Float;
                    }
                    if (col.equalsIgnoreCase("UNUSED")) continue;
                    dict.addEntry(this.TableName, col, type, DataType.Int, offset - 1, Segy_Dictionary.Modification.None, 1);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void overrideSettings(String column, int offset, DataType type) {
            try {
                for (int n = 0; n < this.RowList.size(); ++n) {
                    TableWidgetRow row = this.RowList.get(n);
                    String col = row.ColumnList.getSelectedString();
                    if (!col.equalsIgnoreCase(column)) continue;
                    this.setDefaults(n, col, offset, type);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        protected void setDefaults(int n, String col, int offset, DataType type) {
            try {
                TableWidgetRow row = this.RowList.get(n);
                row.ColumnList.setPreferredSelected(col);
                row.OffsetText.setText(Integer.toString(offset));
                if (type == DataType.Int) {
                    row.TypeCombo.setSelectedIndex(0);
                }
                if (type == DataType.Short) {
                    row.TypeCombo.setSelectedIndex(1);
                }
                if (type == DataType.Float) {
                    row.TypeCombo.setSelectedIndex(2);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void addDefaultShot() {
            try {
                int n = 0;
                this.setDefaults(n++, "FFID", 9, DataType.Int);
                this.setDefaults(n++, "Easting", 73, DataType.Int);
                this.setDefaults(n++, "Northing", 77, DataType.Int);
                this.setDefaults(n++, "Elevation", 45, DataType.Int);
                this.setDefaults(n++, "PointDepth", 49, DataType.Int);
                this.setDefaults(n++, "UpholeTime", 95, DataType.Short);
                this.setDefaults(n++, "LineNumber", 201, DataType.Int);
                this.setDefaults(n++, "PointNumber", 205, DataType.Int);
                this.setDefaults(n++, "PointIndex", 209, DataType.Int);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void addDefaultReceiver() {
            try {
                int n = 0;
                this.setDefaults(n++, "Easting", 81, DataType.Int);
                this.setDefaults(n++, "Northing", 85, DataType.Int);
                this.setDefaults(n++, "Elevation", 41, DataType.Int);
                this.setDefaults(n++, "LineNumber", 213, DataType.Int);
                this.setDefaults(n++, "PointNumber", 217, DataType.Int);
                this.setDefaults(n++, "PointIndex", 221, DataType.Int);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void addDefaultTrace() {
            try {
                int n = 0;
                this.setDefaults(n++, "TraceCode", 29, DataType.Short);
                this.setDefaults(n++, "Channel", 13, DataType.Int);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void save() {
            try {
                for (int n = 0; n < this.RowList.size(); ++n) {
                    TableWidgetRow row = this.RowList.get(n);
                    int offset = Tools_Widget.extractInteger(row.OffsetText, 1, 1, 237);
                    this.m_tree.string_put(this.colKey(n), row.ColumnList.getSelectedString());
                    this.m_tree.string_put(this.offKey(n), Integer.toString(offset));
                    this.m_tree.string_put(this.typeKey(n), (String)row.TypeCombo.getSelectedItem());
                }
                this.setStatus();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    public class TableWidgetRow {
        public ComboStringListWrapper ColumnList = new ComboStringListWrapper();
        public JTextField OffsetText = new JTextField();
        public JComboBox<String> TypeCombo = new JComboBox();

        public TableWidgetRow() {
            this.TypeCombo.addItem(DataType.Int.Description);
            this.TypeCombo.addItem(DataType.Short.Description);
            this.TypeCombo.addItem(DataType.Float.Description);
            this.TypeCombo.setSelectedIndex(0);
            this.ColumnList.setEditable(true);
        }
    }
}

