/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Amplitude;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EnsembleWorker_WindowScalar
extends EnsembleWorker_Base
implements IParameterWidgetListener,
ActionListener {
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected Ensemble m_inputEnsemble = null;
    protected float[] m_tempArray = null;
    protected LinearLayoutWidget m_mainWidget;
    protected SliderWidget m_windowEditor;
    protected SliderWidget m_biasEditor;
    protected JCheckBox m_chkShowEnvelope;
    protected JCheckBox m_chkNonlinearScaling;

    public EnsembleWorker_WindowScalar() {
        try {
            this.Abbreviation = "Edge detector";
            this.ShortDescription = "Edge detector";
            this.WorkerType = "Amplitude";
            this.InteractiveFlowsOkay = true;
            this.m_parameterTree.double_put("Window", 50.0);
            this.m_parameterTree.double_put("Bias", 2.0);
            this.m_parameterTree.bool_put("Envelope", false);
            this.m_parameterTree.bool_put("Nonlinear", false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_WindowScalar";
    }

    public void setWindow(double window) {
        try {
            window = Math.max(20.0, window);
            this.m_parameterTree.double_put("Window", window);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                double window = this.m_parameterTree.double_get("Window", 50.0);
                this.m_windowEditor = new SliderWidget(this, null, "Window length, milliseconds", 0, window, 12.0, 400.0);
                this.m_windowEditor.setRangeLocked(false);
                Tools_FontChanger.changeSizeOfFont(this.m_windowEditor, -1, null, true);
                double bias = this.m_parameterTree.double_get("Bias", 2.0);
                this.m_biasEditor = new SliderWidget(this, null, "Bias", 0, bias, 1.0, 50.0);
                this.m_biasEditor.setRangeLocked(true);
                Tools_FontChanger.changeSizeOfFont(this.m_biasEditor, -1, null, true);
                this.m_chkShowEnvelope = new JCheckBox("Just show edge envelope");
                this.m_chkShowEnvelope.addActionListener(this);
                this.m_chkShowEnvelope.setSelected(this.m_parameterTree.bool_get("Envelope", false));
                this.m_chkNonlinearScaling = new JCheckBox("Use nonlinear sample scaling");
                this.m_chkNonlinearScaling.addActionListener(this);
                this.m_chkNonlinearScaling.setSelected(this.m_parameterTree.bool_get("Nonlinear", false));
                this.m_mainWidget.addComponent(this.m_windowEditor, 0);
                this.m_mainWidget.addComponent(this.m_biasEditor, 0);
                this.m_mainWidget.addComponent(this.m_chkShowEnvelope, 0);
                this.m_mainWidget.addComponent(this.m_chkNonlinearScaling, 0);
                this.m_mainWidget.addStretch(10);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_parameterTree.double_put("Window", this.m_windowEditor.getDoubleValue());
            this.m_parameterTree.double_put("Bias", this.m_biasEditor.getDoubleValue());
            this.m_parameterTree.bool_put("Envelope", this.m_chkShowEnvelope.isSelected());
            this.m_parameterTree.bool_put("Nonlinear", this.m_chkNonlinearScaling.isSelected());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            double window = this.m_parameterTree.double_get("Window", 200.0);
            float bias = (float)this.m_parameterTree.double_get("Bias", 2.0);
            boolean envelope = this.m_parameterTree.bool_get("Envelope", false);
            boolean nonlinear = this.m_parameterTree.bool_get("Nonlinear", false);
            bias = 0.01f * bias;
            if (Math.abs(window) < 4.0) {
                this.Success = false;
                this.Reason = "Window too short";
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData()) continue;
                FloatArrayWrapper data = trace.data();
                if (this.m_tempArray == null) {
                    this.m_tempArray = new float[data.length()];
                }
                if (this.m_tempArray.length != data.length()) {
                    this.m_tempArray = new float[data.length()];
                }
                data.copyToArray(this.m_tempArray);
                int totalWindowLength = (int)(window / (double)data.getSampleInterval());
                this.m_renorm.applyPrePost(this.m_tempArray, bias, totalWindowLength, !envelope, nonlinear);
                data.insertArray(this.m_tempArray, this.m_tempArray.length);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

