/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class CommonHeaderIndexWrapper {
    public int IndexShotX;
    public int IndexShotY;
    public int IndexShotZ;
    public int IndexShotUphole;
    public int IndexShotDepth;
    public int IndexRecX;
    public int IndexRecY;
    public int IndexRecZ;
    public int IndexOffset;
    public int IndexAzimuth;
    public int IndexBranch;
    public int IndexPick;
    public int[] IndexShotDelayTime = new int[10];
    public int[] IndexShotVelocity = new int[10];
    public int[] IndexReceiverDelayTime = new int[10];
    public int[] IndexReceiverVelocity = new int[10];

    public void prep(Ensemble ensemble) throws Exception {
        try {
            int b;
            this.IndexPick = -9999;
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            this.IndexBranch = this.check(dict, "Trace", "Branch");
            this.IndexShotX = this.check(dict, "Shot", "Easting");
            this.IndexShotY = this.check(dict, "Shot", "Northing");
            this.IndexShotZ = this.check(dict, "Shot", "Elevation");
            this.IndexShotUphole = this.check(dict, "Shot", "UpholeTime");
            this.IndexShotDepth = this.check(dict, "Shot", "PointDepth");
            this.IndexRecX = this.check(dict, "Receiver", "Easting");
            this.IndexRecY = this.check(dict, "Receiver", "Northing");
            this.IndexRecZ = this.check(dict, "Receiver", "Elevation");
            this.IndexOffset = this.check(dict, "Trace", "Offset");
            this.IndexAzimuth = this.check(dict, "Trace", "Azimuth");
            RefractionStaticsProject.singleton();
            int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
            for (b = 0; b < this.IndexShotVelocity.length; ++b) {
                this.IndexShotDelayTime[b] = -9999;
                this.IndexShotVelocity[b] = -9999;
                this.IndexReceiverDelayTime[b] = -9999;
                this.IndexReceiverVelocity[b] = -9999;
            }
            for (b = 1; b <= maxBranch; ++b) {
                this.IndexShotDelayTime[b] = this.check(dict, "Shot", Pecos.getColNameDT(b));
                this.IndexShotVelocity[b] = this.check(dict, "Shot", Pecos.getColNameVel(b));
                this.IndexReceiverDelayTime[b] = this.check(dict, "Receiver", Pecos.getColNameDT(b));
                this.IndexReceiverVelocity[b] = this.check(dict, "Receiver", Pecos.getColNameVel(b));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int check(EnsembleHeaderDictionary dict, String t, String c) {
        try {
            if (dict.containsEntry(t, c)) {
                return dict.getEntryIndex(t, c);
            }
            return -9999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }
}

