/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Echos;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Echos.EchosInterface;
import com.PecosLibrary.Echos.EchosSeismicFile;
import com.PecosLibrary.Echos.EchosTraceFileInfo;
import com.PecosLibrary.Echos.SWIGTYPE_p_float;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtParadigmFileRec;
import com.PecosLibrary.Echos.XtParadigmFileRecList;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Echos.XtParadigmTfGather;
import com.PecosLibrary.Echos.XtParadigmTraceFile;
import com.PecosLibrary.Echos.XtTraceHeader;
import com.PecosLibrary.Echos.XtType;
import com.PecosLibrary.Seismic.Echos.Echos_Dictionary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XtParadigmTraceFileTools {
    public static final String Lname = "Lname";
    public static final String Host = "Host";
    public static final String Survey = "Survey";
    public static final String LineID = "LineID";
    public static final String SurveyType = "SurveyType";
    public static final String FileID = "FileID";
    public static final String EchosTraceFile = "EchosTraceFile";

    public static String getFileRecXmlDescriptor(XtParadigmFileRec fileRec, String sHost, String sSurvey, int iSurveyType) throws Exception {
        try {
            long fileID = fileRec.GetFileID();
            String sLname = fileRec.GetLname();
            int iLineID = fileRec.GetLineID();
            String sXml = XtParadigmTraceFileTools.getFileRecXmlDescriptor(fileID, sLname, sHost, sSurvey, iLineID, iSurveyType);
            return sXml;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String getFileRecXmlDescriptor(long fileID, String sLname, String sHost, String sSurvey, int iLineID, int iSurveyType) throws Exception {
        try {
            Document xmlDoc = Tools_XML.createDocument();
            Element root = xmlDoc.createElement(EchosTraceFile);
            xmlDoc.appendChild(root);
            root.setAttribute(Host, sHost);
            root.setAttribute(Survey, sSurvey);
            root.setAttribute(FileID, Long.toString(fileID));
            root.setAttribute(Lname, sLname);
            root.setAttribute(SurveyType, Integer.toString(iSurveyType));
            root.setAttribute(LineID, Integer.toString(iLineID));
            String sXml = Tools_XML.writeDocumentToString(xmlDoc);
            return sXml;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static EchosTraceFileInfo getTraceFileInfo(String sXml) {
        EchosTraceFileInfo info = new EchosTraceFileInfo();
        try {
            Document doc = Tools_XML.readDocumentFromString(sXml);
            boolean bHasChildNodes = doc.hasChildNodes();
            Element root = null;
            if (bHasChildNodes) {
                NodeList nodeList = doc.getChildNodes();
                int nNodes = nodeList.getLength();
                for (int i = 0; i < nNodes; ++i) {
                    Element e;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !(e = (Element)node).getNodeName().equals(EchosTraceFile)) continue;
                    root = e;
                }
            }
            if (root == null) {
                throw new Exception("Missing Element :  EchosTraceFile");
            }
            String sHost = "";
            String sSurvey = "";
            String sFileID = "";
            String sLname = "";
            String sSurveyType = "";
            String sLine = "";
            int iLineID = -1;
            int iSurveyType = 0;
            long iFileID = 0L;
            if (!root.hasAttribute(Host)) {
                throw new Exception("Missing attribute 'Host'");
            }
            sHost = root.getAttribute(Host);
            if (!root.hasAttribute(Survey)) {
                throw new Exception("Missing attribute 'Survey'");
            }
            sSurvey = root.getAttribute(Survey);
            if (!root.hasAttribute(SurveyType)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sSurveyType = root.getAttribute(SurveyType);
            if (root.hasAttribute(LineID)) {
                sLine = root.getAttribute(LineID);
                iLineID = Integer.parseInt(sLine);
            }
            if (!root.hasAttribute(FileID)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sFileID = root.getAttribute(FileID);
            if (!root.hasAttribute(Lname)) {
                throw new Exception("Missing attribute 'Lname'");
            }
            sLname = root.getAttribute(Lname);
            iFileID = Long.parseLong(sFileID);
            iSurveyType = Integer.parseInt(sSurveyType);
            info.Survey = sSurvey;
            info.Host = sHost;
            info.Lname = sLname;
            info.SurveyType = iSurveyType;
            info.FileID = iFileID;
            info.LineID = iLineID;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return info;
    }

    public static EchosSeismicFile createNewSeismicTraceFile(String sXml, Echos_Dictionary dict) throws Exception {
        try {
            EchosSeismicFile traceFile = null;
            Document doc = Tools_XML.readDocumentFromString(sXml);
            boolean bHasChildNodes = doc.hasChildNodes();
            Element root = null;
            if (bHasChildNodes) {
                NodeList nodeList = doc.getChildNodes();
                int nNodes = nodeList.getLength();
                for (int i = 0; i < nNodes; ++i) {
                    Element e;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !(e = (Element)node).getNodeName().equals(EchosTraceFile)) continue;
                    root = e;
                }
            }
            if (root == null) {
                throw new Exception("Missing Element :  EchosTraceFile");
            }
            String sHost = "";
            String sSurvey = "";
            String sFileID = "";
            String sLname = "";
            String sSurveyType = "";
            int iLineID = -1;
            int iSurveyType = 0;
            long iFileID = 0L;
            if (!root.hasAttribute(Host)) {
                throw new Exception("Missing attribute 'Host'");
            }
            sHost = root.getAttribute(Host);
            if (!root.hasAttribute(Survey)) {
                throw new Exception("Missing attribute 'Survey'");
            }
            sSurvey = root.getAttribute(Survey);
            if (!root.hasAttribute(SurveyType)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sSurveyType = root.getAttribute(SurveyType);
            if (!root.hasAttribute(FileID)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sFileID = root.getAttribute(FileID);
            if (root.hasAttribute(LineID)) {
                String sLine = root.getAttribute(LineID);
                iLineID = Integer.parseInt(sLine);
            }
            if (!root.hasAttribute(Lname)) {
                throw new Exception("Missing attribute 'Lname'");
            }
            sLname = root.getAttribute(Lname);
            iFileID = Long.parseLong(sFileID);
            iSurveyType = Integer.parseInt(sSurveyType);
            boolean bEchosInitializedOk = XtEchos.initialize();
            if (!bEchosInitializedOk) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                String sException = sError + " : " + sErrorDetails;
                throw new Exception(sException);
            }
            XtParadigmSurvey survey = XtEchos.getParadigmSurvey(sSurvey, sHost, iSurveyType);
            if (survey == null) {
                throw new Exception("null survey " + sSurvey + "@" + sHost);
            }
            XtParadigmFileRec foundFileRec = null;
            XtParadigmFileRecList fileRecList = survey.getFileRecList();
            int nFiles = fileRecList.size();
            for (int i = 0; i < nFiles; ++i) {
                XtParadigmFileRec fileRec = fileRecList.get(i);
                long tmpFileID = fileRec.GetFileID();
                String tmpfileName = fileRec.GetLname();
                if (tmpFileID != iFileID) continue;
                foundFileRec = fileRec;
                break;
            }
            if (foundFileRec == null) {
                throw new Exception("Unable to find fileid : " + Long.toString(iFileID) + " in Survey " + sSurvey + "@" + sHost);
            }
            XtParadigmTraceFile echosTraceFile = new XtParadigmTraceFile(foundFileRec);
            traceFile = new EchosSeismicFile(dict, echosTraceFile, sSurvey, sHost, sLname, iFileID, iSurveyType, iLineID);
            return traceFile;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static XtParadigmTraceFile createNewTraceFile(String sXml) throws Exception {
        try {
            Document doc = Tools_XML.readDocumentFromString(sXml);
            Element root = doc.getElementById(EchosTraceFile);
            if (root == null) {
                throw new Exception("Missing Element :  EchosTraceFile");
            }
            String sHost = "";
            String sSurvey = "";
            String sFileID = "";
            String sLname = "";
            String sSurveyType = "";
            int iSurveyType = 0;
            long iFileID = 0L;
            if (!root.hasAttribute(Host)) {
                throw new Exception("Missing attribute 'Host'");
            }
            sHost = root.getAttribute(Host);
            if (!root.hasAttribute(Survey)) {
                throw new Exception("Missing attribute 'Survey'");
            }
            sSurvey = root.getAttribute(Survey);
            if (!root.hasAttribute(SurveyType)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sSurveyType = root.getAttribute(SurveyType);
            if (!root.hasAttribute(FileID)) {
                throw new Exception("Missing attribute 'SurveyType'");
            }
            sFileID = root.getAttribute(FileID);
            if (!root.hasAttribute(Lname)) {
                throw new Exception("Missing attribute 'Lname'");
            }
            sLname = root.getAttribute(Lname);
            iFileID = Long.parseLong(sFileID);
            iSurveyType = Integer.parseInt(sSurveyType);
            boolean bEchosInitializedOk = XtEchos.initialize();
            if (!bEchosInitializedOk) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                String sException = sError + " : " + sErrorDetails;
                throw new Exception(sException);
            }
            XtParadigmSurvey survey = XtEchos.getParadigmSurvey(sSurvey, sHost, iSurveyType);
            if (survey == null) {
                throw new Exception("null survey " + sSurvey + "@" + sHost);
            }
            XtParadigmFileRec foundFileRec = null;
            XtParadigmFileRecList fileRecList = survey.getFileRecList();
            int nFiles = fileRecList.size();
            for (int i = 0; i < nFiles; ++i) {
                XtParadigmFileRec fileRec = fileRecList.get(i);
                long tmpFileID = fileRec.GetFileID();
                String tmpfileName = fileRec.GetLname();
                if (tmpFileID != iFileID) continue;
                foundFileRec = fileRec;
                break;
            }
            if (foundFileRec == null) {
                throw new Exception("Unable to find fileid : " + Long.toString(iFileID) + " in Survey " + sSurvey + "@" + sHost);
            }
            XtParadigmTraceFile traceFile = new XtParadigmTraceFile(foundFileRec);
            return traceFile;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static boolean prepareEchos_Dictionary(XtParadigmTfGather gather, Echos_Dictionary dictionary) throws Exception {
        if (gather == null) {
            throw new Exception("null gather");
        }
        if (dictionary == null) {
            throw new Exception("null dictionary");
        }
        int nEntries = dictionary.entryCount();
        for (int i = 0; i < nEntries; ++i) {
            Echos_Dictionary.Entry entry = dictionary.getEntry(i);
            entry.EchosHeaderWordIndex = gather.getHeaderWordIndex(entry.EchosHeader);
            entry.EchosType = gather.getHeaderXtType(entry.EchosHeader);
            entry.Valid = entry.EchosHeaderWordIndex >= 0;
        }
        return true;
    }

    public static boolean populateEnsemble(Echos_Dictionary dictionary, XtParadigmTfGather echosGather, Ensemble ensemble, boolean bGetHeaders, boolean bGetSamples, SWIGTYPE_p_float swigFloatArray, int nSwigFloatArraySamples, float[] sampleFloatArray) throws Exception {
        if (echosGather == null) {
            throw new Exception("null echosGather");
        }
        if (ensemble == null) {
            throw new Exception("null Ensemble");
        }
        if (swigFloatArray == null && bGetSamples) {
            throw new Exception("null float array");
        }
        if (bGetHeaders) {
            dictionary.prepareSeismicHeaderDictionary(ensemble.dictionary());
            XtParadigmTraceFileTools.prepareEchos_Dictionary(echosGather, dictionary);
        }
        int nHeaders = dictionary.entryCount();
        int nSamples = echosGather.getNumSamples();
        if (bGetSamples) {
            if (nSwigFloatArraySamples != nSamples) {
                throw new Exception("invalid swig sample count");
            }
            if (sampleFloatArray == null) {
                throw new Exception("null float array");
            }
            if (sampleFloatArray.length != nSamples) {
                throw new Exception("invalid float array sample count");
            }
        }
        int nTraces = echosGather.getNumTraces();
        for (int iTrace = 0; iTrace < nTraces; ++iTrace) {
            EnsembleTrace ensembleTrace = ensemble.addTrace();
            FloatArrayWrapper sampleArray = ensembleTrace.data();
            Column_Abstract headers = ensembleTrace.header();
            if (bGetHeaders) {
                for (int iHeader = 0; iHeader < nHeaders; ++iHeader) {
                    Echos_Dictionary.Entry headerEntry = dictionary.getEntry(iHeader);
                    if (headerEntry.EchosHeaderWordIndex >= 0) {
                        if (headerEntry.EchosType == XtType.XtTypeInt) {
                            int iVal = echosGather.getHeaderInt(iTrace, headerEntry.EchosHeaderWordIndex);
                            headers.putInt(headerEntry.HeaderIndex, iVal);
                            continue;
                        }
                        if (headerEntry.EchosType == XtType.XtTypeFloat) {
                            float fVal = echosGather.getHeaderFloat(iTrace, headerEntry.EchosHeaderWordIndex);
                            headers.putFloat(headerEntry.HeaderIndex, fVal);
                            continue;
                        }
                        if (headerEntry.EchosType == XtType.XtTypeDouble) {
                            double dVal = echosGather.getHeaderDouble(iTrace, headerEntry.EchosHeaderWordIndex);
                            headers.putDouble(headerEntry.HeaderIndex, dVal);
                            continue;
                        }
                        headers.putDouble(headerEntry.HeaderIndex, headerEntry.DefaultValue);
                        continue;
                    }
                    headers.putDouble(headerEntry.HeaderIndex, headerEntry.DefaultValue);
                }
            }
            if (!bGetSamples) continue;
            float fTraceTime0 = 0.0f;
            float fSampleInterval = (float)echosGather.getSampleIntervalInMilliseconds();
            echosGather.getTraceData(iTrace, swigFloatArray, nSamples);
            for (int iSample = 0; iSample < nSamples; ++iSample) {
                float fSample;
                sampleFloatArray[iSample] = fSample = EchosInterface.floatArray_getitem(swigFloatArray, iSample);
            }
            sampleArray.insertArray(sampleFloatArray, nSamples);
            sampleArray.setFirstSampleCoord(fTraceTime0);
            sampleArray.setSampleInterval(fSampleInterval);
        }
        boolean bOk = Tools_Ensemble.computeAzimuthAndOffset(ensemble);
        return true;
    }

    public static boolean populateEnsemble(XtParadigmTraceFile traceFile, Echos_Dictionary dict, Ensemble ensemble, long[] indices, int indexCount, boolean bGetHeaders, boolean bGetData, float[] traceDataArray) throws Exception {
        try {
            boolean bOk;
            if (traceFile == null) {
                throw new Exception("null trace file");
            }
            long startTime = System.nanoTime();
            bGetHeaders = bGetHeaders && dict != null;
            int nSamplesPerTrace = traceFile.GetTraceLen();
            bGetData = bGetData && nSamplesPerTrace > 0 && traceDataArray != null;
            boolean isFirstTrace = true;
            float traceTime0 = 0.0f;
            indexCount = Math.min(indexCount, indices.length);
            if (traceFile.IsOpened() == 0 && !(bOk = traceFile.Open())) {
                throw new Exception("Unable to open Echos trace file : " + traceFile.GetLogicalName());
            }
            long traceCount = traceFile.GetNumTraces();
            XtTraceHeader traceHeader = new XtTraceHeader(traceFile);
            SWIGTYPE_p_float samplesArray = EchosInterface.new_floatArray(nSamplesPerTrace);
            int iHeaderFieldIndexShtX = traceFile.getHdrFieldIndex("shotx");
            int iHdrIndex = traceFile.GetHdrIndex("shotx");
            for (int k = 0; k < indexCount; ++k) {
                long iTrace = indices[k];
                if (iTrace < 0L || iTrace >= traceCount) continue;
                int n = traceFile.ReadTrace(samplesArray, nSamplesPerTrace, 0, traceHeader, iTrace);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
        return true;
    }

    public void populateEnsemble(Ensemble ensemble, int[] indices, int indexCount, boolean bGetHeaders, boolean bGetData) throws Exception {
    }
}

