/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Math.Grid3D;

public class TraceTable_Scanner_ExtractCMP
extends TraceTable_ScannerBase {
    protected Grid3D m_grid = null;
    protected int m_index = -9999;

    @Override
    public void finishScan() throws Exception {
        try {
            float v;
            double y;
            double x;
            int n;
            this.m_grid.interp_Finish(1);
            String columnName = "CMPVAL";
            Table_Abstract table = this.m_project.receiverTable();
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_append(columnName, DataType.Double);
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                v = this.m_grid.getNearestValue(x, y);
                table.putDouble(n, indexV, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(table, columnName);
            table = this.m_project.shotTable();
            indexX = table.column_indexOfColumn("Easting");
            indexY = table.column_indexOfColumn("Northing");
            indexV = table.column_append(columnName, DataType.Double);
            for (n = 0; n < table.row_count(); ++n) {
                x = table.getDouble(n, indexX);
                y = table.getDouble(n, indexY);
                v = this.m_grid.getNearestValue(x, y);
                table.putDouble(n, indexV, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(table, columnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_grid == null) {
                this.m_grid = this.m_project.getSmootherGrid();
                this.m_grid.interp_ZeroArrays();
                this.m_index = this.m_traceTable.column_indexOfColumn("cmpstaticapp");
            }
            float v = this.m_traceTable.getFloat(this.m_traceRow, this.m_index);
            this.m_grid.interp_Add(this.m_midX, this.m_midY, v, 1.0f);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

