/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Data.TraceTable.TraceTable_ScannerBase;
import com.PecosLibrary.Math.Grid3D;

public class TraceTable_ComputeEnergyV0
extends TraceTable_ScannerBase {
    protected int m_indexEnergy;
    protected String m_colName;
    protected Grid3D m_grid;
    protected double m_maxOff;

    public TraceTable_ComputeEnergyV0(ITraceTable traceTable, String energyCol, String colNameV0, double maxOff, double gridSize, Grid3D grid) throws Exception {
        try {
            this.m_indexEnergy = traceTable.column_exists(energyCol) ? traceTable.column_indexOfColumn(energyCol) : -999;
            this.m_colName = colNameV0;
            this.m_grid = grid;
            this.m_grid.interp_Prep();
            this.m_maxOff = maxOff;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Grid3D grid() {
        return this.m_grid;
    }

    @Override
    public void finishScan() throws Exception {
        try {
            this.m_grid.interp_Finish(3);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copyToTables() throws Exception {
        try {
            float v;
            double y;
            double x;
            int row;
            int indexV0 = this.m_shotTable.column_append(this.m_colName, DataType.Double);
            for (row = 0; row < this.m_shotTable.row_count(); ++row) {
                x = this.m_shotTable.getDouble(row, this.m_indexShotX);
                y = this.m_shotTable.getDouble(row, this.m_indexShotY);
                v = this.m_grid.getNearestValue(x, y);
                this.m_shotTable.putDouble(row, indexV0, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_shotTable, this.m_colName);
            indexV0 = this.m_recTable.column_append(this.m_colName, DataType.Double);
            for (row = 0; row < this.m_recTable.row_count(); ++row) {
                x = this.m_recTable.getDouble(row, this.m_indexRecX);
                y = this.m_recTable.getDouble(row, this.m_indexRecY);
                v = this.m_grid.getNearestValue(x, y);
                this.m_recTable.putDouble(row, indexV0, v);
            }
            this.m_project.geometryDatabase().writeColumnContentsToDatabase(this.m_recTable, this.m_colName);
            this.m_project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void work() throws Exception {
        try {
            if (this.m_indexEnergy < 0) {
                return;
            }
            float energy = this.m_traceTable.getFloat(this.m_traceRow, this.m_indexEnergy);
            if (this.m_offset > this.m_maxOff) {
                return;
            }
            if (energy < 0.0f) {
                return;
            }
            this.m_grid.interp_Add(this.m_midX, this.m_midY, energy, 1.0f);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

