/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography.VNS;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_Exporter;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;

public class Action_TomoVNS_ExportSegy
extends Action_Base {
    public double[] X = new double[3];
    public double[] Y = new double[3];
    public int[] Inline = new int[3];
    public int[] Crossline = new int[3];
    public double TopDatum = 0.0;
    public double BottomDatum = 0.0;
    public double Size = 25.0;
    public String FileName = "";
    public boolean ExportVelocity = false;
    public boolean ExportCounts = false;
    public boolean UseProjectGrid = false;
    public boolean UseUserGrid = false;

    public Action_TomoVNS_ExportSegy() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Export tomo model";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (this.UseProjectGrid) {
                return this.work_projectgrid(messageServer);
            }
            if (this.UseUserGrid) {
                return this.work_usergrid(messageServer);
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Tomo_VNS tomo = project.getTomo_VNS();
            int numSamples = (int)(1.5 + (this.TopDatum - this.BottomDatum) / this.Size);
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.setUnits(project.units_feet());
            exporter.FileName = this.FileName;
            exporter.OutputDigi = (float)this.Size;
            exporter.OutputSampleCount = numSamples;
            exporter.OutputDigiScalar = 1.0f;
            float[] vel = new float[numSamples];
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 208, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 212, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Int, DataType.Int, 228, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SampleInterval", DataType.Short, DataType.Short, 116, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SamplesPerTrace", DataType.Short, DataType.Short, 114, Segy_Dictionary.Modification.None, 1);
            exporter.prepareFile();
            float[][][] slowness = tomo.slowness();
            float[][][] count = tomo.count();
            float[][] elev = tomo.surfaceElevation();
            float[] nodeDepth = tomo.nodeDepth();
            int numNodes = nodeDepth.length;
            float[] nodeElevation = new float[numNodes];
            for (int ix = 0; ix < tomo.numX(); ++ix) {
                this.PercentDone = 100.0 * (double)ix / (double)tomo.numX();
                Ensemble ensemble = new Ensemble();
                int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Float);
                int indexInterval = ensemble.dictionary().addEntry("Trace", "SampleInterval", DataType.Short);
                int indexSamples = ensemble.dictionary().addEntry("Trace", "SamplesPerTrace", DataType.Short);
                for (int iy = 0; iy < tomo.numY(); ++iy) {
                    FloatArrayWrapper data;
                    float elevation;
                    EnsembleTrace trace = ensemble.addTrace();
                    tomo.setGridLocation(ix, iy);
                    float surfaceElev = elev[ix][iy];
                    for (int n = 0; n < numNodes; ++n) {
                        nodeElevation[n] = surfaceElev - nodeDepth[n];
                    }
                    Grid3D grid = project.getEmptyGrid3D();
                    int inline = grid.getInline(tomo.WorldX, tomo.WorldY);
                    int crossline = grid.getCrossline(tomo.WorldX, tomo.WorldY);
                    trace.header().putInt(indexInline, inline);
                    trace.header().putInt(indexCrossline, crossline);
                    trace.header().putDouble(indexX, tomo.WorldX);
                    trace.header().putDouble(indexY, tomo.WorldY);
                    trace.header().putDouble(indexZ, surfaceElev);
                    trace.header().putInt(indexInterval, (int)this.Size);
                    trace.header().putInt(indexSamples, numSamples);
                    if (this.ExportCounts) {
                        float[] hit = count[ix][iy];
                        for (int n = 0; n < numSamples; ++n) {
                            elevation = (float)(this.TopDatum - (double)n * this.Size);
                            vel[n] = this.extract(nodeElevation, hit, elevation);
                        }
                        data = trace.data();
                        data.setSampleInterval((float)this.Size);
                        data.insertArray(vel, numSamples);
                    }
                    if (!this.ExportVelocity) continue;
                    float[] slow = slowness[ix][iy];
                    for (int n = 0; n < numSamples; ++n) {
                        elevation = (float)(this.TopDatum - (double)n * this.Size);
                        vel[n] = 1000.0f / this.extract(nodeElevation, slow, elevation);
                    }
                    data = trace.data();
                    data.setSampleInterval((float)this.Size);
                    data.insertArray(vel, numSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean work_projectgrid(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D();
            int iInlineIncrement = 1;
            int iCrosslineIncrement = 1;
            int iFirstInline = grid.inlineMin();
            int iFirstCrossline = grid.crosslineMin();
            int nCrosslines = grid.numCrossline();
            Tomo_VNS tomo = project.getTomo_VNS();
            int numSamples = (int)(1.5 + (this.TopDatum - this.BottomDatum) / this.Size);
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.setUnits(project.units_feet());
            exporter.FileName = this.FileName;
            exporter.OutputDigi = (float)this.Size;
            exporter.OutputSampleCount = numSamples;
            exporter.OutputDigiScalar = 1.0f;
            float[] vel = new float[numSamples];
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 208, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 212, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CDP", DataType.Int, DataType.Int, 20, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Int, DataType.Int, 228, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SampleInterval", DataType.Short, DataType.Short, 116, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SamplesPerTrace", DataType.Short, DataType.Short, 114, Segy_Dictionary.Modification.None, 1);
            exporter.prepareFile();
            float[] nodeDepth = tomo.nodeDepth();
            int numNodes = nodeDepth.length;
            float[] nodeElevation = new float[numNodes];
            for (int i = grid.inlineMin(); i <= grid.inlineMax(); ++i) {
                this.PercentDone = 100.0 * (double)(i - grid.inlineMin()) / (double)grid.numInline();
                Ensemble ensemble = new Ensemble();
                int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexCDP = ensemble.dictionary().addEntry("Trace", "CDP", DataType.Int);
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Float);
                int indexInterval = ensemble.dictionary().addEntry("Trace", "SampleInterval", DataType.Short);
                int indexSamples = ensemble.dictionary().addEntry("Trace", "SamplesPerTrace", DataType.Short);
                for (int c = grid.crosslineMin(); c < grid.crosslineMax(); ++c) {
                    FloatArrayWrapper data;
                    float elevation;
                    EnsembleTrace trace = ensemble.addTrace();
                    int cdp = (i - iFirstInline) / iInlineIncrement * nCrosslines + (c - iFirstCrossline) / iCrosslineIncrement + 1;
                    double x = grid.getWorldX(i, c);
                    double y = grid.getWorldY(i, c);
                    tomo.setWorldLocation(x, y, true, true, true, true);
                    nodeElevation = tomo.InterpolatedNodeZ;
                    trace.header().putDouble(indexX, tomo.WorldX);
                    trace.header().putDouble(indexY, tomo.WorldY);
                    trace.header().putInt(indexInline, i);
                    trace.header().putInt(indexCrossline, c);
                    trace.header().putInt(indexCDP, cdp);
                    trace.header().putDouble(indexZ, nodeElevation[0]);
                    trace.header().putInt(indexInterval, (int)this.Size);
                    trace.header().putInt(indexSamples, numSamples);
                    if (this.ExportCounts) {
                        float[] hit = tomo.InterpolatedCount;
                        for (int n = 0; n < numSamples; ++n) {
                            elevation = (float)(this.TopDatum - (double)n * this.Size);
                            vel[n] = this.extract(nodeElevation, hit, elevation);
                        }
                        data = trace.data();
                        data.setSampleInterval((float)this.Size);
                        data.insertArray(vel, numSamples);
                    }
                    if (!this.ExportVelocity) continue;
                    float[] slow = tomo.InterpolatedSlowness;
                    for (int n = 0; n < numSamples; ++n) {
                        elevation = (float)(this.TopDatum - (double)n * this.Size);
                        vel[n] = 1000.0f / this.extract(nodeElevation, slow, elevation);
                    }
                    data = trace.data();
                    data.setSampleInterval((float)this.Size);
                    data.insertArray(vel, numSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean work_usergrid(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            int crosslineInc = this.Crossline[1] - this.Crossline[0];
            if (crosslineInc <= 1) {
                return false;
            }
            double dxc = (this.X[1] - this.X[0]) / (double)crosslineInc;
            double dyc = (this.Y[1] - this.Y[0]) / (double)crosslineInc;
            int inlineInc = this.Inline[2] - this.Inline[0];
            if (inlineInc <= 1) {
                return false;
            }
            double dxi = (this.X[2] - this.X[0]) / (double)inlineInc;
            double dyi = (this.Y[2] - this.Y[0]) / (double)inlineInc;
            Tomo_VNS tomo = project.getTomo_VNS();
            int numSamples = (int)(1.5 + (this.TopDatum - this.BottomDatum) / this.Size);
            Segy_Exporter exporter = new Segy_Exporter();
            exporter.setUnits(project.units_feet());
            exporter.FileName = this.FileName;
            exporter.OutputDigi = (float)this.Size;
            exporter.OutputSampleCount = numSamples;
            exporter.OutputDigiScalar = 1.0f;
            float[] vel = new float[numSamples];
            exporter.Dictionary = new Segy_Dictionary();
            exporter.Dictionary.addEntry("Trace", "Inline", DataType.Int, DataType.Int, 208, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Crossline", DataType.Int, DataType.Int, 212, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CDP", DataType.Int, DataType.Int, 20, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpX", DataType.Int, DataType.Int, 200, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "CdpY", DataType.Int, DataType.Int, 204, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "Elevation", DataType.Int, DataType.Int, 228, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SampleInterval", DataType.Short, DataType.Short, 116, Segy_Dictionary.Modification.None, 1);
            exporter.Dictionary.addEntry("Trace", "SamplesPerTrace", DataType.Short, DataType.Short, 114, Segy_Dictionary.Modification.None, 1);
            exporter.prepareFile();
            float[] nodeDepth = tomo.nodeDepth();
            int numNodes = nodeDepth.length;
            float[] nodeElevation = new float[numNodes];
            for (int i = this.Inline[0]; i <= this.Inline[2]; ++i) {
                double x0 = this.X[0] + (double)(i - this.Inline[0]) * dxi;
                double y0 = this.Y[0] + (double)(i - this.Inline[0]) * dyi;
                this.PercentDone = 100.0 * (double)(i - this.Inline[0]) / (double)inlineInc;
                Ensemble ensemble = new Ensemble();
                int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
                int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
                int indexCDP = ensemble.dictionary().addEntry("Trace", "CDP", DataType.Int);
                int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Int);
                int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Int);
                int indexZ = ensemble.dictionary().addEntry("Trace", "Elevation", DataType.Float);
                int indexInterval = ensemble.dictionary().addEntry("Trace", "SampleInterval", DataType.Short);
                int indexSamples = ensemble.dictionary().addEntry("Trace", "SamplesPerTrace", DataType.Short);
                for (int c = this.Crossline[0]; c < this.Crossline[1]; ++c) {
                    FloatArrayWrapper data;
                    float elevation;
                    EnsembleTrace trace = ensemble.addTrace();
                    int cdp = (i - this.Inline[0]) * (crosslineInc + 1) + (c - this.Crossline[0]) + 1;
                    double x = x0 + (double)(c - this.Crossline[0]) * dxc;
                    double y = y0 + (double)(c - this.Crossline[0]) * dyc;
                    tomo.setWorldLocation(x, y, true, true, true, true);
                    nodeElevation = tomo.InterpolatedNodeZ;
                    trace.header().putDouble(indexX, tomo.WorldX);
                    trace.header().putDouble(indexY, tomo.WorldY);
                    trace.header().putInt(indexInline, i);
                    trace.header().putInt(indexCrossline, c);
                    trace.header().putInt(indexCDP, cdp);
                    trace.header().putDouble(indexZ, nodeElevation[0]);
                    trace.header().putInt(indexInterval, (int)this.Size);
                    trace.header().putInt(indexSamples, numSamples);
                    if (this.ExportCounts) {
                        float[] hit = tomo.InterpolatedCount;
                        for (int n = 0; n < numSamples; ++n) {
                            elevation = (float)(this.TopDatum - (double)n * this.Size);
                            vel[n] = this.extract(nodeElevation, hit, elevation);
                        }
                        data = trace.data();
                        data.setSampleInterval((float)this.Size);
                        data.insertArray(vel, numSamples);
                    }
                    if (!this.ExportVelocity) continue;
                    float[] slow = tomo.InterpolatedSlowness;
                    for (int n = 0; n < numSamples; ++n) {
                        elevation = (float)(this.TopDatum - (double)n * this.Size);
                        vel[n] = 1000.0f / this.extract(nodeElevation, slow, elevation);
                    }
                    data = trace.data();
                    data.setSampleInterval((float)this.Size);
                    data.insertArray(vel, numSamples);
                }
                exporter.appendEnsemble(ensemble, false);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected float extract(float[] nodeZ, float[] nodeV, float z) {
        try {
            int len = nodeZ.length;
            if (z >= nodeZ[0]) {
                return nodeV[0];
            }
            if (z <= nodeZ[len - 1]) {
                return nodeV[len - 1];
            }
            for (int n = 0; n < len - 1; ++n) {
                if (!(z <= nodeZ[n]) || !(z >= nodeZ[n + 1])) continue;
                float alpha = (nodeZ[n] - z) / (nodeZ[n] - nodeZ[n + 1]);
                float v = (1.0f - alpha) * nodeV[n] + alpha * nodeV[n + 1];
                return v;
            }
            return nodeV[len - 1];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return nodeV[0];
        }
    }

    protected double extract(double[] nodeZ, double[] nodeV, float z) {
        try {
            int len = nodeZ.length;
            if ((double)z >= nodeZ[0]) {
                return nodeV[0];
            }
            if ((double)z <= nodeZ[len - 1]) {
                return nodeV[len - 1];
            }
            for (int n = 0; n < len - 1; ++n) {
                if (!((double)z <= nodeZ[n]) || !((double)z >= nodeZ[n + 1])) continue;
                double alpha = (nodeZ[n] - (double)z) / (nodeZ[n] - nodeZ[n + 1]);
                float v = (float)((1.0 - alpha) * nodeV[n] + alpha * nodeV[n + 1]);
                return v;
            }
            return nodeV[len - 1];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return nodeV[0];
        }
    }

    protected double extract(float[] nodeZ, double[] nodeV, float z) {
        try {
            int len = nodeZ.length;
            if (z >= nodeZ[0]) {
                return nodeV[0];
            }
            if (z <= nodeZ[len - 1]) {
                return nodeV[len - 1];
            }
            for (int n = 0; n < len - 1; ++n) {
                if (!(z <= nodeZ[n]) || !(z >= nodeZ[n + 1])) continue;
                float alpha = (nodeZ[n] - z) / (nodeZ[n] - nodeZ[n + 1]);
                float v = (float)((double)(1.0f - alpha) * nodeV[n] + (double)alpha * nodeV[n + 1]);
                return v;
            }
            return nodeV[len - 1];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return nodeV[0];
        }
    }
}

