/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import java.util.ArrayList;

public class Action_Eikonal_DiskBased
extends Action_Base {
    public int NumThreads = 2;
    public int NumIter = 10;
    public double MaxOffset = 12000.0;
    public double MinOffset = 0.0;
    public double OffsetCorner = 1000.0;
    public int SmoothRadius = 3;
    public boolean SaveAfterEachIter = false;
    public String PickVersion = "FBP_User";
    public double PickShift = 0.0;
    public TomoEikonal3D Model;
    public boolean ApplyAzimuthLimits = false;
    public double AzimuthCenter = 0.0;
    public double AzimuthRadius = 0.7853981633974483;
    public boolean ComputeHybridTimeShifts = false;
    public double HybridLMOVelocity = 20000.0;
    public double HybridTimeShifts = 200.0;
    public boolean ApplyDecimation = false;
    public int Decimation = 1;
    public boolean Uphole_LockShallow = false;
    public String Uphole_Table = "";
    public String Uphole_X = "";
    public String Uphole_Y = "";
    public String Uphole_Z = "";
    public String Uphole_V = "";

    public Action_Eikonal_DiskBased() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "3D Eikonal model update";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
        this.DelayTimeDataModified = false;
    }

    protected HashMap_Integers<TomoEikonal3D.Element> finishMap(Table_Abstract table, String colNameID, HashMap_Integers<TomoEikonal3D.Element> map) {
        try {
            HashMap_Integers<TomoEikonal3D.Element> newMap = new HashMap_Integers<TomoEikonal3D.Element>();
            int index = table.column_indexOfColumn(colNameID);
            for (TomoEikonal3D.Element e : map.getValues()) {
                e.ID = table.getInt(e.ID, index);
                e.Residual /= e.Count;
                e.Error /= e.Count;
                e.ComputedResidual = e.Residual;
                newMap.put(e, e.ID);
            }
            return newMap;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            long startTime = System.currentTimeMillis();
            if (this.Uphole_LockShallow) {
                try {
                    IDatabaseConnection dc = project.importDatabase();
                    String sql = String.format("SELECT * FROM %s", this.Uphole_Table);
                    Table_Abstract table = dc.extractTableDataUsingQuery(this.Uphole_Table, sql, 1000000);
                    this.Model.createInterpolatedGrid("UpholeVelocity", table, this.Uphole_X, this.Uphole_Y, this.Uphole_V);
                    this.Model.createInterpolatedGrid("UpholeElevation", table, this.Uphole_X, this.Uphole_Y, this.Uphole_Z);
                }
                catch (Exception uex) {
                    uex.printStackTrace();
                    this.Uphole_LockShallow = false;
                }
            }
            ++this.NumIter;
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            int indexPick = traceTable.column_indexOfColumn(this.PickVersion);
            int indexKilled = traceTable.column_indexOfColumn("Killed");
            double totalTraces = (long)this.NumIter * traceTable.rowCount();
            double traceCount = 0.0;
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexShotDead = shotTable.column_indexOfColumn("Killed");
            int indexShotDepth = -9999;
            if (shotTable.column_exists("PointDepth")) {
                indexShotDepth = shotTable.column_indexOfColumn("PointDepth");
            }
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecZ = recTable.column_indexOfColumn("Elevation");
            int indexRecDead = recTable.column_indexOfColumn("Killed");
            AzimuthSelector azimuthSelector = new AzimuthSelector();
            azimuthSelector.setLimits(this.AzimuthCenter, this.AzimuthRadius, true);
            this.ComputeHybridTimeShifts = this.ComputeHybridTimeShifts && traceTable.column_exists("FBP_Back3");
            this.HybridLMOVelocity = Math.max(this.HybridLMOVelocity, 100.0);
            this.HybridTimeShifts = Math.max(this.HybridTimeShifts, 100.0);
            int indexHybrid = -9999;
            if (this.ComputeHybridTimeShifts) {
                indexHybrid = traceTable.column_indexOfColumn("FBP_Back3");
            }
            messageServer.setMessage_Level1(String.format("Counting valid picks", new Object[0]));
            int numValid = 0;
            int numOkay = 0;
            this.ApplyDecimation = this.ApplyDecimation && this.Decimation >= 2;
            long twobillion = 2000000000L;
            ArrayList<ThreadData> m_threadDataList = new ArrayList<ThreadData>();
            ThreadData td = null;
            int picksAddedToCurrentThread = 0;
            int numPicksperThread = 0;
            int threadIndex = 0;
            double decimationMinOffset = this.MaxOffset / 4.0;
            for (int pass = 0; pass <= 1; ++pass) {
                numValid = 0;
                for (long row = 0L; row < traceTable.rowCount() && !this.Halt; ++row) {
                    if (indexHybrid >= 0) {
                        traceTable.putFloat(row, indexHybrid, -9999.0f);
                    }
                    int shotID = traceTable.getInt(row, indexShotID);
                    int recID = traceTable.getInt(row, indexRecID);
                    int killed = traceTable.getInt(row, indexKilled);
                    if (!shotMap.containsKey(shotID) || !recMap.containsKey(recID)) continue;
                    int shotRow = shotMap.get(shotID);
                    int recRow = recMap.get(recID);
                    float pick = traceTable.getFloat(row, indexPick) + (float)this.PickShift;
                    if (!(pick >= 20.0f) || killed != 0 || shotTable.getBool(shotRow, indexShotDead) || recTable.getBool(recRow, indexRecDead)) continue;
                    double sx = shotTable.getDouble(shotRow, indexShotX);
                    double sy = shotTable.getDouble(shotRow, indexShotY);
                    double sz = shotTable.getDouble(shotRow, indexShotZ);
                    double sd = 0.0;
                    if (indexShotDepth >= 0) {
                        sd = shotTable.getDouble(shotRow, indexShotDepth);
                    }
                    double rx = recTable.getDouble(recRow, indexRecX);
                    double ry = recTable.getDouble(recRow, indexRecY);
                    double rz = recTable.getDouble(recRow, indexRecZ);
                    double dx = sx - rx;
                    double dy = sy - ry;
                    double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                    boolean azimuthOkay = true;
                    if (this.ApplyAzimuthLimits && off > 0.0) {
                        double az = Math.atan2(dy, dx);
                        azimuthOkay = azimuthSelector.accept(az);
                    }
                    if (!azimuthOkay || !(off > this.MinOffset) || !(off < this.MaxOffset)) continue;
                    boolean addToThread = false;
                    if (!this.ApplyDecimation || off < decimationMinOffset) {
                        boolean bl = addToThread = pass == 1;
                        if (pass == 0) {
                            ++numValid;
                        }
                    } else {
                        if (numOkay % this.Decimation == 0) {
                            boolean bl = addToThread = pass == 1;
                            if (pass == 0) {
                                ++numValid;
                            }
                        }
                        ++numOkay;
                    }
                    if (!addToThread) continue;
                    td.addPick(pick, shotRow, recRow, row);
                    if (++picksAddedToCurrentThread >= numPicksperThread) {
                        td.finishedAddingPicks();
                        if (++threadIndex < this.NumThreads) {
                            td = (ThreadData)m_threadDataList.get(threadIndex);
                        }
                        picksAddedToCurrentThread = 0;
                    }
                    ++numValid;
                }
                if (pass == 1 && picksAddedToCurrentThread >= 1) {
                    td.finishedAddingPicks();
                }
                if (pass != 0) continue;
                numPicksperThread = 20 + numValid / this.NumThreads;
                for (int n = 0; n < this.NumThreads; ++n) {
                    td = new ThreadData(n, this.Model, numPicksperThread);
                    m_threadDataList.add(td);
                }
                threadIndex = 0;
                td = (ThreadData)m_threadDataList.get(threadIndex);
            }
            if (this.Halt) {
                return false;
            }
            System.gc();
            System.gc();
            if (this.Halt) {
                return false;
            }
            long totalValidTraces = 1L + (long)numValid * (long)this.NumIter;
            if (this.Model.getHistory() != null) {
                this.Model.getHistory().addWithTime("Begin batch update");
                this.Model.getHistory().add("Minimum offset = " + Double.toString(this.MinOffset));
                this.Model.getHistory().add("Maximum offset = " + Double.toString(this.MaxOffset));
                this.Model.getHistory().add("Offset corner = " + Double.toString(this.OffsetCorner));
                this.Model.getHistory().add("Num threads = " + Integer.toString(this.NumThreads));
                this.Model.getHistory().add("Smooth radius = " + Integer.toString(this.SmoothRadius));
                this.Model.getHistory().add("Pick version = " + this.PickVersion);
                if (!this.ApplyDecimation || this.Decimation <= 1) {
                    this.Model.getHistory().add("Picks not decimated");
                } else {
                    this.Model.getHistory().add("Decimation = " + Integer.toString(this.Decimation));
                }
            }
            HashMap_Integers<TomoEikonal3D.Element> srcHash = new HashMap_Integers<TomoEikonal3D.Element>();
            HashMap_Integers<TomoEikonal3D.Element> recHash = new HashMap_Integers<TomoEikonal3D.Element>();
            for (int iter = 1; iter <= this.NumIter && !this.Halt; ++iter) {
                messageServer.setMessage_Level1(String.format("Working on iteration %d of %d", iter, this.NumIter));
                if (iter == this.NumIter) {
                    messageServer.setMessage_Level1(String.format("Compute residuals: iteration %d of %d", iter, this.NumIter));
                }
                long currTime = System.currentTimeMillis();
                for (ThreadData threadData : m_threadDataList) {
                    threadData.Iteration = iter;
                    threadData.NumIter = this.NumIter;
                }
                if (iter < this.NumIter) {
                    this.Model.prepUpdate();
                    this.Model.WeightTime = 100.0f - 10.0f * (float)iter;
                    this.Model.WeightTime = Math.max(this.Model.WeightTime, 10.0f);
                    if (this.Uphole_LockShallow) {
                        this.Model.applyUpholeVelocityLayer("UpholeElevation", "UpholeVelocity");
                    }
                    for (ThreadData threadData : m_threadDataList) {
                        threadData.ThreadModel.copySlownessFromParent(this.Model);
                        threadData.ThreadModel.prepUpdate();
                        threadData.ThreadModel.WeightTime = this.Model.WeightTime;
                    }
                }
                ArrayList<LocalThread> threads = new ArrayList<LocalThread>();
                for (ThreadData threadData : m_threadDataList) {
                    threads.add(new LocalThread(threadData));
                }
                for (LocalThread lt : threads) {
                    lt.start();
                }
                System.out.println("Threads started...");
                for (LocalThread lt : threads) {
                    if (lt.isAlive()) continue;
                    System.out.println("THREAD NOT ALIVE!?!?!?");
                }
                boolean keepLooping = true;
                while (keepLooping) {
                    long checkTime;
                    keepLooping = false;
                    for (LocalThread lt : threads) {
                        keepLooping = keepLooping || lt.isAlive();
                    }
                    if (keepLooping) {
                        Thread.sleep(100L);
                    }
                    if ((checkTime = System.currentTimeMillis()) - currTime <= 1000L) continue;
                    long total = 0L;
                    for (ThreadData threadData : m_threadDataList) {
                        total += threadData.TotalTraces;
                    }
                    double percent = 100.0 * (double)total / (double)totalValidTraces;
                    messageServer.setPercentDone(percent);
                    currTime = checkTime;
                }
                System.out.println("Threads finished");
                if (iter < this.NumIter) {
                    for (ThreadData threadData : m_threadDataList) {
                        threadData.ThreadModel.updateParentWeightAndError(this.Model);
                    }
                    if (!this.Halt) {
                        float extrapolateDown = 1.04f;
                        float extrapolateUp = 0.96f;
                        float fractionCoarse = 0.5f;
                        int smoothH = 10;
                        int smoothZ = 1;
                        float maxPercentChange = 20.0f;
                        if (iter >= 2) {
                            extrapolateDown = 1.015f;
                            extrapolateUp = 0.985f;
                            smoothH = 8;
                            maxPercentChange = 15.0f;
                        }
                        if (iter >= 6) {
                            fractionCoarse = 0.5f;
                            extrapolateDown = 1.005f;
                            extrapolateUp = 0.995f;
                            smoothH = this.SmoothRadius;
                            smoothZ = 0;
                            maxPercentChange = 10.0f;
                        }
                        if (iter < this.NumIter) {
                            this.Model.finishUpdate(smoothH, smoothZ, extrapolateDown, extrapolateUp, fractionCoarse, this.NumIter, iter, maxPercentChange);
                        }
                        if (this.SaveAfterEachIter) {
                            this.Model.save(this.Model.name());
                        }
                    }
                    float frac = 1.015f - (float)iter * 0.013999939f / (float)this.NumIter;
                    this.Model.forceIncreasingVelocity(frac);
                    if (this.Uphole_LockShallow) {
                        this.Model.applyUpholeVelocityLayer("UpholeElevation", "UpholeVelocity");
                    }
                    this.Model.prepWaterVelocity();
                }
                double sumAvgError = 0.0;
                for (ThreadData threadData : m_threadDataList) {
                    sumAvgError += threadData.AverageError;
                }
                if (this.Model.getHistory() != null) {
                    String s = String.format("Iter %d, error = %f", iter, sumAvgError / (double)m_threadDataList.size());
                    this.Model.getHistory().addWithTimeNoSpace(s);
                }
                this.Model.prepWaterVelocity();
                this.Model.save(this.Model.name());
                this.Model.getHistory().save();
            }
            this.Model.freeInterpolator();
            if (!this.Halt) {
                for (ThreadData threadData : m_threadDataList) {
                    threadData.updateParentHash(recHash, threadData.RecHash);
                    threadData.updateParentHash(srcHash, threadData.SrcHash);
                }
                this.Model.SourceHash = this.finishMap(shotTable, "ShotID", srcHash);
                this.Model.ReceiverHash = this.finishMap(recTable, "ReceiverID", recHash);
                this.Model.save(this.Model.name());
                this.Model.writeResidualsToDatabase();
            }
            if (!this.Halt && this.ComputeHybridTimeShifts) {
                try {
                    for (int t = 0; t < m_threadDataList.size(); ++t) {
                        td = (ThreadData)m_threadDataList.get(t);
                        for (long n = 0L; n < td.TempTraceTable.rowCount(); ++n) {
                            int hybrid = td.TempTraceTable.getInt(n, td.IndexHybrid);
                            long big = td.TempTraceTable.getInt(n, td.IndexRowBig);
                            long small = td.TempTraceTable.getInt(n, td.IndexRowSmall);
                            long row = small + big * 1000000L;
                            traceTable.putFloat(row, indexHybrid, hybrid);
                        }
                    }
                    traceTable.saveCurrentSection();
                }
                catch (Exception errr) {
                    errr.printStackTrace();
                }
            }
            if (this.Model.getHistory() != null) {
                if (!this.Halt) {
                    this.Model.getHistory().add("End batch update");
                    long totalTime = System.currentTimeMillis() - startTime;
                    String timeMessage = Tools_Strings.runTimeMessage((int)totalTime / 1000);
                    this.Model.getHistory().add("Total time = " + timeMessage);
                } else {
                    this.Model.getHistory().add("Batch update HALTED");
                }
                this.Model.getHistory().save();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected class ThreadData {
        public TomoEikonal3D ThreadModel;
        public TomoEikonal3DProfile Profile;
        public int ID;
        public long TotalTraces = 0L;
        public Table_Abstract ShotTable;
        public int ShotIndexX;
        public int ShotIndexY;
        public int ShotIndexZ;
        public int ShotIndexDepth = -9999;
        public Table_Abstract ReceiverTable;
        public int ReceiverIndexX;
        public int ReceiverIndexY;
        public int ReceiverIndexZ;
        public int ReceiverIndexDepth = -9999;
        public TraceTable_Huge TempTraceTable;
        public Table_Abstract TempDiskTable = new Table_Memory();
        public String DiskPath;
        public int IndexRowBig;
        public int IndexRowSmall;
        public int IndexShotRow;
        public int IndexReceiverRow;
        public int IndexPick;
        public int IndexHybrid;
        public HashMap_Integers<TomoEikonal3D.Element> SrcHash = new HashMap_Integers();
        public HashMap_Integers<TomoEikonal3D.Element> RecHash = new HashMap_Integers();
        public int Iteration;
        public int NumIter;
        public double SumError;
        public double AverageError;
        public double ErrorCount;

        public ThreadData(int id, TomoEikonal3D parentModel, int maxPickCount) {
            try {
                this.DiskPath = Tools_FileSystem.confirmSubDirectoryExists(Action_Eikonal_DiskBased.this.SandboxPath, "Trace" + Integer.toString(id));
                this.IndexRowBig = this.TempDiskTable.column_append("Big", DataType.Int);
                this.IndexRowSmall = this.TempDiskTable.column_append("Small", DataType.Int);
                this.IndexPick = this.TempDiskTable.column_append("Pick", DataType.Float);
                this.IndexHybrid = this.TempDiskTable.column_append("Hybrid", DataType.Int);
                this.IndexShotRow = this.TempDiskTable.column_append("Shot", DataType.Int);
                this.IndexReceiverRow = this.TempDiskTable.column_append("Receiver", DataType.Int);
                this.TempTraceTable = new TraceTable_Huge(this.DiskPath, "Trace", this.TempDiskTable, 1);
                this.ID = id;
                this.ThreadModel = new TomoEikonal3D(parentModel);
                this.Profile = this.ThreadModel.createNewProfile();
                maxPickCount = 100 + Math.max(maxPickCount, 1000);
                RefractionStaticsProject project = RefractionStaticsProject.singleton();
                this.ReceiverTable = project.receiverTable();
                this.ReceiverIndexX = this.ReceiverTable.column_indexOfColumn("Easting");
                this.ReceiverIndexY = this.ReceiverTable.column_indexOfColumn("Northing");
                this.ReceiverIndexZ = this.ReceiverTable.column_indexOfColumn("Elevation");
                if (this.ReceiverTable.column_exists("PointDepth")) {
                    this.ReceiverIndexDepth = this.ReceiverTable.column_indexOfColumn("PointDepth");
                }
                this.ShotTable = project.shotTable();
                this.ShotIndexX = this.ShotTable.column_indexOfColumn("Easting");
                this.ShotIndexY = this.ShotTable.column_indexOfColumn("Northing");
                this.ShotIndexZ = this.ShotTable.column_indexOfColumn("Elevation");
                if (this.ShotTable.column_exists("PointDepth")) {
                    this.ShotIndexDepth = this.ShotTable.column_indexOfColumn("PointDepth");
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void addPick(float pick, int shotRow, int recRow, long traceRow) {
            try {
                long big = traceRow / 1000000L;
                long small = traceRow - big * 1000000L;
                int r = this.TempDiskTable.row_increment();
                this.TempDiskTable.putInt(r, this.IndexRowBig, (int)big);
                this.TempDiskTable.putInt(r, this.IndexRowSmall, (int)small);
                this.TempDiskTable.putInt(r, this.IndexShotRow, shotRow);
                this.TempDiskTable.putInt(r, this.IndexReceiverRow, recRow);
                this.TempDiskTable.putFloat(r, this.IndexPick, pick);
                if (this.TempDiskTable.row_count() > 50000) {
                    this.TempTraceTable.appendTable(this.TempDiskTable);
                    this.TempDiskTable.row_clear(false);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void finishedAddingPicks() {
            try {
                if (this.TempDiskTable.row_count() > 0) {
                    this.TempTraceTable.appendTable(this.TempDiskTable);
                    this.TempDiskTable.row_clear(true);
                }
                this.TempTraceTable.finishedAppending(null);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        protected void updateElement(HashMap_Integers<TomoEikonal3D.Element> map, int row, float error) {
            try {
                if (!map.containsKey(row)) {
                    map.put(new TomoEikonal3D.Element(row), row);
                }
                TomoEikonal3D.Element element = map.get(row);
                element.addError(error);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void updateParentHash(HashMap_Integers<TomoEikonal3D.Element> parent, HashMap_Integers<TomoEikonal3D.Element> map) {
            try {
                for (TomoEikonal3D.Element childElement : map.getValues()) {
                    int row = childElement.ID;
                    if (!parent.containsKey(row)) {
                        parent.put(new TomoEikonal3D.Element(row), row);
                    }
                    TomoEikonal3D.Element parentElement = parent.get(row);
                    parentElement.Count += childElement.Count;
                    parentElement.Error += childElement.Error;
                    parentElement.Residual += childElement.Residual;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void run() {
            try {
                this.SrcHash.clear();
                this.RecHash.clear();
                System.out.println("run started for ID = " + this.ID);
                int zSpray = 2;
                if (this.Iteration >= 4) {
                    zSpray = 2;
                }
                if (this.Iteration >= 6) {
                    zSpray = 2;
                }
                float scalarSprayZ = 0.5f;
                if (this.Iteration >= 4) {
                    scalarSprayZ = 0.4f;
                }
                this.AverageError = 0.0;
                this.SumError = 0.0;
                this.ErrorCount = 1.0E-10;
                double straightLineTransition = 5.0 * Math.max(this.ThreadModel.binSizeHorz(), this.ThreadModel.binSizeVert());
                for (long n = 0L; n < this.TempTraceTable.rowCount() && !Action_Eikonal_DiskBased.this.Halt; ++n) {
                    ++this.TotalTraces;
                    int shotRow = this.TempTraceTable.getInt(n, this.IndexShotRow);
                    int recRow = this.TempTraceTable.getInt(n, this.IndexReceiverRow);
                    float pick = this.TempTraceTable.getFloat(n, this.IndexPick);
                    double sx = this.ShotTable.getDouble(shotRow, this.ShotIndexX);
                    double sy = this.ShotTable.getDouble(shotRow, this.ShotIndexY);
                    double sz = this.ShotTable.getDouble(shotRow, this.ShotIndexZ);
                    double sd = 0.0;
                    if (this.ShotIndexDepth >= 0) {
                        sd = this.ShotTable.getDouble(shotRow, this.ShotIndexDepth);
                    }
                    double rx = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexX);
                    double ry = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexY);
                    double rz = this.ReceiverTable.getDouble(recRow, this.ReceiverIndexZ);
                    double rd = 0.0;
                    if (this.ReceiverIndexDepth >= 0) {
                        rd = this.ReceiverTable.getDouble(shotRow, this.ReceiverIndexDepth);
                    }
                    double dx = sx - rx;
                    double dy = sy - ry;
                    double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                    double offsetWeight = Action_Eikonal_DiskBased.this.OffsetCorner / (Action_Eikonal_DiskBased.this.OffsetCorner + off);
                    offsetWeight = 100.0 * offsetWeight * offsetWeight;
                    offsetWeight = Math.max(offsetWeight, 0.01);
                    double error = 0.0;
                    if (off < straightLineTransition) {
                        this.ThreadModel.fireStraightLine(sx, sy, sz - sd, rx, ry, rz - rd);
                        error = this.ThreadModel.StraightLineTotalTime - (double)pick;
                        if (this.Iteration < this.NumIter) {
                            this.ThreadModel.updateStatisticsFromStraightLine(pick, (float)offsetWeight);
                        }
                    } else {
                        this.ThreadModel.populateProfile(this.Profile, sx, sy, rx, ry);
                        this.Profile.fireShot((float)(sz - sd));
                        this.Profile.setReceiver((float)(rz - rd), pick);
                        error = this.Profile.ReceiverTime - (double)pick;
                        if (this.Iteration < this.NumIter && this.Profile.NumPathPoints > 0) {
                            this.ThreadModel.updateStatisticsFromProfile(this.Profile, pick, (float)offsetWeight, zSpray, scalarSprayZ);
                        }
                    }
                    if (this.Iteration == this.NumIter) {
                        this.updateElement(this.SrcHash, shotRow, (float)error);
                        this.updateElement(this.RecHash, recRow, (float)error);
                    }
                    if (Action_Eikonal_DiskBased.this.ComputeHybridTimeShifts) {
                        double hybrid = Action_Eikonal_DiskBased.this.HybridTimeShifts + 1000.0 * off / Action_Eikonal_DiskBased.this.HybridLMOVelocity + error;
                        this.TempTraceTable.putInt(n, this.IndexHybrid, (int)hybrid);
                    }
                    error = Math.abs(error);
                    this.SumError += error;
                    this.ErrorCount += 1.0;
                    this.AverageError = this.SumError / this.ErrorCount;
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
            System.out.println("run finished for ID = " + this.ID);
        }
    }

    protected class LocalThread
    extends Thread {
        protected ThreadData m_td;

        public LocalThread(ThreadData td) {
            this.m_td = td;
        }

        @Override
        public void run() {
            try {
                this.m_td.run();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }
}

