/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Tomography;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.AzimuthSelector;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;

public class Action_Eikonal3D
extends Action_Base {
    public int NumIter = 10;
    public double MaxOffset = 12000.0;
    public double MinOffset = 0.0;
    public double OffsetCorner = 1000.0;
    public boolean SaveAfterEachIter = true;
    public String PickVersion = "FBP_User";
    public TomoEikonal3D Model;
    public boolean ApplyAzimuthLimits = false;
    public double AzimuthCenter = 0.0;
    public double AzimuthRadius = 0.7853981633974483;

    public Action_Eikonal3D() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "3D Eikonal model update";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = false;
    }

    protected void updateElement(HashMap_Integers<TomoEikonal3D.Element> map, int id, float error) {
        try {
            if (!map.containsKey(id)) {
                map.put(new TomoEikonal3D.Element(id), id);
            }
            TomoEikonal3D.Element element = map.get(id);
            element.addError(error);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void finishMap(HashMap_Integers<TomoEikonal3D.Element> map) {
        try {
            for (TomoEikonal3D.Element e : map.getValues()) {
                e.Residual /= e.Count;
                e.Error /= e.Count;
                e.ComputedResidual = e.Residual;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            long startTime = System.currentTimeMillis();
            ++this.NumIter;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            int indexPick = traceTable.column_indexOfColumn(this.PickVersion);
            int indexKilled = traceTable.column_indexOfColumn("Killed");
            double totalTraces = (long)this.NumIter * traceTable.rowCount();
            double traceCount = 0.0;
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexShotDead = shotTable.column_indexOfColumn("Killed");
            int indexShotDepth = -9999;
            if (shotTable.column_exists("PointDepth")) {
                indexShotDepth = shotTable.column_indexOfColumn("PointDepth");
            }
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecZ = recTable.column_indexOfColumn("Elevation");
            int indexRecDead = recTable.column_indexOfColumn("Killed");
            HashMap_Integers<TomoEikonal3D.Element> srcHash = new HashMap_Integers<TomoEikonal3D.Element>();
            HashMap_Integers<TomoEikonal3D.Element> recHash = new HashMap_Integers<TomoEikonal3D.Element>();
            TomoEikonal3DProfile profile = this.Model.createNewProfile();
            double straightLineTransition = 2.5 * this.Model.binSizeVert();
            if (this.Model.getHistory() != null) {
                this.Model.getHistory().addWithTime("Begin batch update");
                this.Model.getHistory().add("Minimum offset = " + Double.toString(this.MinOffset));
                this.Model.getHistory().add("Maximum offset = " + Double.toString(this.MaxOffset));
                this.Model.getHistory().add("Offset corner = " + Double.toString(this.OffsetCorner));
            }
            AzimuthSelector azimuthSelector = new AzimuthSelector();
            azimuthSelector.setLimits(this.AzimuthCenter, this.AzimuthRadius, true);
            this.Model.prepWaterVelocity();
            for (int iter = 1; iter <= this.NumIter && !this.Halt; ++iter) {
                messageServer.setMessage_Level1(String.format("Working on iteration %d of %d", iter, this.NumIter));
                if (iter == this.NumIter) {
                    messageServer.setMessage_Level1(String.format("Compute residuals: iteration %d of %d", iter, this.NumIter));
                }
                if (iter < this.NumIter) {
                    this.Model.prepUpdate();
                    this.Model.WeightTime = 100.0f - 10.0f * (float)iter;
                    this.Model.WeightTime = Math.max(this.Model.WeightTime, 10.0f);
                }
                int zSpray = 3;
                if (iter >= 4) {
                    zSpray = 2;
                }
                float scalarSprayZ = 0.5f;
                if (iter >= 4) {
                    scalarSprayZ = 0.3f;
                }
                double sumError = 0.0;
                double errCount = 1.0E-10;
                for (long row = 0L; row < traceTable.rowCount() && !this.Halt; ++row) {
                    int shotID = traceTable.getInt(row, indexShotID);
                    int shotRow = shotMap.get(shotID);
                    int recID = traceTable.getInt(row, indexRecID);
                    int recRow = recMap.get(recID);
                    float pick = traceTable.getFloat(row, indexPick);
                    int killed = traceTable.getInt(row, indexKilled);
                    if (pick >= 20.0f && killed == 0 && !shotTable.getBool(shotRow, indexShotDead) && !recTable.getBool(recRow, indexRecDead)) {
                        double sx = shotTable.getDouble(shotRow, indexShotX);
                        double sy = shotTable.getDouble(shotRow, indexShotY);
                        double sz = shotTable.getDouble(shotRow, indexShotZ);
                        double sd = 0.0;
                        if (indexShotDepth >= 0) {
                            sd = shotTable.getDouble(shotRow, indexShotDepth);
                        }
                        double rx = recTable.getDouble(recRow, indexRecX);
                        double ry = recTable.getDouble(recRow, indexRecY);
                        double rz = recTable.getDouble(recRow, indexRecZ);
                        double dx = sx - rx;
                        double dy = sy - ry;
                        double off = Math.sqrt(dx * dx + dy * dy + 0.01);
                        boolean azimuthOkay = true;
                        if (this.ApplyAzimuthLimits && off > 0.0) {
                            double az = Math.atan2(dy, dx);
                            azimuthOkay = azimuthSelector.accept(az);
                        }
                        if (azimuthOkay && off > this.MinOffset && off < this.MaxOffset) {
                            double offsetWeight = 10.0 * this.OffsetCorner / (this.OffsetCorner + off);
                            offsetWeight *= offsetWeight;
                            offsetWeight = Math.max(offsetWeight, 0.01);
                            if (off < straightLineTransition) {
                                this.Model.fireStraightLine(sx, sy, sz - sd, rx, ry, rz);
                                if (iter < this.NumIter) {
                                    this.Model.updateStatisticsFromStraightLine(pick, (float)offsetWeight);
                                }
                            } else {
                                this.Model.populateProfile(profile, sx, sy, rx, ry);
                                profile.fireShot((float)(sz - sd));
                                profile.setReceiver((float)rz, pick);
                                if (iter < this.NumIter && profile.NumPathPoints > 0) {
                                    this.Model.updateStatisticsFromProfile(profile, pick, (float)offsetWeight, zSpray, scalarSprayZ);
                                }
                            }
                            double error = profile.ReceiverTime - (double)pick;
                            if (iter == this.NumIter) {
                                this.updateElement(srcHash, shotID, (float)error);
                                this.updateElement(recHash, recID, (float)error);
                            }
                            error = Math.abs(error);
                            sumError += error;
                            errCount += 1.0;
                        }
                    }
                    traceCount += 1.0;
                    if (row % 10000L != 0L) continue;
                    double percent = 100.0 * traceCount / totalTraces;
                    messageServer.setPercentDone(percent);
                    String s = String.format("Average error = %f", sumError / errCount);
                    messageServer.setMessage_Level2(s);
                }
                String s = String.format("Average error = %f", sumError / errCount);
                System.out.println(s);
                if (this.Model.getHistory() != null) {
                    s = String.format("Iter %d, error = %f", iter, Float.valueOf((float)(sumError / errCount)));
                    this.Model.getHistory().addWithTimeNoSpace(s);
                }
                if (!this.Halt) {
                    float extrapolateDown = 1.04f;
                    float extrapolateUp = 0.96f;
                    int smoothH = 10;
                    int smoothZ = 1;
                    float maxPercentChange = 10.0f;
                    if (iter >= 2) {
                        extrapolateDown = 1.015f;
                        extrapolateUp = 0.985f;
                        smoothH = 8;
                    }
                    if (iter >= 4) {
                        extrapolateDown = 1.005f;
                        extrapolateUp = 0.995f;
                        smoothH = 5;
                        smoothZ = 0;
                    }
                    if (iter < this.NumIter) {
                        this.Model.finishUpdate(smoothH, smoothZ, extrapolateDown, extrapolateUp, 0.5f, this.NumIter, iter, maxPercentChange);
                    }
                    if (this.SaveAfterEachIter) {
                        this.Model.save(this.Model.name());
                    }
                }
                if (iter <= 5) {
                    this.Model.forceIncreasingVelocity(1.01f);
                }
                if (iter == 1) {
                    // empty if block
                }
                this.Model.prepWaterVelocity();
            }
            if (!this.Halt) {
                this.finishMap(srcHash);
                this.finishMap(recHash);
                this.Model.SourceHash = srcHash;
                this.Model.ReceiverHash = recHash;
                this.Model.save(this.Model.name());
                this.Model.writeResidualsToDatabase();
            }
            if (this.Model.getHistory() != null) {
                if (!this.Halt) {
                    this.Model.getHistory().add("End batch update");
                    long totalTime = System.currentTimeMillis() - startTime;
                    String timeMessage = Tools_Strings.runTimeMessage((int)totalTime / 1000);
                    this.Model.getHistory().add("Total time = " + timeMessage);
                } else {
                    this.Model.getHistory().add("Batch update HALTED");
                }
                this.Model.getHistory().save();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

