/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Stack;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Seismic.Segy.Segy_FileHeader;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_AGC;
import com.PecosLibrary.Ensemble.Worker.Amplitude.EnsembleWorker_RMS;
import com.PecosLibrary.Ensemble.Worker.Moveout.EnsembleWorker_ApplyNMO;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;

public class Action_FullStack
extends Action_Base {
    public EnsembleWorker_Sequence Sequence;
    public String StackName;
    public String VelocityFieldName;
    public int Radius = 1;
    public float Digi = 4.0f;
    public float MinTime = 0.0f;
    public float MaxTime = 1000.0f;
    public double Mute = 33.0;
    public double MinOffset = 1200.0;
    public double MaxOffset = 7000.0;
    public int HeaderCount = 5;
    public String Path;
    public ParameterTree Parameters = new ParameterTree();
    public String ParamFileName;

    public Action_FullStack() {
        try {
            this.RequiresRefractionStaticsProject = true;
            this.Description = "Create  stack";
            this.RequiresDelayTimeData = false;
            this.MemoryRequired = 1024;
            this.Sequence = new EnsembleWorker_Sequence(EnsembleWorker_Sequence.SequenceType.Interactive);
            this.Sequence.add(new EnsembleWorker_AGC());
            this.Sequence.add(new EnsembleWorker_RMS());
            this.Sequence.add(new EnsembleWorker_ApplyNMO());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void preparePaths() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            this.Path = Tools_FileSystem.confirmSubDirectoryExists(parentPath, this.StackName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            int b;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long traceCount = traceTable.rowCount();
            VelocityManager velManager = RefractionStaticsProject.singleton().getVelocityManager();
            String velname = velManager.getVersionList().get(0);
            VelocityLocationCollection velField = velManager.getVelocityLocationCollection(velname);
            Grid3D_Conversion gc = project.getGrid3D_Conversion();
            Grid3D emptyGrid = project.getEmptyGrid3D();
            int minInline = Integer.MAX_VALUE;
            int minCrossline = Integer.MAX_VALUE;
            int maxInline = Integer.MIN_VALUE;
            int maxCrossline = Integer.MIN_VALUE;
            double sizeI = emptyGrid.inlineBinSize();
            double sizeC = emptyGrid.crosslineBinSize();
            int chunkSize = 10000;
            int numSampOut = 600;
            double digi = 4.0;
            velField.setRequestedInterp(0.0f, (float)digi, numSampOut);
            float[] output = new float[numSampOut];
            HashMap_Integers<Stack> map = new HashMap_Integers<Stack>();
            Ensemble ensemble = new Ensemble();
            CubicTraceInterpolator cti = new CubicTraceInterpolator();
            for (long currentIndex = 0L; !this.Halt && currentIndex < traceTable.rowCount(); currentIndex += (long)chunkSize) {
                messageServer.setPercentDone(100.0 * (double)currentIndex / (double)traceTable.rowCount());
                ensemble.clearTraces(false);
                System.gc();
                System.gc();
                project.ensemble_Sequence(ensemble, currentIndex, chunkSize, true);
                Ensemble processedEnsemble = this.Sequence.work(ensemble);
                int indexI = processedEnsemble.dictionary().getEntryIndex("Trace", "Inline");
                int indexC = processedEnsemble.dictionary().getEntryIndex("Trace", "Crossline");
                for (int n = 0; n < processedEnsemble.traceCount(); ++n) {
                    EnsembleTrace t = processedEnsemble.trace(n);
                    int i = t.header().getInt(indexI);
                    int c = t.header().getInt(indexC);
                    maxInline = Math.max(maxInline, i);
                    minInline = Math.min(minInline, i);
                    maxCrossline = Math.max(maxCrossline, c);
                    minCrossline = Math.min(minCrossline, c);
                    if (!map.containsKey(i, c)) {
                        map.put(new Stack(numSampOut), i, c);
                    }
                    Stack stack = (Stack)map.get(i, c);
                    cti.prepareInput(t);
                    cti.interpolate(output, 0.0f, (float)digi);
                    for (int s = 0; s < numSampOut; ++s) {
                        int n2 = s;
                        stack.Data[n2] = stack.Data[n2] + output[s];
                    }
                    ++stack.Count;
                }
            }
            if (this.Halt) {
                return false;
            }
            String name = project.name();
            String fileNameSegy = "/Users/matt/Data/Stacks/stack_" + name + ".sgy";
            RandomAccessFile rafSegy = new RandomAccessFile(fileNameSegy, "rw");
            String fileNameVel = "/Users/matt/Data/Stacks/vel_" + name + ".sgy";
            RandomAccessFile rafVel = new RandomAccessFile(fileNameVel, "rw");
            ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
            byte[] asciiByteArray = new byte[3200];
            for (int n = 0; n < asciiByteArray.length; ++n) {
                asciiByteArray[n] = 32;
            }
            String label = "Created by Flatirons Refraction Statics Software - XtremeGeo LLC";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[b] = label.getBytes()[b];
            }
            label = "Fold                101        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[80 + b] = label.getBytes()[b];
            }
            label = "CdpX                105        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[160 + b] = label.getBytes()[b];
            }
            label = "CdpY                109        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[240 + b] = label.getBytes()[b];
            }
            label = "Inline              113        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[320 + b] = label.getBytes()[b];
            }
            label = "Crossline           117        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[400 + b] = label.getBytes()[b];
            }
            label = "Min Inline          121        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[480 + b] = label.getBytes()[b];
            }
            label = "Min Crossline       125        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[560 + b] = label.getBytes()[b];
            }
            label = "Max Inline          129        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[640 + b] = label.getBytes()[b];
            }
            label = "Max Crossline       133        4I";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[720 + b] = label.getBytes()[b];
            }
            label = "Bin size inline     137        4I  TIMES 100";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[800 + b] = label.getBytes()[b];
            }
            label = "Bin size crossline  141        4I  TIMES 100";
            for (b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[880 + b] = label.getBytes()[b];
            }
            String ebcdic = new String(asciiByteArray);
            byte[] ebcdicByteArray = ebcdic.getBytes("Cp1047");
            rafSegy.write(ebcdicByteArray, 0, ebcdicByteArray.length);
            rafVel.write(ebcdicByteArray, 0, ebcdicByteArray.length);
            ByteBuffer buffer = ByteBuffer.allocate(400);
            buffer.order(byteOrder);
            buffer.putInt(Segy_FileHeader.Entry.JobID.ByteOffset, 1000);
            buffer.putInt(Segy_FileHeader.Entry.LineNumber.ByteOffset, 1000);
            buffer.putInt(Segy_FileHeader.Entry.ReelNumber.ByteOffset, 1000);
            buffer.putShort(Segy_FileHeader.Entry.EnsembleTraceCount.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.TracesPerEnsembleExpected.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.EnsembleTraceCountAuxiliary.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.SampleIntervalMicro.ByteOffset, (short)(0.5 + 1000.0 * digi));
            buffer.putShort(Segy_FileHeader.Entry.SampleIntervalMicroOriginal.ByteOffset, (short)(0.5 + 1000.0 * digi));
            buffer.putShort(Segy_FileHeader.Entry.SamplesPerTrace.ByteOffset, (short)numSampOut);
            buffer.putShort(Segy_FileHeader.Entry.SamplesPerTraceOriginal.ByteOffset, (short)numSampOut);
            buffer.putShort(Segy_FileHeader.Entry.FormatCode.ByteOffset, (short)1);
            buffer.putShort(Segy_FileHeader.Entry.Units.ByteOffset, (short)1);
            rafSegy.write(buffer.array(), 0, 400);
            rafVel.write(buffer.array(), 0, 400);
            ByteBuffer traceHeaderBuffer = ByteBuffer.allocate(240);
            traceHeaderBuffer.order(byteOrder);
            byte[] outputTraceBytes = new byte[4 * numSampOut];
            Random r = new Random();
            int midi = (minInline + maxInline) / 2;
            int midc = (minCrossline + maxCrossline) / 2;
            for (int i = minInline; i <= maxInline; ++i) {
                for (int c = minCrossline; c <= maxCrossline; ++c) {
                    int s;
                    gc.setInlineCrossline(i, c);
                    float[] vel = velField.getVelocity(gc.WorldX, gc.WorldY);
                    int cdpx = (int)(0.5 + (double)(i - minInline) * sizeI);
                    int cdpy = (int)(0.5 + (double)(c - minCrossline) * sizeC);
                    int fold = 0;
                    for (s = 0; s < numSampOut; ++s) {
                        output[s] = 0.0f;
                    }
                    if (map.containsKey(i, c)) {
                        Stack stack = (Stack)map.get(i, c);
                        fold = stack.Count;
                        for (int s2 = 0; s2 < numSampOut; ++s2) {
                            output[s2] = stack.Data[s2];
                        }
                    }
                    if (i == midi && c == midc) {
                        for (s = 0; s < numSampOut; ++s) {
                            System.out.println("vel " + vel[s]);
                        }
                    }
                    fold = 10;
                    double sigma = 0.01;
                    int mid = numSampOut / 4;
                    int s3 = 0;
                    while (s3 < numSampOut) {
                        double dt = 0.004 * (double)Math.abs(s3 - mid);
                        double f1 = 1.0 - dt * dt / (sigma * sigma);
                        double f2 = dt * dt / (2.0 * sigma * sigma);
                        output[s3] = -100.0f * (float)(f1 * Math.exp(-f2));
                        int n = s3++;
                        output[n] = output[n] + (float)(0.5 - r.nextDouble());
                    }
                    traceHeaderBuffer.putShort(28, (short)1);
                    traceHeaderBuffer.putInt(100, fold);
                    traceHeaderBuffer.putInt(104, cdpx);
                    traceHeaderBuffer.putInt(108, cdpy);
                    traceHeaderBuffer.putInt(112, i);
                    traceHeaderBuffer.putInt(116, c);
                    traceHeaderBuffer.putInt(120, minInline);
                    traceHeaderBuffer.putInt(124, minCrossline);
                    traceHeaderBuffer.putInt(128, maxInline);
                    traceHeaderBuffer.putInt(132, maxCrossline);
                    traceHeaderBuffer.putInt(136, (int)(0.5 + 100.0 * gc.inlineBinSize()));
                    traceHeaderBuffer.putInt(140, (int)(0.5 + 100.0 * gc.crosslineBinSize()));
                    rafSegy.write(traceHeaderBuffer.array(), 0, 240);
                    rafVel.write(traceHeaderBuffer.array(), 0, 240);
                    Tools_ByteArray.convertFloatToIBM(outputTraceBytes, output, numSampOut);
                    rafSegy.write(outputTraceBytes);
                    Tools_ByteArray.convertFloatToIBM(outputTraceBytes, vel, numSampOut);
                    rafVel.write(outputTraceBytes);
                }
            }
            rafSegy.close();
            rafVel.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected class Stack {
        public float[] Data;
        public int Count = 0;

        public Stack(int len) {
            this.Data = new float[len];
        }
    }
}

