/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Stack;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Stack.VelocityManager;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class Action_CreateStack
extends Action_Base {
    public OutputBin[][] OutputBinArray;
    public EnsembleWorker_Sequence Sequence;
    public String StackName;
    public String VelocityFieldName;
    public boolean ApplyStatics;
    public String VersionName;
    public String StaticsName;
    public int Radius = 1;
    public float Digi = 4.0f;
    public float MinTime = 0.0f;
    public float MaxTime = 1000.0f;
    public int SamplesPerTrace;
    public double Mute = 33.0;
    public double MinOffset = 1200.0;
    public double MaxOffset = 7000.0;
    public int HeaderCount = 25;
    public String Path;
    public String InlineStackPath;
    public Grid3D m_countGrid;
    public Grid3D m_weightGrid;
    public int InlineMin;
    public int InlineMax;
    public int InlineCount;
    public int CrosslineMin;
    public int CrosslineMax;
    public int CrosslineCount;
    public VelocityLocationCollection m_velField;
    public StackGizmo m_stackGizmo = new StackGizmo();
    public Table_Abstract m_shotTable = null;
    public HashMap_Integer m_shotHash = null;
    public int m_colIndexShot = 0;
    public Table_Abstract m_recTable = null;
    public HashMap_Integer m_recHash = null;
    public int m_colIndexRec = 0;
    public int Inline;
    public int Crossline;
    public ParameterTree Parameters = new ParameterTree();
    public String ParamFileName;

    public Action_CreateStack() {
        try {
            this.RequiresRefractionStaticsProject = true;
            this.Description = "Create stack";
            this.RequiresDelayTimeData = false;
            this.MemoryRequired = 1024;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepOutputBin() {
        try {
            this.Radius = Math.max(this.Radius, 0);
            this.Radius = Math.min(this.Radius, 5);
            this.OutputBinArray = new OutputBin[2 * this.Radius + 1][this.CrosslineCount];
            for (int r = -this.Radius; r <= this.Radius; ++r) {
                for (int c = this.CrosslineMin; c <= this.CrosslineMax; ++c) {
                    this.OutputBinArray[r + this.Radius][c] = new OutputBin(this.SamplesPerTrace);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepStatics() {
        try {
            if (!this.ApplyStatics) {
                return;
            }
            IDatabaseConnection database = RefractionStaticsProject.singleton().getVersionDatabase(this.VersionName);
            String sql = String.format("SELECT ShotID, %s FROM Shot", this.StaticsName);
            this.m_shotTable = database.extractTableDataUsingQuery("Shot", sql, Pecos.MaxQueryRowCount);
            this.m_shotHash = this.m_shotTable.createMapID();
            this.m_colIndexShot = this.m_shotTable.column_indexOfColumn(this.StaticsName);
            sql = String.format("SELECT ReceiverID, %s FROM Receiver", this.StaticsName);
            this.m_recTable = database.extractTableDataUsingQuery("Receiver", sql, Pecos.MaxQueryRowCount);
            this.m_recHash = this.m_recTable.createMapID();
            this.m_colIndexRec = this.m_recTable.column_indexOfColumn(this.StaticsName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void applyStatics(Ensemble ensemble) {
        try {
            if (!this.ApplyStatics) {
                return;
            }
            int indexShotID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                float statics = 0.0f;
                EnsembleTrace trace = ensemble.trace(n);
                int shotID = trace.header().getInt(indexShotID);
                int shotRow = this.m_shotHash.get(shotID);
                statics += this.m_shotTable.getFloat(shotRow, this.m_colIndexShot);
                int recID = trace.header().getInt(indexRecID);
                int recRow = this.m_recHash.get(recID);
                trace.data().addShiftToFirstSampleCoord(statics += this.m_recTable.getFloat(recRow, this.m_colIndexRec));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float stackAmplitude(float[] stack) {
        try {
            float sum = 0.0f;
            for (int n = 0; n < stack.length; ++n) {
                sum += Math.abs(stack[n]);
            }
            return sum / (float)stack.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    protected void handleEnsemble(Ensemble inputEnsemble) {
        try {
            int numOkay = inputEnsemble.traceCount_Okay();
            if (numOkay < 1) {
                return;
            }
            Ensemble ensemble = this.Sequence.work(inputEnsemble);
            this.applyStatics(ensemble);
            double x = this.m_countGrid.getWorldX(this.Inline, this.Crossline);
            double y = this.m_countGrid.getWorldY(this.Inline, this.Crossline);
            float[] velocity = this.m_velField.getVelocity(x, y);
            float[] stack = this.m_stackGizmo.stack(ensemble, velocity, this.MinTime, this.Digi, this.Mute, this.MinOffset, this.MaxOffset);
            if (stack.length < 2) {
                return;
            }
            float amplitude = this.stackAmplitude(stack);
            if (Float.isNaN(amplitude)) {
                return;
            }
            if (amplitude < 1.0E-10f) {
                return;
            }
            for (int ri = -this.Radius; ri <= this.Radius; ++ri) {
                for (int rc = -this.Radius; rc <= this.Radius; ++rc) {
                    int outputCrossline = this.Crossline + rc;
                    int outputCrosslineIndex = outputCrossline - this.CrosslineMin;
                    if (outputCrosslineIndex < 0 || outputCrosslineIndex >= this.CrosslineCount) continue;
                    this.OutputBinArray[ri + this.Radius][outputCrosslineIndex].add(stack, amplitude);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void saveInline(int radius) {
        try {
            int inline = this.Inline + radius;
            if (inline < this.InlineMin) {
                return;
            }
            if (inline > this.InlineMax) {
                return;
            }
            int inlineIndex = inline - this.InlineMin;
            OutputBin[] bins = this.OutputBinArray[radius + this.Radius];
            String dataFileName = this.InlineStackPath + "/" + Integer.toString(inline) + ".data";
            String hdrFileName = this.InlineStackPath + "/" + Integer.toString(inline) + ".hdr";
            int totalDataBytes = this.CrosslineCount * 4 * this.SamplesPerTrace;
            int totalHeaderBytes = this.CrosslineCount * 4 * this.HeaderCount;
            ByteBuffer bufferData = ByteBuffer_Shared.buffer(0, totalDataBytes);
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(1, totalDataBytes);
            for (int c = 0; c < bins.length; ++c) {
                int offset = c * 4 * this.SamplesPerTrace;
                for (int s = 0; s < this.SamplesPerTrace; ++s) {
                    bufferData.putFloat(offset + 4 * s, bins[c].Stack[s]);
                }
                offset = c * 4 * this.HeaderCount;
                for (int h = 0; h < this.HeaderCount; ++h) {
                    bufferHeader.putFloat(offset + 4 * h, -9999.0f);
                }
                bufferHeader.putFloat(offset + 0, bins[c].Count);
                bufferHeader.putFloat(offset + 4, bins[c].AmplitudeSum);
                this.m_countGrid.data()[inlineIndex][c] = bins[c].Count;
                this.m_weightGrid.data()[inlineIndex][c] = bins[c].AmplitudeSum;
            }
            RandomAccessFile file = new RandomAccessFile(dataFileName, "rw");
            file.write(bufferData.array(), 0, totalDataBytes);
            file.close();
            file = new RandomAccessFile(hdrFileName, "rw");
            file.write(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void finishCurrentInline() {
        try {
            this.saveInline(-this.Radius);
            for (int radius = -this.Radius; radius < this.Radius; ++radius) {
                for (int c = 0; c < this.CrosslineCount; ++c) {
                    OutputBin left = this.OutputBinArray[this.Radius + radius][c];
                    OutputBin right = this.OutputBinArray[this.Radius + radius + 1][c];
                    left.copyFromOtherBin(right);
                }
            }
            for (int c = 0; c < this.CrosslineCount; ++c) {
                this.OutputBinArray[this.Radius + this.Radius][c].clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void preparePaths() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String parentPath = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "VolumeStacks");
            this.Path = Tools_FileSystem.confirmSubDirectoryExists(parentPath, this.StackName);
            this.InlineStackPath = Tools_FileSystem.confirmSubDirectoryExists(this.Path, "InlineStacks");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_countGrid = project.getEmptyGrid3D();
            this.m_weightGrid = project.getEmptyGrid3D();
            this.SamplesPerTrace = (int)(0.5 + (double)((this.MaxTime - this.MinTime) / this.Digi));
            VelocityManager velManager = RefractionStaticsProject.singleton().getVelocityManager();
            this.m_velField = velManager.getVelocityLocationCollection(this.VelocityFieldName);
            this.m_velField.setRequestedInterp(this.MinTime, this.Digi, this.SamplesPerTrace);
            this.InlineMin = this.m_countGrid.inlineMin();
            this.InlineMax = this.m_countGrid.inlineMax();
            this.InlineCount = this.InlineMax - this.InlineMin + 1;
            this.CrosslineMin = this.m_countGrid.crosslineMin();
            this.CrosslineMax = this.m_countGrid.crosslineMax();
            this.CrosslineCount = this.CrosslineMax - this.CrosslineMin + 1;
            this.prepOutputBin();
            this.prepStatics();
            this.preparePaths();
            Ensemble ensemble = new Ensemble();
            boolean crap = false;
            this.Inline = this.InlineMin;
            while (this.Inline <= this.Radius + this.InlineMax && !this.Halt) {
                double percent = 100.0 * (double)(this.Inline - this.InlineMin) / (double)this.InlineCount;
                messageServer.setPercentDone(percent);
                this.Crossline = this.CrosslineMin;
                while (this.Crossline <= this.CrosslineMax && !this.Halt) {
                    if (this.Crossline == 120) {
                        crap = true;
                    }
                    ensemble.clearTraces(false);
                    project.ensemble_Bin3D(ensemble, this.Inline, this.Crossline, 0, true);
                    this.handleEnsemble(ensemble);
                    ++this.Crossline;
                }
                this.finishCurrentInline();
                ++this.Inline;
            }
            String countGridName = this.Path + "/count.grid3d";
            this.m_countGrid.save(countGridName);
            String weightGridName = this.Path + "/weight.grid3d";
            this.m_weightGrid.save(weightGridName);
            this.ParamFileName = this.Path + "/params.xml";
            this.Parameters.double_put("MaxOffset", this.MaxOffset);
            this.Parameters.double_put("MinOffset", this.MinOffset);
            this.Parameters.double_put("Mute", this.Mute);
            this.Parameters.double_put("MinTime", this.MinTime);
            this.Parameters.double_put("MaxTime", this.MaxTime);
            this.Parameters.double_put("Digi", this.Digi);
            this.Parameters.int_put("Radius", this.Radius);
            this.Parameters.int_put("SamplesPerTrace", this.SamplesPerTrace);
            this.Parameters.int_put("CrosslineCount", this.CrosslineCount);
            this.Parameters.int_put("HeaderCount", this.HeaderCount);
            this.Parameters.save(this.ParamFileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public class OutputBin {
        public int Count = 0;
        public float AmplitudeSum = 0.0f;
        public float[] Stack;

        public OutputBin(int length) {
            this.Stack = new float[length];
            this.clear();
        }

        public void add(float[] stack, float amp) {
            for (int n = 0; n < this.Stack.length; ++n) {
                this.Stack[n] = this.Stack[n] + stack[n];
            }
            ++this.Count;
            this.AmplitudeSum += amp;
        }

        public void copyFromOtherBin(OutputBin otherBin) {
            for (int n = 0; n < this.Stack.length; ++n) {
                this.Stack[n] = otherBin.Stack[n];
            }
            this.Count = otherBin.Count;
            this.AmplitudeSum = otherBin.AmplitudeSum;
        }

        public void clear() {
            for (int n = 0; n < this.Stack.length; ++n) {
                this.Stack[n] = 0.0f;
            }
            this.Count = 0;
            this.AmplitudeSum = 0.0f;
        }
    }
}

