/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class Action_ComputeMoveoutTrends
extends Action_Base {
    protected HashMap_Integers<Location> m_hash = new HashMap_Integers();
    protected String m_pickVersion = "";
    protected double m_spacing = 5000.0;
    protected double m_offsetBinSize = 1000.0;
    protected double[] m_binRadius;

    public Action_ComputeMoveoutTrends() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Compute moveout trend lines";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
    }

    protected Location getLocation(double x, double y) {
        try {
            int bx = (int)Math.round(x / this.m_spacing);
            int by = (int)Math.round(y / this.m_spacing);
            if (this.m_hash.containsKey(bx, by)) {
                return this.m_hash.get(bx, by);
            }
            Location loc = new Location();
            loc.X = this.m_spacing * (double)bx;
            loc.Y = this.m_spacing * (double)by;
            this.m_hash.put(loc, bx, by);
            return loc;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected boolean preliminaryScan(IProgressMonitor messageServer) {
        try {
            messageServer.setMessage_Level1("Preliminary scan");
            ITraceTable projectTraceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            int indexPick = projectTraceTable.column_indexOfColumn(this.m_pickVersion);
            for (long row = 0L; row < projectTraceTable.rowCount(); ++row) {
                float pick = projectTraceTable.getFloat(row, indexPick);
                if (pick > 0.0f) {
                    double x = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidX);
                    double y = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidY);
                    double off = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                    Location loc = this.getLocation(x, y);
                    ++loc.Count;
                    loc.MaxOffset = Math.max(loc.MaxOffset, off);
                    loc.MaxTime = Math.max(loc.MaxTime, (double)pick);
                }
                if (row % 100000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)row / (double)projectTraceTable.rowCount());
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean updateScan(IProgressMonitor messageServer) {
        try {
            ITraceTable projectTraceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            int indexPick = projectTraceTable.column_indexOfColumn(this.m_pickVersion);
            ArrayList<Location> list = this.m_hash.getValues();
            for (Location loc : list) {
                loc.prepIter();
            }
            for (long row = 0L; row < projectTraceTable.rowCount(); ++row) {
                float pick = projectTraceTable.getFloat(row, indexPick);
                if (pick > 0.0f) {
                    double x = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidX);
                    double y = sharedTraceTable.getInt(row, this.DelayTimeData.IndexMidY);
                    double off = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                    Location loc = this.getLocation(x, y);
                    if (loc.Valid) {
                        int offBin = (int)(off / this.m_offsetBinSize);
                        double error = Math.abs((double)pick - loc.AverageTime[offBin]);
                        double ratio = error / this.m_binRadius[offBin];
                        double weight = 1.0 / (1.0 + ratio * ratio);
                        loc.BinCount[offBin] = loc.BinCount[offBin] + 1;
                        loc.SumTime[offBin] = loc.SumTime[offBin] + weight * (double)pick;
                        loc.SumWeight[offBin] = loc.SumWeight[offBin] + weight;
                    }
                    ++loc.Count;
                    loc.MaxOffset = Math.max(loc.MaxOffset, off);
                    loc.MaxTime = Math.max(loc.MaxTime, (double)pick);
                }
                if (row % 100000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)row / (double)projectTraceTable.rowCount());
            }
            for (Location loc : list) {
                loc.finishIter();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean prepJunk() {
        try {
            double maxOffset = 0.0;
            double maxTime = 0.0;
            int maxCount = 0;
            ArrayList<Location> list = this.m_hash.getValues();
            for (Location loc : list) {
                maxOffset = Math.max(maxOffset, loc.MaxOffset);
                maxTime = Math.max(maxTime, loc.MaxTime);
                maxCount = Math.max(maxCount, loc.Count);
                System.out.println(String.format("(%d %d) %d  %d  %d", (int)loc.X, (int)loc.Y, loc.Count, (int)loc.MaxOffset, (int)loc.MaxTime));
            }
            if (maxCount < 3000) {
                this.FailureReason = "Not enough valid picks";
                this.Failed = true;
                return false;
            }
            int minValidCount = Math.max(3000, maxCount / 3);
            int numOffsetBins = 2 + (int)(maxOffset / this.m_offsetBinSize);
            for (Location loc : list) {
                loc.Valid = loc.Count >= minValidCount;
                loc.allocate(numOffsetBins);
            }
            this.m_binRadius = new double[numOffsetBins];
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            this.m_pickVersion = this.Hasher.string_get("PickVersion", "FBP_User");
            this.m_spacing = this.Hasher.double_get("Spacing", 1000.0);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (project.units_feet()) {
                this.m_spacing = Math.max(this.m_spacing, 1000.0);
                this.m_spacing = Math.min(this.m_spacing, 10000.0);
                this.m_offsetBinSize = 1000.0;
            } else {
                this.m_spacing = Math.max(this.m_spacing, 200.0);
                this.m_spacing = Math.min(this.m_spacing, 3000.0);
                this.m_offsetBinSize = 300.0;
            }
            if (!this.preliminaryScan(messageServer)) {
                return false;
            }
            if (!this.prepJunk()) {
                return false;
            }
            int numIter = 5;
            for (int iter = 1; iter <= numIter; ++iter) {
                messageServer.setMessage_Level1(String.format("Iteration %d of %d", iter, numIter));
                if (iter == 1) {
                    for (int n = 0; n < this.m_binRadius.length; ++n) {
                        this.m_binRadius[n] = 1.0E7;
                    }
                } else {
                    double radAtMax = 500.0 / (double)iter;
                    for (int n = 0; n < this.m_binRadius.length; ++n) {
                        this.m_binRadius[n] = 30.0 + (double)(n + 1) * radAtMax / (double)this.m_binRadius.length;
                    }
                }
                this.updateScan(messageServer);
            }
            MoveoutTrendData mtd = project.moveoutTrendData();
            mtd.clear();
            float[] offset = new float[this.m_binRadius.length];
            float[] time = new float[this.m_binRadius.length];
            ArrayList<Location> list = this.m_hash.getValues();
            for (Location loc : list) {
                if (!loc.Valid) continue;
                int num = 0;
                for (int n = 0; n < this.m_binRadius.length; ++n) {
                    if (loc.BinCount[n] <= 30) continue;
                    offset[num] = ((float)n + 0.5f) * (float)this.m_offsetBinSize;
                    time[num] = (float)loc.AverageTime[n];
                    ++num;
                }
                if (num <= 0) continue;
                mtd.addLocation(loc.X, loc.Y);
                mtd.setSelected(num, offset, time);
            }
            mtd.save(project.moveoutTrendFileName());
            Messenger.broadcast(Messenger.Message.MoveoutTrendModified, null, null);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected class Location {
        public double X;
        public double Y;
        public int Count = 0;
        public double MaxOffset = 0.0;
        public double MaxTime = 0.0;
        public boolean Valid = false;
        public double[] AverageTime;
        public double[] SumTime;
        public double[] SumWeight;
        public int[] BinCount;

        protected Location() {
        }

        public void allocate(int numOffsetBins) {
            this.AverageTime = new double[numOffsetBins];
            this.SumTime = new double[numOffsetBins];
            this.SumWeight = new double[numOffsetBins];
            this.BinCount = new int[numOffsetBins];
        }

        public void finishIter() {
            double lastValidTime = 0.0;
            for (int n = 0; n < this.AverageTime.length; ++n) {
                if (this.BinCount[n] <= 20) continue;
                this.AverageTime[n] = this.SumTime[n] / this.SumWeight[n];
                this.AverageTime[n] = Math.max(this.AverageTime[n], lastValidTime);
                lastValidTime = this.AverageTime[n];
            }
        }

        public void prepIter() {
            for (int n = 0; n < this.AverageTime.length; ++n) {
                this.BinCount[n] = 0;
                this.SumTime[n] = 0.0;
                this.SumWeight[n] = 1.0E-40;
            }
        }
    }
}

