/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.QC;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_UnkillTraces
extends Action_Base {
    public Action_UnkillTraces() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "unkill traces";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            long numTraces = traceTable.rowCount();
            int colTraceKilled = traceTable.column_indexOfColumn("Killed");
            for (long row = 0L; row < numTraces; ++row) {
                traceTable.putInt(row, colTraceKilled, 0);
                if (row % 100000L != 0L) continue;
                double percent = 100.0 * (double)row / (double)numTraces;
                messageServer.setPercentDone(percent);
            }
            traceTable.saveCurrentSection();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

