/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.JDBC;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Action_CreateTraceTable
extends Action_Base {
    public Action_CreateTraceTable() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create SQL trace table";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean exportCSV(IProgressMonitor messageServer) {
        try {
            messageServer.setMessage_Level1("Export CSV file");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            String path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "SqlTraceTable");
            String csv = path + "/trace.csv";
            BufferedWriter writer = new BufferedWriter(new FileWriter(csv));
            for (int n = 0; n < traceTable.column_count(); ++n) {
                if (n >= 1) {
                    writer.write(", ");
                }
                writer.write(traceTable.column_name(n));
            }
            writer.newLine();
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                for (int n = 0; n < traceTable.column_count(); ++n) {
                    if (n >= 1) {
                        writer.write(", ");
                    }
                    writer.write(traceTable.getString(row, n));
                }
                writer.newLine();
                if (row % 1000L != 0L) continue;
                double precent = 100.0 * (double)row / (double)(traceTable.rowCount() + 1L);
                messageServer.setPercentDone(precent);
            }
            writer.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            Object path = project.projectPath() + "/SqlTraceTable";
            Tools_FileSystem.deletePathIfExists((String)path);
            path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "SqlTraceTable");
            String dbname = (String)path + "/trace.db";
            this.exportCSV(messageServer);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

