/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;

public class Action_ImportAram
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected String m_aramFile = null;
    protected String m_units = "";
    protected String m_dimension = "";
    protected Grid3D_Conversion m_grid3D = new Grid3D_Conversion();
    protected Table_Abstract m_sxallocTable = new Table_Memory();
    protected int m_sxallocIndex_SourceLine;
    protected int m_sxallocIndex_SourceFlagFrom;
    protected int m_sxallocIndex_SourceFlagTo;
    protected int m_sxallocIndex_SourceFlagBy;
    protected int m_sxallocIndex_Type;
    protected Table_Abstract m_rxallocTable = new Table_Memory();
    protected int m_rxallocIndex_ReceiverLine;
    protected int m_rxallocIndex_ReceiverFlagFrom;
    protected int m_rxallocIndex_ReceiverFlagTo;
    protected int m_rxallocIndex_ReceiverFlagBy;
    protected int m_rxallocIndex_Type;
    protected int m_rxallocIndex_CableType;
    protected Table_Abstract m_patdefTable = new Table_Memory();
    protected int m_patdefIndex_PatDefNumber;
    protected int m_patdefIndex_ReceiverLine;
    protected int m_patdefIndex_ReceiverFlagFrom;
    protected int m_patdefIndex_ReceiverFlagTo;
    protected int m_patdefIndex_ReceiverFlagBy;
    protected Table_Abstract m_usepatTable = new Table_Memory();
    protected int m_usepatIndex_PatDefNumber;
    protected int m_usepatIndex_SourceLine;
    protected int m_usepatIndex_SourceFlagFrom;
    protected int m_usepatIndex_SourceFlagTo;
    protected int m_usepatIndex_SourceFlagBy;
    protected Table_Abstract m_shotTable = new Table_Memory();
    protected HashMap_Integer m_shotHash = new HashMap_Integer();
    protected HashMap_Integers<Integer> m_shotLF = new HashMap_Integers();
    protected int m_shotIndex_ID;
    protected int m_shotIndex_PointNumber;
    protected int m_shotIndex_LineNumber;
    protected int m_shotIndex_PointIndex;
    protected int m_shotIndex_X;
    protected int m_shotIndex_Y;
    protected int m_shotIndex_Z;
    protected Table_Abstract m_receiverTable = new Table_Memory();
    protected HashMap_Integer m_receiverHash = new HashMap_Integer();
    protected HashMap_Integers<Integer> m_receiverLF = new HashMap_Integers();
    protected int m_receiverIndex_ID;
    protected int m_receiverIndex_PointNumber;
    protected int m_receiverIndex_LineNumber;
    protected int m_receiverIndex_PointIndex;
    protected int m_receiverIndex_X;
    protected int m_receiverIndex_Y;
    protected int m_receiverIndex_Z;
    protected Table_Abstract m_traceTable = new Table_Memory();
    protected int m_traceIndex_TraceID;
    protected int m_traceIndex_ShotID;
    protected int m_traceIndex_RecID;
    protected int m_traceIndex_Inline;
    protected int m_traceIndex_Crossline;
    protected int m_traceIndex_Pick;
    protected int m_traceCount = 0;
    protected int m_traceID = 999;
    protected TraceTable_Huge m_diskTable;

    public Action_ImportAram() {
        this.Description = "Import Aram project file";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_rxallocTable.setName("RxAlloc");
            this.m_rxallocIndex_ReceiverLine = this.m_rxallocTable.column_append("Line", DataType.Int);
            this.m_rxallocIndex_ReceiverFlagFrom = this.m_rxallocTable.column_append("FromFlag", DataType.Int);
            this.m_rxallocIndex_ReceiverFlagTo = this.m_rxallocTable.column_append("ToFlag", DataType.Int);
            this.m_rxallocIndex_ReceiverFlagBy = this.m_rxallocTable.column_append("ByFlag", DataType.Float);
            this.m_rxallocIndex_Type = this.m_rxallocTable.column_append("Type", DataType.Int);
            this.m_rxallocIndex_CableType = this.m_rxallocTable.column_append("CableType", DataType.Text);
            this.m_sxallocTable.setName("SxAlloc");
            this.m_sxallocIndex_SourceLine = this.m_sxallocTable.column_append("Line", DataType.Int);
            this.m_sxallocIndex_SourceFlagFrom = this.m_sxallocTable.column_append("FromFlag", DataType.Int);
            this.m_sxallocIndex_SourceFlagTo = this.m_sxallocTable.column_append("ToFlag", DataType.Int);
            this.m_sxallocIndex_SourceFlagBy = this.m_sxallocTable.column_append("ByFlag", DataType.Float);
            this.m_sxallocIndex_Type = this.m_sxallocTable.column_append("Type", DataType.Int);
            this.m_patdefTable.setName("PATDEF");
            this.m_patdefIndex_PatDefNumber = this.m_patdefTable.column_append("PATDEF", DataType.Int);
            this.m_patdefIndex_ReceiverLine = this.m_patdefTable.column_append("Line", DataType.Int);
            this.m_patdefIndex_ReceiverFlagFrom = this.m_patdefTable.column_append("FromFlag", DataType.Int);
            this.m_patdefIndex_ReceiverFlagTo = this.m_patdefTable.column_append("ToFlag", DataType.Int);
            this.m_patdefIndex_ReceiverFlagBy = this.m_patdefTable.column_append("ByFlag", DataType.Float);
            this.m_usepatTable.setName("USEPAT");
            this.m_usepatIndex_PatDefNumber = this.m_usepatTable.column_append("PATDEF", DataType.Int);
            this.m_usepatIndex_SourceLine = this.m_usepatTable.column_append("Line", DataType.Int);
            this.m_usepatIndex_SourceFlagFrom = this.m_usepatTable.column_append("FromFlag", DataType.Int);
            this.m_usepatIndex_SourceFlagTo = this.m_usepatTable.column_append("ToFlag", DataType.Int);
            this.m_usepatIndex_SourceFlagBy = this.m_usepatTable.column_append("ByFlag", DataType.Float);
            this.m_traceTable.setName("Trace");
            this.m_traceIndex_TraceID = this.m_traceTable.column_append("TraceID", DataType.Int);
            this.m_traceIndex_ShotID = this.m_traceTable.column_append("ShotID", DataType.Int);
            this.m_traceIndex_RecID = this.m_traceTable.column_append("ReceiverID", DataType.Int);
            this.m_traceIndex_Inline = this.m_traceTable.column_append("Inline", DataType.Int);
            this.m_traceIndex_Crossline = this.m_traceTable.column_append("Crossline", DataType.Int);
            this.m_traceIndex_Pick = this.m_traceTable.column_append("FBP_User", DataType.Float);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", this.m_traceTable, 8);
            this.m_receiverTable.setName("Receiver");
            this.m_receiverIndex_ID = this.m_receiverTable.column_append("ReceiverID", DataType.Int);
            this.m_receiverIndex_PointNumber = this.m_receiverTable.column_append("PointNumber", DataType.Int);
            this.m_receiverIndex_LineNumber = this.m_receiverTable.column_append("LineNumber", DataType.Int);
            this.m_receiverIndex_PointIndex = this.m_receiverTable.column_append("PointIndex", DataType.Int);
            this.m_receiverIndex_X = this.m_receiverTable.column_append("Easting", DataType.Double);
            this.m_receiverIndex_Y = this.m_receiverTable.column_append("Northing", DataType.Double);
            this.m_receiverIndex_Z = this.m_receiverTable.column_append("Elevation", DataType.Double);
            this.m_shotTable.setName("Shot");
            this.m_shotIndex_ID = this.m_shotTable.column_append("ShotID", DataType.Int);
            this.m_shotIndex_PointNumber = this.m_shotTable.column_append("PointNumber", DataType.Int);
            this.m_shotIndex_LineNumber = this.m_shotTable.column_append("LineNumber", DataType.Int);
            this.m_shotIndex_PointIndex = this.m_shotTable.column_append("PointIndex", DataType.Int);
            this.m_shotIndex_X = this.m_shotTable.column_append("Easting", DataType.Double);
            this.m_shotIndex_Y = this.m_shotTable.column_append("Northing", DataType.Double);
            this.m_shotIndex_Z = this.m_shotTable.column_append("Elevation", DataType.Double);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName;
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDimension() {
        try {
            if (!this.Hasher.string_exists("Dimension")) {
                this.FailureReason = "Dimension not specified";
                this.Failed = true;
                return false;
            }
            this.m_dimension = this.Hasher.string_get("Dimension");
            if (!this.m_dimension.equalsIgnoreCase("3D")) {
                this.m_dimension = "2D";
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkUnits() {
        try {
            if (!this.Hasher.string_exists("Units")) {
                this.FailureReason = "Units not specified";
                this.Failed = true;
                return false;
            }
            this.m_units = this.Hasher.string_get("Units");
            if (!this.m_units.equalsIgnoreCase("Feet")) {
                this.m_units = "Meters";
            }
            double gridSize = Pecos.gridSize(this.m_units);
            this.m_grid3D.setBinSize(gridSize, gridSize);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFile() {
        try {
            if (!this.Hasher.string_exists("FileName")) {
                this.FailureReason = "ARAM file not specified";
                this.Failed = true;
                return false;
            }
            this.m_aramFile = this.Hasher.string_get("FileName");
            if (!Tools_FileSystem.exists_file(this.m_aramFile)) {
                this.FailureReason = "No Aram specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!this.checkUnits()) {
                return false;
            }
            if (!this.checkDimension()) {
                return false;
            }
            if (!this.checkFile()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            if (!this.prepareTables()) {
                return false;
            }
            this.importFile(messageServer);
            String versionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "Versions");
            String currentPath = Tools_FileSystem.confirmSubDirectoryExists(versionsPath, "Default");
            this.m_usepatTable.saveToPath(this.m_projectPath);
            this.m_patdefTable.saveToPath(this.m_projectPath);
            this.m_sxallocTable.saveToPath(this.m_projectPath);
            this.m_rxallocTable.saveToPath(this.m_projectPath);
            this.m_shotTable.saveToPath(currentPath);
            this.m_receiverTable.saveToPath(currentPath);
            String fileNameDB = this.m_projectPath + "/supplemental.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            db.createDatabaseTable(this.m_usepatTable);
            db.appendTable(this.m_usepatTable, 0);
            db.createDatabaseTable(this.m_patdefTable);
            db.appendTable(this.m_patdefTable, 0);
            db.createDatabaseTable(this.m_sxallocTable);
            db.appendTable(this.m_sxallocTable, 0);
            db.createDatabaseTable(this.m_rxallocTable);
            db.appendTable(this.m_rxallocTable, 0);
            fileNameDB = currentPath + "/geometry.db";
            db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_shotTable);
            db.appendTable(this.m_shotTable, 0);
            db.createDatabaseTable(this.m_receiverTable);
            db.appendTable(this.m_receiverTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            this.createTraceTable(messageServer);
            String gridFile = this.m_projectPath + "/GridDefinition3D.xml";
            this.m_grid3D.save(gridFile);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.string_put("Units", this.m_units);
            p.string_put("Dimension", this.m_dimension);
            p.bool_put("HasSeismic", false);
            p.bool_put("HasShots", true);
            p.bool_put("HasReceivers", true);
            p.int_put("ShotCount", this.m_shotTable.row_count());
            p.int_put("ReceiverCount", this.m_receiverTable.row_count());
            p.int_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "ARAM");
            p.string_put("DateCreated", dateCreated);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void addEntryToTraceTable(int srcLine, int srcFlag, int recLine, int recFlag) {
        try {
            if (!this.m_shotLF.containsKey(srcLine, srcFlag)) {
                return;
            }
            if (!this.m_receiverLF.containsKey(recLine, recFlag)) {
                return;
            }
            int shotRow = this.m_shotLF.get(srcLine, srcFlag);
            int recRow = this.m_receiverLF.get(recLine, recFlag);
            int shotID = this.m_shotTable.getInt(shotRow, this.m_shotIndex_ID);
            int recID = this.m_receiverTable.getInt(recRow, this.m_receiverIndex_ID);
            double sx = this.m_shotTable.getDouble(shotRow, this.m_shotIndex_X);
            double sy = this.m_shotTable.getDouble(shotRow, this.m_shotIndex_Y);
            double rx = this.m_receiverTable.getDouble(recRow, this.m_receiverIndex_X);
            double ry = this.m_receiverTable.getDouble(recRow, this.m_receiverIndex_Y);
            double midx = 0.5 * (sx + rx);
            double midy = 0.5 * (sy + ry);
            this.m_grid3D.setWorldLocation(midx, midy);
            int binX = this.m_grid3D.Inline;
            int binY = this.m_grid3D.Crossline;
            ++this.m_traceID;
            ++this.m_traceCount;
            int r = this.m_traceTable.row_increment();
            this.m_traceTable.putInt(r, this.m_traceIndex_TraceID, this.m_traceID);
            this.m_traceTable.putInt(r, this.m_traceIndex_ShotID, shotID);
            this.m_traceTable.putInt(r, this.m_traceIndex_RecID, recID);
            this.m_traceTable.putInt(r, this.m_traceIndex_Inline, binX);
            this.m_traceTable.putInt(r, this.m_traceIndex_Crossline, binY);
            this.m_traceTable.putFloat(r, this.m_traceIndex_Pick, -9999.0f);
            if (this.m_traceTable.row_count() > 5000) {
                this.m_diskTable.appendTable(this.m_traceTable);
                this.m_traceTable.row_clear(false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createTraceTable(IProgressMonitor messageServer) {
        try {
            int flag;
            int line;
            int n;
            messageServer.setMessage_Level1("Create trace table");
            this.m_traceID = 999;
            this.m_traceCount = 0;
            for (n = 0; n < this.m_shotTable.row_count(); ++n) {
                line = this.m_shotTable.getInt(n, this.m_shotIndex_LineNumber);
                flag = this.m_shotTable.getInt(n, this.m_shotIndex_PointNumber);
                this.m_shotLF.put(new Integer(n), line, flag);
            }
            for (n = 0; n < this.m_receiverTable.row_count(); ++n) {
                line = this.m_receiverTable.getInt(n, this.m_receiverIndex_LineNumber);
                flag = this.m_receiverTable.getInt(n, this.m_receiverIndex_PointNumber);
                this.m_receiverLF.put(new Integer(n), line, flag);
            }
            for (int usePatRow = 0; usePatRow < this.m_usepatTable.row_count(); ++usePatRow) {
                double percent = 100.0 * (double)usePatRow / (double)this.m_usepatTable.row_count();
                messageServer.setPercentDone(percent);
                int patDef = this.m_usepatTable.getInt(usePatRow, this.m_usepatIndex_PatDefNumber);
                int srcLine = this.m_usepatTable.getInt(usePatRow, this.m_usepatIndex_SourceLine);
                int srcFlagFrom = this.m_usepatTable.getInt(usePatRow, this.m_usepatIndex_SourceFlagFrom);
                int srcFlagTo = this.m_usepatTable.getInt(usePatRow, this.m_usepatIndex_SourceFlagTo);
                float srcFlagBy = this.m_usepatTable.getFloat(usePatRow, this.m_usepatIndex_SourceFlagBy);
                int srcFlagStep = Math.round(srcFlagBy);
                srcFlagStep = Math.max(srcFlagStep, 1);
                for (int patDefRow = 0; patDefRow < this.m_patdefTable.row_count(); ++patDefRow) {
                    int patDefTest = this.m_patdefTable.getInt(patDefRow, this.m_patdefIndex_PatDefNumber);
                    if (patDefTest != patDef) continue;
                    int recLine = this.m_patdefTable.getInt(patDefRow, this.m_patdefIndex_ReceiverLine);
                    int recFlagFrom = this.m_patdefTable.getInt(patDefRow, this.m_patdefIndex_ReceiverFlagFrom);
                    int recFlagTo = this.m_patdefTable.getInt(patDefRow, this.m_patdefIndex_ReceiverFlagTo);
                    float recFlagBy = this.m_patdefTable.getFloat(patDefRow, this.m_patdefIndex_ReceiverFlagBy);
                    int recFlagStep = Math.round(recFlagBy);
                    recFlagStep = Math.max(recFlagStep, 1);
                    for (int srcFlag = srcFlagFrom; srcFlag <= srcFlagTo; srcFlag += srcFlagStep) {
                        for (int recFlag = recFlagFrom; recFlag <= recFlagTo; recFlag += recFlagStep) {
                            this.addEntryToTraceTable(srcLine, srcFlag, recLine, recFlag);
                        }
                    }
                }
                int num = 1 + this.m_traceID - 1000;
                String s = String.format("%d traces added to trace table", num);
                System.out.println(s);
                messageServer.setMessage_Level2(s);
            }
            if (this.m_traceTable.row_count() > 0) {
                this.m_diskTable.appendTable(this.m_traceTable);
                this.m_traceTable.row_clear(false);
            }
            this.m_diskTable.finishedAppending(null);
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper usePatRow = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(IProgressMonitor messageServer) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.m_aramFile));
            String inputAsciiLine = br.readLine();
            int currentPatDef = -9999;
            int currentUsePat = -9999;
            int currentShotID = 999;
            int currentRecID = 999;
            while (inputAsciiLine != null && !this.Halt) {
                int row;
                double y;
                double x;
                int flag;
                int k;
                int num;
                double dy;
                double dx;
                double elev;
                double toy;
                double tox;
                double fromy;
                int step;
                int row2;
                int type;
                float by;
                int to;
                int from;
                int line;
                ArrayList<String> tokens = Tools_Strings.tokenizer(inputAsciiLine);
                if (tokens.size() >= 6 && tokens.get(0).equalsIgnoreCase("SxAlloc")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    type = Integer.parseInt(tokens.get(5));
                    int row3 = this.m_sxallocTable.row_increment();
                    this.m_sxallocTable.putInt(row3, this.m_sxallocIndex_SourceLine, line);
                    this.m_sxallocTable.putInt(row3, this.m_sxallocIndex_SourceFlagFrom, from);
                    this.m_sxallocTable.putInt(row3, this.m_sxallocIndex_SourceFlagTo, to);
                    this.m_sxallocTable.putFloat(row3, this.m_sxallocIndex_SourceFlagBy, by);
                    this.m_sxallocTable.putInt(row3, this.m_sxallocIndex_Type, type);
                }
                if (tokens.size() >= 7 && tokens.get(0).equalsIgnoreCase("RxAlloc")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    type = Integer.parseInt(tokens.get(5));
                    String cable = tokens.get(6);
                    int row4 = this.m_rxallocTable.row_increment();
                    this.m_rxallocTable.putInt(row4, this.m_rxallocIndex_ReceiverLine, line);
                    this.m_rxallocTable.putInt(row4, this.m_rxallocIndex_ReceiverFlagFrom, from);
                    this.m_rxallocTable.putInt(row4, this.m_rxallocIndex_ReceiverFlagTo, to);
                    this.m_rxallocTable.putFloat(row4, this.m_rxallocIndex_ReceiverFlagBy, by);
                    this.m_rxallocTable.putInt(row4, this.m_rxallocIndex_Type, type);
                    this.m_rxallocTable.putString(row4, this.m_rxallocIndex_CableType, cable);
                }
                if (tokens.size() >= 2 && tokens.get(0).equalsIgnoreCase("USEPAT")) {
                    currentUsePat = Integer.parseInt(tokens.get(1));
                }
                if (tokens.size() >= 5 && tokens.get(0).equalsIgnoreCase("SP")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    row2 = this.m_usepatTable.row_increment();
                    this.m_usepatTable.putInt(row2, this.m_usepatIndex_PatDefNumber, currentUsePat);
                    this.m_usepatTable.putInt(row2, this.m_usepatIndex_SourceLine, line);
                    this.m_usepatTable.putInt(row2, this.m_usepatIndex_SourceFlagFrom, from);
                    this.m_usepatTable.putInt(row2, this.m_usepatIndex_SourceFlagTo, to);
                    this.m_usepatTable.putFloat(row2, this.m_usepatIndex_SourceFlagBy, by);
                }
                if (tokens.size() >= 2 && tokens.get(0).equalsIgnoreCase("PATDEF")) {
                    currentPatDef = Integer.parseInt(tokens.get(1));
                }
                if (tokens.size() >= 5 && tokens.get(0).equalsIgnoreCase("PAT")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    row2 = this.m_patdefTable.row_increment();
                    this.m_patdefTable.putInt(row2, this.m_patdefIndex_PatDefNumber, currentPatDef);
                    this.m_patdefTable.putInt(row2, this.m_patdefIndex_ReceiverLine, line);
                    this.m_patdefTable.putInt(row2, this.m_patdefIndex_ReceiverFlagFrom, from);
                    this.m_patdefTable.putInt(row2, this.m_patdefIndex_ReceiverFlagTo, to);
                    this.m_patdefTable.putFloat(row2, this.m_patdefIndex_ReceiverFlagBy, by);
                }
                if (tokens.size() >= 10 && tokens.get(0).equalsIgnoreCase("RXY")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    step = Math.round(by);
                    step = Math.max(step, 1);
                    double fromx = Double.parseDouble(tokens.get(5));
                    fromy = Double.parseDouble(tokens.get(6));
                    tox = Double.parseDouble(tokens.get(7));
                    toy = Double.parseDouble(tokens.get(8));
                    elev = Double.parseDouble(tokens.get(9));
                    dx = 0.0;
                    dy = 0.0;
                    if (to > from) {
                        dx = (tox - fromx) / (double)(to - from);
                        dy = (toy - fromy) / (double)(to - from);
                    }
                    num = 1 + (to - from) / step;
                    for (k = 0; k < num; ++k) {
                        flag = from + k * step;
                        x = fromx + dx * (double)(flag - from);
                        y = fromy + dy * (double)(flag - from);
                        row = this.m_receiverTable.row_increment();
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_ID, ++currentRecID);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_PointNumber, flag);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_LineNumber, line);
                        this.m_receiverTable.putInt(row, this.m_receiverIndex_PointIndex, 1);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_X, x);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_Y, y);
                        this.m_receiverTable.putDouble(row, this.m_receiverIndex_Z, elev);
                    }
                }
                if (tokens.size() >= 10 && tokens.get(0).equalsIgnoreCase("SXY")) {
                    line = Integer.parseInt(tokens.get(1));
                    from = Integer.parseInt(tokens.get(2));
                    to = Integer.parseInt(tokens.get(3));
                    by = Float.parseFloat(tokens.get(4));
                    step = Math.round(by);
                    step = Math.max(step, 1);
                    double fromx = Double.parseDouble(tokens.get(5));
                    fromy = Double.parseDouble(tokens.get(6));
                    tox = Double.parseDouble(tokens.get(7));
                    toy = Double.parseDouble(tokens.get(8));
                    elev = Double.parseDouble(tokens.get(9));
                    dx = 0.0;
                    dy = 0.0;
                    if (to > from) {
                        dx = (tox - fromx) / (double)(to - from);
                        dy = (toy - fromy) / (double)(to - from);
                    }
                    num = 1 + (to - from) / step;
                    for (k = 0; k < num; ++k) {
                        flag = from + k * step;
                        x = fromx + dx * (double)(flag - from);
                        y = fromy + dy * (double)(flag - from);
                        row = this.m_shotTable.row_increment();
                        this.m_shotTable.putInt(row, this.m_shotIndex_ID, ++currentShotID);
                        this.m_shotTable.putInt(row, this.m_shotIndex_PointNumber, flag);
                        this.m_shotTable.putInt(row, this.m_shotIndex_LineNumber, line);
                        this.m_shotTable.putInt(row, this.m_shotIndex_PointIndex, 1);
                        this.m_shotTable.putDouble(row, this.m_shotIndex_X, x);
                        this.m_shotTable.putDouble(row, this.m_shotIndex_Y, y);
                        this.m_shotTable.putDouble(row, this.m_shotIndex_Z, elev);
                    }
                }
                inputAsciiLine = br.readLine();
            }
            br.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

