/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Synthetic.SyntheticCreator;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class Action_ExportSyntheticBinaryGLI
extends Action_Base {
    public String OutputPath;
    public ParameterTree ParamTree;
    protected SyntheticCreator m_syntheticCreator;

    public Action_ExportSyntheticBinaryGLI() {
        this.RequiresRefractionStaticsProject = false;
        this.Description = "Create binary GLI file using synthetic geometry and picks";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            boolean bOk;
            boolean bOk2;
            boolean bOk3;
            boolean bOk4;
            String sShotPath = this.OutputPath + "/shot.dat";
            String sRecPath = this.OutputPath + "/rec.dat";
            String sPickPath = this.OutputPath + "/pick.dat";
            File pickFile = new File(sPickPath);
            if (pickFile.exists() && !(bOk4 = pickFile.delete())) {
                throw new Exception("unable to delete : " + sPickPath);
            }
            File shotFile = new File(sShotPath);
            if (shotFile.exists() && !(bOk3 = shotFile.delete())) {
                throw new Exception("unable to delete : " + sShotPath);
            }
            File recFile = new File(sRecPath);
            if (recFile.exists() && !(bOk2 = recFile.delete())) {
                throw new Exception("unable to delete : " + sRecPath);
            }
            File outputDir = new File(this.OutputPath);
            if (outputDir.exists() && !(bOk = outputDir.delete())) {
                throw new Exception("unable to delete : " + this.OutputPath);
            }
            this.m_syntheticCreator = new SyntheticCreator();
            this.m_syntheticCreator.createGeometry(this.ParamTree);
            this.m_syntheticCreator.setVelocityModel(this.ParamTree);
            Table_Abstract shotTable = this.m_syntheticCreator.getShotTable();
            Table_Abstract recTable = this.m_syntheticCreator.getReceiverTable();
            int nShots = shotTable.row_count();
            int nRecs = recTable.row_count();
            System.out.println("nShots = " + Integer.toString(nShots));
            System.out.println("nRecs = " + Integer.toString(nRecs));
            if (!outputDir.mkdir()) {
                throw new Exception("unable to create directory : " + this.OutputPath);
            }
            System.out.println("writing shots");
            this.outputTable(shotTable, shotFile);
            System.out.println("writing recs");
            this.outputTable(recTable, recFile);
            System.out.println("writing picks");
            this.outputPicks(pickFile);
            System.out.println("Success!");
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    private void outputTable(Table_Abstract table, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception("unable to create file : " + file.getAbsolutePath());
        }
        FileChannel wChannel = fileOutputStream.getChannel();
        int nMagic = 1341;
        int nRows = table.row_count();
        int RowSizeInBytes = 72;
        int fileSize = nRows * RowSizeInBytes;
        ByteBuffer bb = ByteBuffer.allocate(fileSize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        String colNameID = table.name() + "ID";
        int colID = table.column_indexOfColumn(colNameID);
        int colKilled = table.column_indexOfColumn("Killed");
        int colLine = table.column_indexOfColumn("LineNumber");
        int colPoint = table.column_indexOfColumn("PointNumber");
        int colIndex = table.column_indexOfColumn("PointIndex");
        int colX = table.column_indexOfColumn("Easting");
        int colY = table.column_indexOfColumn("Northing");
        int colZ = table.column_indexOfColumn("Elevation");
        int colD = -999;
        if (table.column_exists("PointDepth")) {
            colD = table.column_indexOfColumn("PointDepth");
        }
        int colU = -999;
        if (table.column_exists("UpholeTime")) {
            colU = table.column_indexOfColumn("UpholeTime");
        }
        int colW = -999;
        if (table.column_exists("WaterDepth")) {
            colW = table.column_indexOfColumn("WaterDepth");
        }
        for (int iRow = 0; iRow < nRows; ++iRow) {
            bb.putInt(90909);
            bb.putInt(table.getInt(iRow, colID));
            bb.putInt(table.getInt(iRow, colLine));
            bb.putInt(table.getInt(iRow, colPoint));
            bb.putInt(table.getInt(iRow, colIndex));
            bb.putInt(table.getInt(iRow, colKilled));
            bb.putDouble(table.getDouble(iRow, colX));
            bb.putDouble(table.getDouble(iRow, colY));
            bb.putDouble(table.getDouble(iRow, colZ));
            if (colD >= 0) {
                bb.putDouble(table.getDouble(iRow, colD));
            } else {
                bb.putDouble(0.0);
            }
            if (colU >= 0) {
                bb.putDouble(table.getDouble(iRow, colU));
            } else {
                bb.putDouble(0.0);
            }
            if (colW >= 0) {
                bb.putDouble(table.getDouble(iRow, colW));
                continue;
            }
            bb.putDouble(0.0);
        }
        bb.flip();
        wChannel.write(bb);
        wChannel.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void outputPicks(File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception("unable to create file : " + file.getAbsolutePath());
        }
        FileChannel wChannel = fileOutputStream.getChannel();
        int nRowSize = 12;
        ByteBuffer bb = ByteBuffer.allocate(nRowSize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.m_syntheticCreator.createBinaryPicks(bb, wChannel);
        wChannel.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

