/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Action_ExportGLI
extends Action_Base {
    public String FileName;
    public boolean ApplyPolygon = false;
    public Java2D_Polygon Polygon = null;
    public boolean CreateSyntheticPicks = false;
    public double V0 = 3000.0;
    public double V1 = 6000.0;
    public double V2 = 8000.0;
    public double Z1 = -100.0;
    public double Z2 = -800.0;
    protected DelayTimeMath m_shotMath = new DelayTimeMath();
    protected DelayTimeMath m_recMath = new DelayTimeMath();

    public Action_ExportGLI() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create GLI file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected void createSyntheticPicks(Ensemble ensemble) {
        try {
            this.m_shotMath.MaxBranch = 2;
            this.m_shotMath.Velocity[0] = this.V0;
            this.m_shotMath.Velocity[1] = this.V1;
            this.m_shotMath.Velocity[2] = this.V2;
            this.m_recMath.MaxBranch = 2;
            this.m_recMath.Velocity[0] = this.V0;
            this.m_recMath.Velocity[1] = this.V1;
            this.m_recMath.Velocity[2] = this.V2;
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexRecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexShotZ = ensemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract h = ensemble.trace(n).header();
                float offset = (float)h.getDouble(indexOff);
                this.m_shotMath.Thickness[0] = h.getDouble(indexShotZ) - this.Z1;
                this.m_shotMath.Thickness[1] = this.Z1 - this.Z2;
                float sdt1 = (float)this.m_shotMath.computeDelayTime(1);
                float sdt2 = (float)this.m_shotMath.computeDelayTime(2);
                this.m_recMath.Thickness[0] = h.getDouble(indexRecZ) - this.Z1;
                this.m_recMath.Thickness[1] = this.Z1 - this.Z2;
                float rdt1 = (float)this.m_recMath.computeDelayTime(1);
                float rdt2 = (float)this.m_recMath.computeDelayTime(2);
                float min = 1000.0f * offset / (float)this.V0;
                float t1 = 1000.0f * offset / (float)this.V1 + sdt1 + rdt1;
                min = Math.min(min, t1);
                float t2 = 1000.0f * offset / (float)this.V2 + sdt2 + rdt2;
                min = Math.min(min, t2);
                h.putFloat(indexPick, min);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String name = this.Hasher.string_get("Name", "Trace");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = project.shotTable();
            int columnShotID = shotTable.column_indexOfColumn("ShotID");
            int columnKilled = shotTable.column_indexOfColumn("Killed");
            int columnX = shotTable.column_indexOfColumn("Easting");
            int columnY = shotTable.column_indexOfColumn("Northing");
            int columnZ = shotTable.column_indexOfColumn("Elevation");
            int columnUphole = -9999;
            int columnDepth = -9999;
            if (shotTable.column_exists("UpholeTime")) {
                columnUphole = shotTable.column_indexOfColumn("UpholeTime");
            }
            if (shotTable.column_exists("PointDepth")) {
                columnDepth = shotTable.column_indexOfColumn("PointDepth");
            }
            double uphole = 0.0;
            double depth = 0.0;
            Ensemble ensemble = new Ensemble();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.FileName));
            for (int n = 0; n < shotTable.row_count(); ++n) {
                double sx = shotTable.getDouble(n, columnX);
                double sy = shotTable.getDouble(n, columnY);
                boolean polyShot = true;
                if (this.ApplyPolygon && this.Polygon != null) {
                    polyShot = this.Polygon.contains(sx, sy);
                }
                if (polyShot && !shotTable.getBool(n, columnKilled)) {
                    int shotID = shotTable.getInt(n, columnShotID);
                    ensemble.clearTraces(false);
                    project.ensemble_Shot(ensemble, shotID, false);
                    if (this.CreateSyntheticPicks) {
                        this.createSyntheticPicks(ensemble);
                    }
                    writer.write("shot ");
                    writer.write(Integer.toString(shotID) + " ");
                    writer.write(shotTable.getString(n, columnX) + " ");
                    writer.write(shotTable.getString(n, columnY) + " ");
                    writer.write(shotTable.getString(n, columnZ) + " ");
                    if (columnUphole >= 0) {
                        writer.write(shotTable.getString(n, columnUphole) + " ");
                    } else {
                        writer.write("0 ");
                    }
                    if (columnDepth >= 0) {
                        writer.write(shotTable.getString(n, columnDepth) + " ");
                    } else {
                        writer.write("0 ");
                    }
                    writer.newLine();
                    int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
                    int indexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
                    int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
                    int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
                    int indexRecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
                    int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
                    for (int k = 0; k < ensemble.traceCount(); ++k) {
                        EnsembleTrace trace = ensemble.trace(k);
                        float pick = trace.header().getFloat(indexPick);
                        double rx = trace.header().getDouble(indexRecX);
                        double ry = trace.header().getFloat(indexRecY);
                        boolean poly = true;
                        if (this.ApplyPolygon && this.Polygon != null) {
                            poly = this.Polygon.contains(rx, ry);
                        }
                        if (!poly || !(pick > 0.0f)) continue;
                        writer.write("trace ");
                        int recID = trace.header().getInt(indexRecID);
                        writer.write(Integer.toString(recID) + " ");
                        writer.write(trace.header().getString(indexRecX) + " ");
                        writer.write(trace.header().getString(indexRecY) + " ");
                        writer.write(trace.header().getString(indexRecZ) + " ");
                        writer.write(trace.header().getString(indexPick) + " ");
                        writer.newLine();
                    }
                }
                messageServer.setPercentDone(100.0 * (double)n / (double)shotTable.row_count());
                if (!this.Halt) continue;
                n = 100000000;
            }
            writer.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

