/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class Action_ExportBinaryGLI
extends Action_Base {
    public String OutputPath;
    public boolean ApplyPolygon = false;
    public Java2D_Polygon Polygon = null;
    public RefractionStaticsProject Project = null;
    HashMap_Integer m_mapShot = new HashMap_Integer();
    HashMap_Integer m_mapRec = new HashMap_Integer();

    public Action_ExportBinaryGLI() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create GLI file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            boolean bOk;
            boolean bOk2;
            boolean bOk3;
            boolean bOk4;
            String sFlatironsProject = "stratton";
            String sShotPath = this.OutputPath + "/shot.dat";
            String sRecPath = this.OutputPath + "/rec.dat";
            String sPickPath = this.OutputPath + "/pick.dat";
            File pickFile = new File(sPickPath);
            if (pickFile.exists() && !(bOk4 = pickFile.delete())) {
                throw new Exception("unable to delete : " + sPickPath);
            }
            File shotFile = new File(sShotPath);
            if (shotFile.exists() && !(bOk3 = shotFile.delete())) {
                throw new Exception("unable to delete : " + sShotPath);
            }
            File recFile = new File(sRecPath);
            if (recFile.exists() && !(bOk2 = recFile.delete())) {
                throw new Exception("unable to delete : " + sRecPath);
            }
            File outputDir = new File(this.OutputPath);
            if (outputDir.exists() && !(bOk = outputDir.delete())) {
                throw new Exception("unable to delete : " + this.OutputPath);
            }
            RefractionStaticsProject project = this.Project == null ? RefractionStaticsProject.singleton() : this.Project;
            Table_Abstract shotTable = project.getShotTable();
            Table_Abstract recTable = project.getRecTable();
            int nShots = shotTable.row_count();
            int nRecs = recTable.row_count();
            System.out.println("nShots = " + Integer.toString(nShots));
            System.out.println("nRecs = " + Integer.toString(nRecs));
            if (!outputDir.mkdir()) {
                throw new Exception("unable to create directory : " + this.OutputPath);
            }
            System.out.println("writing shots");
            this.outputTable(shotTable, shotFile, this.m_mapShot);
            System.out.println("writing recs");
            this.outputTable(recTable, recFile, this.m_mapRec);
            System.out.println("writing picks");
            this.outputPicks(messageServer, project, pickFile);
            System.out.println("Success!");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    private void outputTable(Table_Abstract table, File file, HashMap_Integer map) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception("unable to create file : " + file.getAbsolutePath());
        }
        FileChannel wChannel = fileOutputStream.getChannel();
        int nMagic = 1341;
        int nRows = table.row_count();
        int RowSizeInBytes = 72;
        int fileSize = nRows * RowSizeInBytes;
        int i = 5;
        ByteBuffer bb = ByteBuffer.allocate(fileSize);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        String colNameID = table.name() + "ID";
        int colID = table.column_indexOfColumn(colNameID);
        int colKilled = table.column_indexOfColumn("Killed");
        int colLine = table.column_indexOfColumn("LineNumber");
        int colPoint = table.column_indexOfColumn("PointNumber");
        int colIndex = table.column_indexOfColumn("PointIndex");
        int colX = table.column_indexOfColumn("Easting");
        int colY = table.column_indexOfColumn("Northing");
        int colZ = table.column_indexOfColumn("Elevation");
        int colD = -999;
        if (table.column_exists("PointDepth")) {
            colD = table.column_indexOfColumn("PointDepth");
        }
        int colU = -999;
        if (table.column_exists("UpholeTime")) {
            colU = table.column_indexOfColumn("UpholeTime");
        }
        int colW = -999;
        if (table.column_exists("WaterDepth")) {
            colW = table.column_indexOfColumn("WaterDepth");
        }
        for (int iRow = 0; iRow < nRows; ++iRow) {
            boolean poly = true;
            if (this.ApplyPolygon && this.Polygon != null) {
                poly = this.Polygon.contains(table.getDouble(iRow, colX), table.getDouble(iRow, colY));
            }
            if (!poly) continue;
            map.put(table.getInt(iRow, colID), iRow);
            bb.putInt(90909);
            bb.putInt(table.getInt(iRow, colID));
            bb.putInt(table.getInt(iRow, colLine));
            bb.putInt(table.getInt(iRow, colPoint));
            bb.putInt(table.getInt(iRow, colIndex));
            bb.putInt(table.getInt(iRow, colKilled));
            bb.putDouble(table.getDouble(iRow, colX));
            bb.putDouble(table.getDouble(iRow, colY));
            bb.putDouble(table.getDouble(iRow, colZ));
            if (colD >= 0) {
                bb.putDouble(table.getDouble(iRow, colD));
            } else {
                bb.putDouble(0.0);
            }
            if (colU >= 0) {
                bb.putDouble(table.getDouble(iRow, colU));
            } else {
                bb.putDouble(0.0);
            }
            if (colW >= 0) {
                bb.putDouble(table.getDouble(iRow, colW));
                continue;
            }
            bb.putDouble(0.0);
        }
        bb.flip();
        wChannel.write(bb);
        wChannel.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void outputPicks(IProgressMonitor messageServer, RefractionStaticsProject project, File file) throws Exception {
        ITraceTable traceTable = project.traceTableWrapper().traceTable();
        if (!traceTable.column_exists("ShotID")) {
            throw new Exception("trace table ShotID does not exist");
        }
        if (!traceTable.column_exists("ReceiverID")) {
            throw new Exception("trace table ReceiverID does not exist");
        }
        if (!traceTable.column_exists("FBP_User")) {
            throw new Exception("trace table FBP_User does not exist");
        }
        if (!traceTable.column_exists("Killed")) {
            throw new Exception("trace table Killed does not exist");
        }
        int iColumnShotID = traceTable.column_indexOfColumn("ShotID");
        int iColumnRecID = traceTable.column_indexOfColumn("ReceiverID");
        int iColumnPickTime = traceTable.column_indexOfColumn("FBP_User");
        int iColumnKilled = traceTable.column_indexOfColumn("Killed");
        long nRows = traceTable.rowCount();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (!file.exists() && !file.createNewFile()) {
            throw new Exception("unable to create file : " + file.getAbsolutePath());
        }
        FileChannel wChannel = fileOutputStream.getChannel();
        int nRowSize = 12;
        int nRowsPerChunk = 100000;
        ByteBuffer bb_chunk = ByteBuffer.allocate(nRowsPerChunk * nRowSize);
        bb_chunk.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer bb_single = ByteBuffer.allocate(nRowSize);
        bb_single.order(ByteOrder.LITTLE_ENDIAN);
        bb_single.clear();
        bb_chunk.clear();
        int num_in_this_chunk = 0;
        for (long iRow = 0L; iRow < nRows; ++iRow) {
            int iShotID = traceTable.getInt(iRow, iColumnShotID);
            int iRecID = traceTable.getInt(iRow, iColumnRecID);
            float fPick = traceTable.getFloat(iRow, iColumnPickTime);
            if (iRow % 100000L == 0L) {
                messageServer.setPercentDone(100.0 * (double)iRow / (double)nRows);
                System.out.println("iRow = " + iRow);
            }
            if (!(fPick > 0.0f) || !this.m_mapShot.containsKey(iShotID) || !this.m_mapRec.containsKey(iRecID)) continue;
            bb_chunk.putInt(iShotID);
            bb_chunk.putInt(iRecID);
            bb_chunk.putFloat(fPick);
            if (++num_in_this_chunk < nRowsPerChunk) continue;
            bb_chunk.flip();
            wChannel.write(bb_chunk);
            bb_chunk.clear();
            num_in_this_chunk = 0;
        }
        if (num_in_this_chunk > 0) {
            ByteBuffer bb_last = ByteBuffer.allocate(num_in_this_chunk * nRowSize);
            bb_last.order(ByteOrder.LITTLE_ENDIAN);
            for (int n = 0; n < num_in_this_chunk * nRowSize; ++n) {
                bb_last.put(bb_chunk.get(n));
            }
            bb_last.flip();
            wChannel.write(bb_last);
            bb_last.clear();
        }
        wChannel.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

