/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.lictext.LineType;
import com.macrovision.flexlm.lictext.TokenizedLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TokenizedOptionsLine
extends TokenizedLine
implements FlexlmInternalConstants,
LineType {
    private static Map OPTION_TYPES = new HashMap();
    private static Map OPTION_TYPE_STRINGS;

    protected TokenizedOptionsLine(LineNumberReader lineNumberReader, String string) throws IOException {
        super(lineNumberReader, string);
        super.doNextLine(this);
    }

    @Override
    public int getLineType(String string) {
        if ((string = string.trim()).length() == 0) {
            return 0;
        }
        if (string.charAt(0) == '#') {
            return 8;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        Integer n = (Integer)OPTION_TYPES.get(string2);
        return n == null ? 0 : n;
    }

    @Override
    public String typeString() {
        if (this.type == 0) {
            return "UNKNOWN";
        }
        String string = (String)OPTION_TYPE_STRINGS.get(new Integer(this.type));
        return string == null ? "undefined type: " + this.type : string;
    }

    static {
        OPTION_TYPES.put("BORROW_LOWWATER", new Integer(1000));
        OPTION_TYPES.put("DEBUGLOG", new Integer(1001));
        OPTION_TYPES.put("EXCLUDE", new Integer(1002));
        OPTION_TYPES.put("EXCLUDE_BORROW", new Integer(1003));
        OPTION_TYPES.put("EXCLUDEALL", new Integer(1004));
        OPTION_TYPES.put("EXCLUDE_ENTITLEMENT", new Integer(1020));
        OPTION_TYPES.put("GROUP", new Integer(1005));
        OPTION_TYPES.put("GROUPCASEINSENSITIVE", new Integer(1006));
        OPTION_TYPES.put("HOST_GROUP", new Integer(1007));
        OPTION_TYPES.put("INCLUDE", new Integer(1008));
        OPTION_TYPES.put("INCLUDE_BORROW", new Integer(1009));
        OPTION_TYPES.put("INCLUDEALL", new Integer(1010));
        OPTION_TYPES.put("INCLUDE_ENTITLEMENT", new Integer(1021));
        OPTION_TYPES.put("LINGER", new Integer(1011));
        OPTION_TYPES.put("MAX", new Integer(1012));
        OPTION_TYPES.put("MAX_BORROW_HOURS", new Integer(1013));
        OPTION_TYPES.put("MAX_OVERDRAFT", new Integer(1014));
        OPTION_TYPES.put("NOLOG", new Integer(1015));
        OPTION_TYPES.put("REPORTLOG", new Integer(1016));
        OPTION_TYPES.put("RESERVE", new Integer(1017));
        OPTION_TYPES.put("TIMEOUT", new Integer(1018));
        OPTION_TYPES.put("TIMEOUTALL", new Integer(1019));
        OPTION_TYPES.put("#", new Integer(8));
        OPTION_TYPES.put("AUTOMATIC_REREAD", new Integer(1022));
        OPTION_TYPES.put("ACTIVATION_EXPIRY_DAYS", new Integer(1023));
        OPTION_TYPES.put("ACTIVATION_LOWWATER", new Integer(1024));
        OPTION_TYPE_STRINGS = new HashMap();
        for (Map.Entry entry : OPTION_TYPES.entrySet()) {
            OPTION_TYPE_STRINGS.put(entry.getValue(), entry.getKey());
        }
    }
}

