/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.wavelet;

public class CosineBellWavelet {
    public static float[] createRealWavelet(int nf, int if0, float df, float flc, float flp, float fhp, float fhc) {
        float lf = (float)(1.5707963267948966 / (double)(flp - flc));
        float hf = (float)(1.5707963267948966 / (double)(fhc - fhp));
        float[] w = new float[nf];
        for (int i = 0; i < nf; ++i) {
            float f = df * (float)(if0 + i);
            w[i] = f <= flc ? 0.0f : (f < flp ? (float)Math.cos(lf * (f - flc)) : (f < fhp ? 1.0f : (f < fhc ? (float)Math.sin(hf * (f - fhp)) : 0.0f)));
        }
        return w;
    }

    public static float[] createComplexWavelet(int nf, int if0, float df, float flc, float flp, float fhp, float fhc) {
        float lf = (float)(1.5707963267948966 / (double)(flp - flc));
        float hf = (float)(1.5707963267948966 / (double)(fhc - fhp));
        float[] w = new float[2 * nf];
        for (int i = 0; i < nf; ++i) {
            float f = df * (float)(if0 + i);
            w[2 * i] = f <= flc ? 0.0f : (f < flp ? (float)Math.sin(lf * (f - flc)) : (f < fhp ? 1.0f : (f < fhc ? (float)Math.cos(hf * (f - fhp)) : 0.0f)));
        }
        return w;
    }
}

