/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.seiszip;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Random;
import java.util.logging.Logger;
import org.javaseis.seiszip.CompressedData;
import org.javaseis.seiszip.DataCorruptedException;
import org.javaseis.seiszip.HdrCompressor;
import org.javaseis.seiszip.SeisPEG;
import org.javaseis.seiszip.Transformer;

public class CompressorTest {
    private static final Logger LOG = Logger.getLogger("org.javaseis.seiszip");
    private static final int SLEEP_MS = 10;
    private static final int NRETRIES = 30000;
    private static final int SIZEOF_FLOAT = 4;
    private static final int SIZEOF_INT = 4;
    static final int NATIVE_HDRLEN = 2;
    private static final int SWAP_FLAG = 1;
    private static final int SWAP_FLAG_REVERSED = 0x1000000;

    public static void writeFloats(ObjectOutputStream out, float[][] data, int n, int nTraces) throws IOException {
        if (data.length < 1 || nTraces < 1) {
            return;
        }
        byte[] cTrace = new byte[(n + 2) * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(cTrace);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(0, 1);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int j = 0; j < nTraces; ++j) {
            for (int i = 0; i < n; ++i) {
                floatBuffer.put(2 + i, data[j][i]);
            }
            out.write(cTrace);
        }
    }

    public static void writeInts(RandomAccessFile out, int[][] data, int n, int nTraces) throws IOException {
        if (data.length < 1 || nTraces < 1) {
            return;
        }
        byte[] cTrace = new byte[(n + 2) * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(cTrace);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(0, 1);
        for (int j = 0; j < nTraces; ++j) {
            for (int i = 0; i < n; ++i) {
                intBuffer.put(2 + i, data[j][i]);
            }
            out.write(cTrace);
        }
    }

    static void readFloats(ObjectInputStream in, float[][] data, int n, int nTraces) throws IOException {
        if (data.length < 1) {
            return;
        }
        byte[] cTrace = new byte[(n + 2) * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(cTrace);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int j = 0; j < nTraces; ++j) {
            int iswap;
            in.readFully(cTrace);
            if (j == 0 && (iswap = intBuffer.get(0)) != 1) {
                throw new DataCorruptedException("Swap flag is not recognized (" + iswap + "!=" + 1 + ")");
            }
            for (int i = 0; i < n; ++i) {
                data[j][i] = floatBuffer.get(2 + i);
            }
        }
    }

    static void readInts(RandomAccessFile in, int[][] data, int n, int nTraces) throws IOException {
        if (data.length < 1) {
            return;
        }
        byte[] cTrace = new byte[(n + 2) * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(cTrace);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        for (int j = 0; j < nTraces; ++j) {
            in.readFully(cTrace);
            if (j == 0 && intBuffer.get(0) != 1) {
                throw new DataCorruptedException("Swap flag is not recognized");
            }
            for (int i = 0; i < n; ++i) {
                data[j][i] = intBuffer.get(2 + i);
            }
        }
    }

    private static void originalTest(boolean writingData) throws Exception {
        float distortion = 1.0E-5f;
        int n2 = 0;
        int n1 = 0;
        int verticalBlockSize = 0;
        int horizontalBlockSize = 0;
        int verticalTransLength = 0;
        int horizontalTransLength = 0;
        long randomSeed = 23148L;
        int div = 1;
        int testDataCount = 0;
        int ntests = 9;
        for (int kTest = 0; kTest < ntests; ++kTest) {
            if (kTest == 0) {
                n2 = 127;
                n1 = 513;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 1 || kTest == 2) {
                n2 = 112;
                n1 = 528;
                verticalBlockSize = 16;
                horizontalBlockSize = 16;
                if (kTest == 1) {
                    verticalTransLength = 16;
                    horizontalTransLength = 16;
                } else if (kTest == 2) {
                    verticalTransLength = 8;
                    horizontalTransLength = 8;
                }
            } else if (kTest == 3) {
                n2 = 8200;
                n1 = 8;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 4) {
                n2 = 2400;
                n1 = 24;
                verticalBlockSize = 24;
                horizontalBlockSize = 24;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 5) {
                n2 = 128;
                n1 = 128;
                verticalBlockSize = 32;
                horizontalBlockSize = 16;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 6) {
                n2 = 127;
                n1 = 129;
                verticalBlockSize = 16;
                horizontalBlockSize = 16;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 7) {
                n2 = 353;
                n1 = 235;
                verticalBlockSize = 32;
                horizontalBlockSize = 32;
                verticalTransLength = 16;
                horizontalTransLength = 16;
            } else if (kTest == 8) {
                n2 = 100;
                n1 = 501;
                verticalBlockSize = 64;
                horizontalBlockSize = 64;
                verticalTransLength = 16;
                horizontalTransLength = 16;
                distortion = 1.0E-5f;
            } else assert (false);
            SeisPEG c = new SeisPEG(n1, n2, distortion, verticalBlockSize, horizontalBlockSize, verticalTransLength, horizontalTransLength);
            float[][] data = c.uncompressedBufferAlloc();
            CompressedData compressedData = c.compressedBufferAlloc();
            for (int testN = 0; testN < 3; ++testN) {
                int i;
                int j;
                int icount = 0;
                if (kTest == 4) {
                    for (int j2 = 0; j2 < data.length; ++j2) {
                        for (int i2 = 0; i2 < data[0].length; ++i2) {
                            data[j2][i2] = -((float)(icount / div));
                            ++icount;
                        }
                    }
                } else if (kTest == 6) {
                    Random random = new Random(randomSeed);
                    for (int j3 = 0; j3 < data.length; ++j3) {
                        for (int i3 = 0; i3 < data[0].length; ++i3) {
                            data[j3][i3] = (random.nextFloat() - 0.5f) * 100.0f;
                        }
                    }
                } else {
                    for (int j4 = 0; j4 < data.length; ++j4) {
                        for (int i4 = 0; i4 < data[0].length; ++i4) {
                            data[j4][i4] = icount / div;
                            ++icount;
                        }
                    }
                }
                compressedData = c.compress(data, compressedData);
                compressedData.checkIntegrity();
                if (testN == 2) {
                    compressedData = c.compress(data, compressedData);
                    compressedData.checkIntegrity();
                }
                if (testN == 1) {
                    c = new SeisPEG(compressedData);
                }
                c.uncompress(compressedData, data);
                compressedData.checkIntegrity();
                if (testN == 2) {
                    c.uncompress(compressedData, data);
                    compressedData.checkIntegrity();
                }
                String fileName = "TestData" + testDataCount;
                if (testN == 0 && writingData) {
                    ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(fileName));
                    CompressorTest.writeFloats(out, data, data[0].length, data.length);
                    out.close();
                } else if (!writingData && testDataCount != 8) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(fileName));
                    float[][] readData = new float[data.length][data[0].length];
                    CompressorTest.readFloats(in, readData, readData[0].length, readData.length);
                    for (j = 0; j < data.length; ++j) {
                        for (i = 0; i < data[0].length; ++i) {
                            if (Math.abs(readData[j][i]) > 1.0f) {
                                assert (Math.abs((data[j][i] - readData[j][i]) / readData[j][i]) < 5.0E-4f) : "Expected uncompressed data value " + readData[j][i] + " but got value " + data[j][i];
                                continue;
                            }
                            assert (Math.abs(data[j][i] - readData[j][i]) < 4.0E-4f) : "Expected uncompressed data value " + readData[j][i] + " but got value " + data[j][i] + "(j=" + j + ",i=" + i + ")";
                        }
                    }
                    in.close();
                }
                float tolerableError = 0.07f;
                if (kTest == 6) {
                    tolerableError = 0.001f;
                }
                if (kTest == 7) {
                    tolerableError = 0.09f;
                }
                icount = 0;
                Random random = new Random(randomSeed);
                for (j = 0; j < data.length; ++j) {
                    for (i = 0; i < data[0].length; ++i) {
                        float expectedVal = kTest == 4 ? -((float)(icount / div)) : (kTest == 6 ? (random.nextFloat() - 0.5f) * 100.0f : (float)(icount / div));
                        float err = (double)Math.abs(expectedVal) < 1.0 ? Math.abs(data[j][i] - expectedVal) : Math.abs((data[j][i] - expectedVal) / expectedVal);
                        if (icount != 0 && err > tolerableError) {
                            throw new Exception("data[" + j + "][" + i + "]= " + data[j][i] + " which is not close enough to " + expectedVal + " in test " + kTest);
                        }
                        ++icount;
                    }
                }
            }
            ++testDataCount;
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.originalTest ***** SUCCESS *****");
    }

    private static void integrityTest() {
        Transformer.c_integrityTest = true;
        int paddedN2 = 0;
        int paddedN1 = 0;
        int verticalBlockSize = 0;
        int horizontalBlockSize = 0;
        int verticalTransLength = 0;
        int horizontalTransLength = 0;
        int div = 1;
        int ntests = 5;
        for (int j = 0; j < ntests; ++j) {
            int i;
            if (j == 0) {
                paddedN2 = 128;
                paddedN1 = 512;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (j == 1 || j == 2) {
                paddedN2 = 112;
                paddedN1 = 528;
                verticalBlockSize = 16;
                horizontalBlockSize = 16;
                if (j == 1) {
                    verticalTransLength = 16;
                    horizontalTransLength = 16;
                } else if (j == 2) {
                    verticalTransLength = 8;
                    horizontalTransLength = 8;
                }
            } else if (j == 3) {
                paddedN2 = 8200;
                paddedN1 = 8;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (j == 4) {
                paddedN2 = 2400;
                paddedN1 = 24;
                verticalBlockSize = 24;
                horizontalBlockSize = 24;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else {
                throw new RuntimeException("Invalid test");
            }
            SeisPEG seisPEG = new SeisPEG();
            int nsampsTotal = paddedN2 * paddedN1;
            float[] traces = new float[nsampsTotal * 4];
            int outputBufferSize = nsampsTotal * 4 * 4;
            byte[] cfsData = new byte[outputBufferSize];
            if (j == 4) {
                for (i = 0; i < nsampsTotal; ++i) {
                    traces[i] = -((float)(i / div));
                }
            } else {
                for (i = 0; i < nsampsTotal; ++i) {
                    traces[i] = i / div;
                }
            }
            float distortion = 0.1f;
            float ftGainExponent = 0.0f;
            int nbytes = seisPEG.compress2D(traces, paddedN1, paddedN2, paddedN1, paddedN2, distortion, ftGainExponent, verticalBlockSize, horizontalBlockSize, verticalTransLength, horizontalTransLength, cfsData, outputBufferSize);
            assert (nbytes != 0);
            seisPEG.uncompress2D(cfsData, outputBufferSize, traces);
            int nwrong = 0;
            for (i = 0; i < nsampsTotal; ++i) {
                if (j == 4 && traces[i] != -((float)(i / div)) || j != 4 && traces[i] != (float)(i / div)) {
                    LOG.info("traces[" + i + "]= " + traces[i] + " which is != " + (float)i);
                    ++nwrong;
                }
                if (nwrong == 5 && (j == 4 ? !$assertionsDisabled && traces[i] != -((float)(i / div)) : !$assertionsDisabled && traces[i] != (float)(i / div))) {
                    throw new AssertionError();
                }
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.integrityTest ***** SUCCESS *****");
    }

    private static void badAmplitudeTest() throws Exception {
        float distortion = 0.3f;
        int n2 = 0;
        int n1 = 0;
        int verticalBlockSize = 0;
        int horizontalBlockSize = 0;
        int verticalTransLength = 0;
        int horizontalTransLength = 0;
        CompressedData compressedData = null;
        int ntests = 2;
        for (int kTest = 0; kTest < ntests; ++kTest) {
            int i;
            int j;
            if (kTest == 0) {
                n2 = 127;
                n1 = 513;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 1) {
                n2 = 128;
                n1 = 512;
                verticalBlockSize = 16;
                horizontalBlockSize = 16;
                verticalTransLength = 16;
                horizontalTransLength = 16;
            } else assert (false);
            SeisPEG c = new SeisPEG(n1, n2, distortion, verticalBlockSize, horizontalBlockSize, verticalTransLength, horizontalTransLength);
            float[][] traces = c.uncompressedBufferAlloc();
            if (kTest == 0) {
                compressedData = c.compressedBufferAlloc();
            }
            for (j = 0; j < traces.length; ++j) {
                for (i = 0; i < traces[j].length; ++i) {
                    if (j == traces.length / 2 && i == traces[j].length / 2) {
                        if (kTest == 0) {
                            traces[j][i] = 1.0E16f;
                            continue;
                        }
                        traces[j][i] = -1.0E16f;
                        continue;
                    }
                    traces[j][i] = (j + 1) * 1000 + (i + 1);
                }
            }
            compressedData = c.compress(traces, compressedData);
            if (kTest == 0) {
                c.uncompress(compressedData, traces);
            } else {
                c.uncompress(compressedData.getData(), compressedData.getDataLength(), traces);
            }
            for (j = 0; j < traces.length; ++j) {
                for (i = 0; i < traces[j].length; ++i) {
                    float expectedValue = j == 0 && i < 11 ? 0.0f : (j == traces.length / 2 && i == traces[j].length / 2 ? (kTest == 0 ? 1.0E16f : -1.0E16f) : (float)((j + 1) * 1000 + (i + 1)));
                    assert (traces[j][i] == expectedValue) : traces[j][i] + "!=" + expectedValue + " " + j + " " + i;
                }
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.badAmplitudeTest ***** SUCCESS *****");
    }

    private static void combinedTest() throws Exception {
        float distortion = 0.3f;
        int n2 = 0;
        int n1 = 0;
        int verticalBlockSize = 0;
        int horizontalBlockSize = 0;
        int verticalTransLength = 0;
        int horizontalTransLength = 0;
        int hdrLength = 73;
        int ntests = 4;
        for (int kTest = 0; kTest < ntests; ++kTest) {
            int i;
            int j;
            if (kTest == 0 || kTest == 1) {
                n2 = 127;
                n1 = 513;
                verticalBlockSize = 8;
                horizontalBlockSize = 8;
                verticalTransLength = 8;
                horizontalTransLength = 8;
            } else if (kTest == 2 || kTest == 3) {
                n2 = 128;
                n1 = 512;
                verticalBlockSize = 16;
                horizontalBlockSize = 16;
                verticalTransLength = 16;
                horizontalTransLength = 16;
            } else assert (false);
            SeisPEG c = new SeisPEG(n1, n2, distortion, verticalBlockSize, horizontalBlockSize, verticalTransLength, horizontalTransLength);
            float[][] traces = c.uncompressedBufferAlloc();
            for (int j2 = 0; j2 < traces.length; ++j2) {
                for (int i2 = 0; i2 < traces[j2].length; ++i2) {
                    if (j2 == traces.length / 2 && i2 == traces[j2].length / 2) {
                        if (kTest == 0) {
                            traces[j2][i2] = 1.0E16f;
                            continue;
                        }
                        if (kTest == 1) {
                            traces[j2][i2] = -1.0E16f;
                            continue;
                        }
                        traces[j2][i2] = (j2 + 1) * 1000 + (i2 + 1);
                        continue;
                    }
                    traces[j2][i2] = i2 < j2 + 1 ? 0.0f : (float)((j2 + 1) * 1000 + (i2 + 1));
                }
            }
            byte[] byteArray = new byte[traces.length * hdrLength * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            IntBuffer hdrIntBuffer = byteBuffer.asIntBuffer();
            Random random = new Random(28252388L);
            int count = 0;
            for (int j3 = 0; j3 < traces.length; ++j3) {
                for (int i3 = 0; i3 < hdrLength; ++i3) {
                    int value = 0;
                    if (kTest == 0) {
                        value = i3 * j3;
                    } else if (kTest == 1) {
                        value = i3;
                    } else if (kTest == 2) {
                        value = (int)(random.nextDouble() * 100000.0);
                    } else if (kTest == 3 || kTest == 4) {
                        value = (i3 + 1) * (j3 + 1);
                    }
                    hdrIntBuffer.put(count, value);
                    ++count;
                }
            }
            byte[] outputData = new byte[traces.length * traces[0].length * 4 + HdrCompressor.getOutputBufferSize(hdrLength, traces.length)];
            int nBytes = c.compress(traces, traces.length, hdrIntBuffer, hdrLength, outputData);
            int nLive = c.uncompress(outputData, nBytes, traces, hdrIntBuffer);
            for (j = 0; j < traces.length; ++j) {
                for (i = 0; i < traces[j].length; ++i) {
                    float expectedValue = j == 0 && i < 11 ? 0.0f : (j == traces.length / 2 && i == traces[j].length / 2 ? (kTest == 0 ? 1.0E16f : (kTest == 1 ? -1.0E16f : (float)((j + 1) * 1000 + (i + 1)))) : (i < j + 1 ? 0.0f : (float)((j + 1) * 1000 + (i + 1))));
                    if (kTest == 0 || kTest == 1) {
                        assert (traces[j][i] == expectedValue) : traces[j][i] + "!=" + expectedValue;
                        continue;
                    }
                    if (i < j + 1) assert (traces[j][i] == expectedValue);
                }
            }
            random = new Random(28252388L);
            count = 0;
            for (j = 0; j < traces.length; ++j) {
                for (i = 0; i < hdrLength; ++i) {
                    int expectedValue = 0;
                    if (kTest == 0) {
                        expectedValue = i * j;
                    } else if (kTest == 1) {
                        expectedValue = i;
                    } else if (kTest == 2) {
                        expectedValue = (int)(random.nextDouble() * 100000.0);
                    } else if (kTest == 3 || kTest == 4) {
                        expectedValue = (i + 1) * (j + 1);
                    }
                    assert (hdrIntBuffer.get(count) == expectedValue);
                    ++count;
                }
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.combinedTest ***** SUCCESS *****");
    }

    private static void hdrRunLengthTest() {
        HdrCompressor hdrCompressor = new HdrCompressor();
        int[] encodedValues = new int[1024];
        int[] outValues = new int[1024];
        int runSymbolConst = 34324234;
        int runSymbolAscend = 45235923;
        int runSymbolDescend = 25834568;
        int runSymbolDelta = 58234832;
        int runSymbolFloats = 68343921;
        int endOfData = runSymbolConst;
        int nTests = 14;
        int[][] inValues = new int[nTests][];
        int[] expectedOutputLengths = new int[nTests];
        inValues[0] = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[0] = inValues[0].length - 1 + 10;
        inValues[1] = new int[]{0, 0, 0, 1, -1, 2, -2, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[1] = inValues[1].length - 1 + 10;
        inValues[2] = new int[]{0, 0, 0, 0, 1, -1, 2, -2, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[2] = inValues[2].length - 1 - 1 + 10;
        inValues[3] = new int[]{0, 0, 0, 0, 1, 2, 3, 4, -1, 2, -2, -3, -4, -5, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[3] = inValues[3].length - 3 - 1 + 10;
        inValues[4] = new int[]{0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, -1, 2, -2, -3, -4, -5, -6, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[4] = expectedOutputLengths[3];
        inValues[5] = new int[]{0, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 6, -1, 2, -2, -3, -4, -5, -6, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[5] = expectedOutputLengths[3];
        inValues[6] = new int[]{6, 5, 4, 3, 2, 1, 1, 2, 3, 4, 5, 6, -1, 2, -2, -3, -4, -5, -6, 3, 3, 3, -3, 4, -4, endOfData};
        expectedOutputLengths[6] = expectedOutputLengths[3];
        inValues[7] = new int[]{-2, 0, 2, 4, 6, 8, 10, 12, 14, 16, endOfData};
        expectedOutputLengths[7] = 14;
        inValues[8] = new int[]{-2, -5, -8, -11, -14, -17, -20, -23, -26, -29, endOfData};
        expectedOutputLengths[8] = 14;
        inValues[9] = new int[]{1, 2, 4, 6, 8, 10, 12, 14, 16, 17, endOfData};
        expectedOutputLengths[9] = 16;
        inValues[10] = new int[]{Float.floatToIntBits(1.0f), Float.floatToIntBits(11.0f), Float.floatToIntBits(21.0f), Float.floatToIntBits(31.0f), Float.floatToIntBits(41.0f), Float.floatToIntBits(51.0f), Float.floatToIntBits(61.0f), Float.floatToIntBits(71.0f), endOfData};
        expectedOutputLengths[10] = 14;
        inValues[11] = new int[]{Float.floatToIntBits(1.000001E7f), Float.floatToIntBits(1.000011E7f), Float.floatToIntBits(1.000021E7f), Float.floatToIntBits(1.000031E7f), Float.floatToIntBits(1.000041E7f), Float.floatToIntBits(1.000051E7f), Float.floatToIntBits(1.000061E7f), Float.floatToIntBits(1.000071E7f), endOfData};
        expectedOutputLengths[11] = 14;
        inValues[12] = new int[]{Float.floatToIntBits(1.0000001E8f), Float.floatToIntBits(1.0000011E8f), Float.floatToIntBits(1.0000021E8f), Float.floatToIntBits(1.0000031E8f), Float.floatToIntBits(1.0000041E8f), Float.floatToIntBits(1.0000051E8f), Float.floatToIntBits(1.0000061E8f), Float.floatToIntBits(1.0000071E8f), endOfData};
        expectedOutputLengths[12] = 18;
        inValues[13] = new int[]{Float.floatToIntBits(-1.0f), Float.floatToIntBits(-101.0f), Float.floatToIntBits(-201.0f), Float.floatToIntBits(-301.0f), Float.floatToIntBits(-401.0f), Float.floatToIntBits(-501.0f), Float.floatToIntBits(-601.0f), Float.floatToIntBits(-701.0f), endOfData};
        expectedOutputLengths[13] = 14;
        for (int j = 0; j < inValues.length; ++j) {
            int nCompressed = hdrCompressor.runLengthEncode(inValues[j], runSymbolConst, runSymbolAscend, runSymbolDescend, runSymbolDelta, runSymbolFloats, endOfData, encodedValues);
            assert (nCompressed == expectedOutputLengths[j]) : nCompressed + "!=" + expectedOutputLengths[j] + " " + j;
            int nUncompressed = hdrCompressor.runLengthDecode(encodedValues, outValues);
            assert (nUncompressed == inValues[j].length - 1) : nUncompressed + "!=" + (inValues[j].length - 1) + " " + j;
            for (int i = 0; i < nUncompressed; ++i) {
                assert (outValues[i] == inValues[j][i]);
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.hdrRunLengthTest ***** SUCCESS *****");
    }

    private static void hdrIntBufferTest() throws Exception {
        HdrCompressor hdrCompressor = new HdrCompressor();
        int offset = 123;
        int nTests = 5;
        int[] hdrLength = new int[]{55, 55, 550, 72, 1};
        int[] nTraces = new int[]{100, 100, 100, 1, 72};
        for (int iTest = 0; iTest < nTests; ++iTest) {
            int nBytes;
            int i;
            int bufferByteSize = hdrLength[iTest] * nTraces[iTest] * 4;
            byte[] byteArray = new byte[offset + bufferByteSize];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            IntBuffer hdrIntBuffer = byteBuffer.asIntBuffer();
            Random random = new Random(28252388L);
            int count = 0;
            for (int j = 0; j < nTraces[iTest]; ++j) {
                for (i = 0; i < hdrLength[iTest]; ++i) {
                    int value = 0;
                    if (iTest == 0) {
                        value = i * j;
                    } else if (iTest == 1) {
                        value = i;
                    } else if (iTest == 2) {
                        value = (int)(random.nextDouble() * 100000.0);
                    } else if (iTest == 3 || iTest == 4) {
                        value = (i + 1) * (j + 1);
                    }
                    hdrIntBuffer.put(count, value);
                    ++count;
                }
            }
            for (i = nBytes = hdrCompressor.compress(hdrIntBuffer, hdrLength[iTest], (float[][])null, nTraces[iTest], byteArray, offset); i < bufferByteSize; ++i) {
                byteArray[i + offset] = 0;
            }
            int nLive = hdrCompressor.uncompress(byteArray, offset, nBytes, hdrIntBuffer, (float[][])null);
            assert (nLive == nTraces[iTest]);
            random = new Random(28252388L);
            count = 0;
            for (int j = 0; j < nTraces[iTest]; ++j) {
                for (int i2 = 0; i2 < hdrLength[iTest]; ++i2) {
                    int expectedValue = 0;
                    if (iTest == 0) {
                        expectedValue = i2 * j;
                    } else if (iTest == 1) {
                        expectedValue = i2;
                    } else if (iTest == 2) {
                        expectedValue = (int)(random.nextDouble() * 100000.0);
                    } else if (iTest == 3 || iTest == 4) {
                        expectedValue = (i2 + 1) * (j + 1);
                    }
                    assert (hdrIntBuffer.get(count) == expectedValue);
                    ++count;
                }
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.hdrIntBufferTest ***** SUCCESS *****");
    }

    private static void hdrFullMethodTest() throws Exception {
        HdrCompressor hdrCompressor = new HdrCompressor();
        int nTraces = 120;
        int hdrLength = 62;
        int[][] hdrs = new int[nTraces][hdrLength];
        Random random = new Random(53453653L);
        for (int i = 0; i < hdrLength; ++i) {
            for (int j = 0; j < nTraces; ++j) {
                hdrs[j][i] = i < 5 ? j : (i < 10 ? Float.floatToIntBits(j) : (i < 15 ? i : (int)(random.nextDouble() * 100.0)));
            }
        }
        int offset = 100;
        byte[] encodedBytes = new byte[offset + HdrCompressor.getOutputBufferSize(hdrLength, nTraces)];
        int nBytes = hdrCompressor.compress(hdrs, hdrLength, (float[][])null, nTraces, encodedBytes, offset);
        int nLive = hdrCompressor.uncompress(encodedBytes, offset, nBytes, hdrs, (float[][])null);
        assert (nLive == nTraces);
        random = new Random(53453653L);
        for (int i = 0; i < hdrLength; ++i) {
            for (int j = 0; j < nTraces; ++j) {
                int expectedVal = i < 5 ? j : (i < 10 ? Float.floatToIntBits(j) : (i < 15 ? i : (int)(random.nextDouble() * 100.0)));
                assert (hdrs[j][i] == expectedVal);
            }
        }
        LOG.info("org.javaseis.seiszip.CompressorTest.hdrFullMethodTest ***** SUCCESS *****");
    }

    public static void main(String[] args) throws Exception {
        CompressorTest.originalTest(true);
        CompressorTest.originalTest(false);
        CompressorTest.integrityTest();
        CompressorTest.badAmplitudeTest();
        CompressorTest.combinedTest();
        CompressorTest.hdrRunLengthTest();
        CompressorTest.hdrIntBufferTest();
        CompressorTest.hdrFullMethodTest();
        System.exit(0);
    }
}

