/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.fft;

import java.util.Arrays;
import org.javaseis.array.TransposeType;
import org.javaseis.fft.IFFT;
import org.javaseis.fft.SeisFft;
import org.javaseis.parallel.Decomposition;
import org.javaseis.parallel.DistributedArray;
import org.javaseis.parallel.IParallelContext;

public class SeisFft3d {
    public static final boolean SHOW_FORWARD_PLOTS = false;
    public static final boolean SHOW_INVERSE_PLOTS = false;
    public static final boolean CHATTY = false;
    private final IFFT _f1;
    private final IFFT _f2;
    private final IFFT _f3;
    private DistributedArray _a;
    private final int[] _inputShape;
    private final int[] _fftLengths;
    private final int[] _fftShape;
    private final int[] _padShape;
    private final int[] _fpadShape;
    private int[] _fftSigns;
    private double[] _timeDomainSampleRate;
    private boolean _isTransformed = false;

    public static int[] getTransformShape(int[] lengths, float[] pad, IParallelContext pc) {
        return SeisFft3d.getTransformShape(lengths, pad, pc.size());
    }

    public static int[] getTransformShape(int[] lengths, float[] pad, int size) {
        int[] len = new int[3];
        int flen = SeisFft.length(lengths[0], pad[0], IFFT.Type.REAL);
        len[0] = (int)Decomposition.paddedLength(1 + flen / 2, size);
        flen = SeisFft.length(lengths[1], pad[1], IFFT.Type.COMPLEX);
        len[1] = (int)Decomposition.paddedLength(flen, size);
        flen = SeisFft.length(lengths[2], pad[2], IFFT.Type.COMPLEX);
        len[2] = (int)Decomposition.paddedLength(flen, size);
        return len;
    }

    public SeisFft3d(int[] len, DistributedArray a) {
        this(a.getParallelContext(), len, new float[]{0.0f, 0.0f, 0.0f}, new int[]{-1, 1, 1}, a);
    }

    public SeisFft3d(DistributedArray a) {
        this(a.getParallelContext(), a.getShape(), new float[]{0.0f, 0.0f, 0.0f}, new int[]{-1, 1, 1}, a);
    }

    public SeisFft3d(int[] len, float[] pad, DistributedArray a) {
        this(a.getParallelContext(), len, pad, new int[]{-1, 1, 1}, a);
    }

    public SeisFft3d(int[] len, float[] pad, int[] isign, DistributedArray a) {
        this(a.getParallelContext(), len, pad, isign, a);
    }

    public SeisFft3d(IParallelContext pc, int[] len, float[] pad) {
        this(pc, len, pad, new int[]{-1, 1, 1}, null);
    }

    public SeisFft3d(IParallelContext pc, int[] len, float[] pad, int[] isign) {
        this(pc, len, pad, isign, null);
    }

    public SeisFft3d(IParallelContext pc, int[] len, float[] pad, int[] isign, DistributedArray a) {
        assert (len.length > 2);
        assert (pad.length > 2);
        assert (isign.length > 2);
        this._fftSigns = new int[]{isign[0], isign[1], isign[2]};
        this._f1 = isign[0] != 0 ? new SeisFft(len[0], pad[0], IFFT.Type.REAL, isign[0]) : new SeisFft(len[0], pad[0], IFFT.Type.REAL);
        this._f2 = isign[1] != 0 ? new SeisFft(len[1], pad[1], IFFT.Type.COMPLEX, isign[1]) : new SeisFft(len[1], pad[1], IFFT.Type.COMPLEX);
        this._f3 = isign[2] != 0 ? new SeisFft(len[2], pad[2], IFFT.Type.COMPLEX, isign[2]) : new SeisFft(len[2], pad[2], IFFT.Type.COMPLEX);
        this._fftLengths = new int[]{this._f1.getLength(), this._f2.getLength(), this._f3.getLength()};
        if (a != null) {
            this._a = a;
        } else {
            int[] lengths = (int[])this._fftLengths.clone();
            lengths[0] = lengths[0] / 2 + 1;
            int elementCount = 2;
            int[] d = new int[]{Decomposition.BLOCK, Decomposition.BLOCK, Decomposition.BLOCK};
            this._a = new DistributedArray(pc, Float.TYPE, 3, elementCount, lengths, d);
            this._a.setElementCount(1);
        }
        this._inputShape = (int[])len.clone();
        this._a.setShape(len);
        this._fftShape = (int[])this._fftLengths.clone();
        this._fftShape[0] = 1 + this._fftLengths[0] / 2;
        this._padShape = (int[])this._inputShape.clone();
        this._fpadShape = (int[])this._fftShape.clone();
        for (int i = 0; i < 3; ++i) {
            this._padShape[i] = (int)Decomposition.paddedLength(this._inputShape[i], pc.size());
            this._fpadShape[i] = (int)Decomposition.paddedLength(this._fftShape[i], pc.size());
        }
        this._isTransformed = false;
    }

    public SeisFft3d(DistributedArray KyKxF, int[] isign) {
        assert (isign.length > 2);
        this._a = KyKxF;
        this._isTransformed = true;
        int[] len = KyKxF.getShape();
        this._fftSigns = new int[]{isign[0], isign[1], isign[2]};
        int ret = this.guaranteeMatchedShape(2 * len[2], 0.0f, IFFT.Type.REAL);
        this._f1 = isign[0] != 0 ? new SeisFft(ret, 0.0f, IFFT.Type.REAL, isign[0]) : new SeisFft(ret, 0.0f, IFFT.Type.REAL);
        ret = this.guaranteeMatchedShape(2 * len[1], 0.0f, IFFT.Type.COMPLEX);
        this._f2 = isign[1] != 0 ? new SeisFft(ret, 0.0f, IFFT.Type.COMPLEX, isign[1]) : new SeisFft(ret, 0.0f, IFFT.Type.COMPLEX);
        ret = this.guaranteeMatchedShape(2 * len[0], 0.0f, IFFT.Type.COMPLEX);
        this._f3 = isign[2] != 0 ? new SeisFft(ret, 0.0f, IFFT.Type.COMPLEX, isign[2]) : new SeisFft(ret, 0.0f, IFFT.Type.COMPLEX);
        this._fftLengths = new int[]{this._f1.getLength(), this._f2.getLength(), this._f3.getLength()};
        this._inputShape = new int[]{this._fftLengths[0], this._fftLengths[1], this._fftLengths[2]};
        this._fftShape = (int[])this._fftLengths.clone();
        this._fftShape[0] = 1 + this._fftLengths[0] / 2;
        this._padShape = (int[])this._inputShape.clone();
        this._fpadShape = (int[])this._fftShape.clone();
    }

    private final int guaranteeMatchedShape(int matchLen, float pad, IFFT.Type type) {
        SeisFft fft;
        if (matchLen < 2) {
            throw new IllegalArgumentException("len cannot be less than 2");
        }
        int len = Math.min(2, matchLen / 2);
        while ((fft = new SeisFft(len, pad, type)).getArrayLength() <= matchLen) {
            len += 10;
        }
        while (len > 2 && (fft = new SeisFft(len, pad, type)).getArrayLength() > matchLen) {
            --len;
        }
        return len;
    }

    public final void debugPrint(String banner) {
        System.out.println("***********************************************");
        System.out.println(banner);
        System.out.printf("_inputShape = %d %d %d\n", this._inputShape[0], this._inputShape[1], this._inputShape[2]);
        System.out.printf("_fftLengths = %d %d %d\n", this._fftLengths[0], this._fftLengths[1], this._fftLengths[2]);
        System.out.printf("shape = %d %d %d\n", this._a.getShape()[0], this._a.getShape()[1], this._a.getShape()[2]);
        System.out.println("***********************************************");
    }

    public DistributedArray getArray() {
        return this._a;
    }

    public int[] getShape() {
        return this._a.getShape();
    }

    public int[] getFftShape() {
        return (int[])this._fftShape.clone();
    }

    public int[] getFftLengths() {
        return (int[])this._fftLengths.clone();
    }

    public int[] getFftSigns() {
        return (int[])this._fftSigns.clone();
    }

    public void forward(DistributedArray a, DistributedArray b) {
        int j;
        int k;
        if (a.getDimensions() < 3 || b.getDimensions() < 3 || a.getElementCount() != 1 || b.getElementCount() != 2) {
            throw new RuntimeException("\nInput arrays have wrong dimensions or element counts");
        }
        if (a.getLength(0) < this._inputShape[0] || a.getLength(1) < this._inputShape[1] || a.getLength(2) != this._inputShape[2] || a.getElementCount() != 1) {
            throw new RuntimeException("\nInput DistributedArray shape " + Arrays.toString(b.getShape()) + "\nmust match or exceed SeisFft3d input shape " + Arrays.toString(this._inputShape));
        }
        if (b.getLength(0) < this._fftShape[0] || b.getLength(1) < this._fftShape[1] || b.getLength(2) != this._fftShape[2] || b.getElementCount() != 2) {
            throw new RuntimeException("\nOutput DistributedArray shape " + Arrays.toString(b.getShape()) + "\nmust match or exceed SeisFft3d fft shape " + Arrays.toString(this._fftShape));
        }
        int[] position = new int[]{0, 0, 0};
        int nt = this._inputShape[0];
        int nx = this._inputShape[1];
        int ny = this._inputShape[2];
        int nft = this._fftShape[0];
        int nkx = this._fftShape[1];
        int nky = this._fftShape[2];
        int ntp = this._padShape[0];
        int nxp = this._padShape[1];
        int nyp = this._padShape[2];
        int nftp = this._fpadShape[0];
        int nkxp = this._fpadShape[1];
        int nkyp = this._fpadShape[2];
        int len = Math.max(2 * nkx, 2 * nky);
        len = Math.max(len, 2 * nft);
        float[] c = new float[len];
        a.makeLegalForTranspose();
        b.makeLegalForTranspose();
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nx) {
                position[1] = j++;
                a.getTrace(c, position);
                this._f1.realToComplex(c);
                b.putTrace(c, position);
            }
        }
        b.transpose(TransposeType.T213);
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nft) {
                position[1] = j++;
                b.getTrace(c, position);
                this._f2.complexForward(c);
                b.putTrace(c, position);
            }
        }
        b.transpose(TransposeType.T312);
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= nft) continue;
            j = 0;
            while (j < nkx) {
                position[1] = j++;
                b.getTrace(c, position);
                this._f3.complexForward(c);
                b.putTrace(c, position);
            }
        }
    }

    public void forward() {
        int j;
        int k;
        if (this._a.getLength(0) != this._inputShape[0] || this._a.getLength(1) != this._inputShape[1] || this._a.getLength(2) != this._inputShape[2] || this._a.getElementCount() != 1) {
            throw new RuntimeException("\nDistributedArray shape " + Arrays.toString(this._a.getShape()) + "\nDoes not match SeisFft3d input shape " + Arrays.toString(this._inputShape));
        }
        int[] position = new int[]{0, 0, 0};
        int nt = this._inputShape[0];
        int nx = this._inputShape[1];
        int ny = this._inputShape[2];
        int nft = this._fftShape[0];
        int nkx = this._fftShape[1];
        int nky = this._fftShape[2];
        int ntp = this._padShape[0];
        int nxp = this._padShape[1];
        int nyp = this._padShape[2];
        int nftp = this._fpadShape[0];
        int nkxp = this._fpadShape[1];
        int nkyp = this._fpadShape[2];
        int len = Math.max(2 * nkx, 2 * nky);
        len = Math.max(len, 2 * nft);
        float[] c = new float[len];
        this._a.setShape(new int[]{nt, nx, nyp});
        this._a.reshape(new int[]{2 * nftp, nkx, nyp});
        DistributedArray r = this._a.distributedView();
        this._a.setElementCount(2);
        this._a.setShape(new int[]{nftp, nkx, nyp});
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nx) {
                position[1] = j++;
                r.getTrace(c, position);
                this._f1.realToComplex(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.makeLegalForTranspose();
        this._a.transpose(TransposeType.T213);
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nft) {
                position[1] = j++;
                this._a.getTrace(c, position);
                this._f2.complexForward(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.transpose(TransposeType.T312);
        this._a.reshape(new int[]{nky, nkx, nftp});
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= nft) continue;
            j = 0;
            while (j < nkx) {
                position[1] = j++;
                this._a.getTrace(c, position);
                this._f3.complexForward(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.setShape(2, new int[]{nky, nkx, nft});
        this._isTransformed = true;
    }

    public void inverse() {
        int j;
        int k;
        if (this._a.getLength(0) != this._fftShape[2] || this._a.getLength(1) != this._fftShape[1] || this._a.getLength(2) != this._fftShape[0] || this._a.getElementCount() != 2) {
            throw new RuntimeException("\nDistributedArray shape " + Arrays.toString(this._a.getShape()) + "\nDoes not match transform shape " + Arrays.toString(this._fftShape));
        }
        int[] position = new int[]{0, 0, 0};
        int nt = this._inputShape[0];
        int nx = this._inputShape[1];
        int ny = this._inputShape[2];
        int nft = this._fftShape[0];
        int nkx = this._fftShape[1];
        int nky = this._fftShape[2];
        int ntp = this._padShape[0];
        int nxp = this._padShape[1];
        int nyp = this._padShape[2];
        int nftp = this._fpadShape[0];
        int nkxp = this._fpadShape[1];
        int nkyp = this._fpadShape[2];
        int len = Math.max(2 * nkx, 2 * nky);
        len = Math.max(len, 2 * nft);
        float[] c = new float[len];
        this._a.setShape(new int[]{nky, nkx, nftp});
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= nft) continue;
            j = 0;
            while (j < nkx) {
                position[1] = j++;
                this._a.getTrace(c, position);
                this._f3.complexInverse(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.reshape(new int[]{nyp, nkx, nftp});
        this._a.makeLegalForTranspose();
        this._a.transpose(TransposeType.T231);
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nft) {
                position[1] = j++;
                this._a.getTrace(c, position);
                this._f2.complexInverse(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.makeLegalForTranspose();
        this._a.transpose(TransposeType.T213);
        for (k = 0; k < this._a.getLocalLength(2); ++k) {
            position[2] = this._a.localToGlobal(2, k);
            if (position[2] >= ny) continue;
            j = 0;
            while (j < nx) {
                position[1] = j++;
                this._a.getTrace(c, position);
                this._f1.complexToReal(c);
                this._a.putTrace(c, position);
            }
        }
        this._a.reshape(1, new int[]{nt, nx, nyp});
        this._a.setShape(new int[]{nt, nx, ny});
        this._isTransformed = false;
    }

    public void setTXYSampleRates(double[] sampleRates) {
        if (this._timeDomainSampleRate == null) {
            this._timeDomainSampleRate = new double[3];
        }
        this._timeDomainSampleRate[0] = sampleRates[0];
        this._timeDomainSampleRate[1] = sampleRates[1];
        this._timeDomainSampleRate[2] = sampleRates[2];
    }

    public void getKyKxFCoordinatesForPosition(int[] position, double[] buf) {
        if (this._timeDomainSampleRate == null) {
            throw new IllegalStateException("You need to call setTXYSampleRates() before calling this method.");
        }
        int pos0 = position[0];
        int pos1 = position[1];
        int pos2 = position[2];
        if (pos0 > this._fftLengths[2] / 2) {
            pos0 -= this._fftLengths[2];
        }
        if (pos1 > this._fftLengths[1] / 2) {
            pos1 -= this._fftLengths[1];
        }
        buf[0] = (double)pos0 / (this._timeDomainSampleRate[2] * (double)this._fftLengths[2]);
        buf[1] = (double)pos1 / (this._timeDomainSampleRate[1] * (double)this._fftLengths[1]);
        buf[2] = (double)pos2 / (this._timeDomainSampleRate[0] * (double)this._fftLengths[0]);
    }
}

